/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.optifine.Config;
import net.optifine.shaders.ShadersTex;
import org.slf4j.Logger;

public class DynamicTexture
extends AbstractTexture
implements Dumpable {
    private static final Logger f_117976_ = LogUtils.getLogger();
    @Nullable
    private NativeImage f_117977_;

    public DynamicTexture(NativeImage nativeImageIn) {
        this.f_117977_ = nativeImageIn;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                TextureUtil.prepareImage((int)this.m_117963_(), (int)this.f_117977_.m_84982_(), (int)this.f_117977_.m_85084_());
                this.m_117985_();
                if (Config.isShaders()) {
                    ShadersTex.initDynamicTextureNS((DynamicTexture)this);
                }
            });
        } else {
            TextureUtil.prepareImage((int)this.m_117963_(), (int)this.f_117977_.m_84982_(), (int)this.f_117977_.m_85084_());
            this.m_117985_();
            if (Config.isShaders()) {
                ShadersTex.initDynamicTextureNS((DynamicTexture)this);
            }
        }
    }

    public DynamicTexture(int widthIn, int heightIn, boolean clearIn) {
        RenderSystem.assertOnGameThreadOrInit();
        this.f_117977_ = new NativeImage(widthIn, heightIn, clearIn);
        TextureUtil.prepareImage((int)this.m_117963_(), (int)this.f_117977_.m_84982_(), (int)this.f_117977_.m_85084_());
        if (Config.isShaders()) {
            ShadersTex.initDynamicTextureNS((DynamicTexture)this);
        }
    }

    public void m_6704_(ResourceManager manager) {
    }

    public void m_117985_() {
        if (this.f_117977_ != null) {
            this.m_117966_();
            this.f_117977_.m_85040_(0, 0, 0, false);
        } else {
            f_117976_.warn("Trying to upload disposed texture {}", (Object)this.m_117963_());
        }
    }

    @Nullable
    public NativeImage m_117991_() {
        return this.f_117977_;
    }

    public void m_117988_(NativeImage nativeImageIn) {
        if (this.f_117977_ != null) {
            this.f_117977_.close();
        }
        this.f_117977_ = nativeImageIn;
    }

    public void close() {
        if (this.f_117977_ != null) {
            this.f_117977_.close();
            this.m_117964_();
            this.f_117977_ = null;
        }
    }

    public void m_276079_(ResourceLocation locIn, Path pathIn) throws IOException {
        if (this.f_117977_ != null) {
            String s = locIn.m_179910_() + ".png";
            Path path = pathIn.resolve(s);
            this.f_117977_.m_85066_(path);
        }
    }
}

