/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.optifine.Config;
import net.optifine.CustomItems;

public class ElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation f_116934_ = new ResourceLocation("textures/entity/elytra.png");
    private final ElytraModel<T> f_116935_;

    public ElytraLayer(RenderLayerParent<T, M> parentIn, EntityModelSet modelSetIn) {
        super(parentIn);
        this.f_116935_ = new ElytraModel(modelSetIn.m_171103_(ModelLayers.f_171141_));
    }

    public void m_6494_(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = entitylivingbaseIn.m_6844_(EquipmentSlot.CHEST);
        if (this.shouldRender(itemstack, entitylivingbaseIn)) {
            ResourceLocation resourcelocation;
            if (entitylivingbaseIn instanceof AbstractClientPlayer) {
                AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entitylivingbaseIn;
                if (abstractclientplayer.m_108562_() && abstractclientplayer.m_108563_() != null) {
                    resourcelocation = abstractclientplayer.m_108563_();
                } else if (abstractclientplayer.hasElytraCape() && abstractclientplayer.m_108555_() && abstractclientplayer.m_108561_() != null && abstractclientplayer.m_36170_(PlayerModelPart.CAPE)) {
                    resourcelocation = abstractclientplayer.m_108561_();
                } else {
                    resourcelocation = this.getElytraTexture(itemstack, entitylivingbaseIn);
                    if (Config.isCustomItems()) {
                        resourcelocation = CustomItems.getCustomElytraTexture((ItemStack)itemstack, (ResourceLocation)resourcelocation);
                    }
                }
            } else {
                resourcelocation = this.getElytraTexture(itemstack, entitylivingbaseIn);
                if (Config.isCustomItems()) {
                    resourcelocation = CustomItems.getCustomElytraTexture((ItemStack)itemstack, (ResourceLocation)resourcelocation);
                }
            }
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, 0.0f, 0.125f);
            this.m_117386_().m_102624_((EntityModel)this.f_116935_);
            this.f_116935_.m_6973_(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110431_((ResourceLocation)resourcelocation), (boolean)false, (boolean)itemstack.m_41790_());
            this.f_116935_.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
        }
    }

    public boolean shouldRender(ItemStack stack, T entity) {
        return stack.m_150930_(Items.f_42741_);
    }

    public ResourceLocation getElytraTexture(ItemStack stack, T entity) {
        return f_116934_;
    }
}

