/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.MatrixUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomItems;
import net.optifine.EmissiveTextures;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.render.VertexBuilderWrapper;
import net.optifine.shaders.Shaders;
import net.optifine.util.SingleIterable;
import org.joml.Matrix4f;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemRenderer
implements ResourceManagerReloadListener {
    public static final ResourceLocation f_273897_ = new ResourceLocation("textures/misc/enchanted_glint_entity.png");
    public static final ResourceLocation f_273833_ = new ResourceLocation("textures/misc/enchanted_glint_item.png");
    private static final Set<Item> f_115094_ = Sets.newHashSet((Object[])new Item[]{Items.f_41852_});
    public static final int f_174221_ = 8;
    public static final int f_174222_ = 8;
    public static final int f_174218_ = 200;
    public static final float f_174219_ = 0.5f;
    public static final float f_174220_ = 0.75f;
    public static final float f_256734_ = 0.0078125f;
    private static final ModelResourceLocation f_244324_ = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    public static final ModelResourceLocation f_244055_ = ModelResourceLocation.m_245263_((String)"trident_in_hand", (String)"inventory");
    private static final ModelResourceLocation f_244537_ = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");
    public static final ModelResourceLocation f_243706_ = ModelResourceLocation.m_245263_((String)"spyglass_in_hand", (String)"inventory");
    private final Minecraft f_265848_;
    private final ItemModelShaper f_115095_;
    private final TextureManager f_115096_;
    private final ItemColors f_115097_;
    private final BlockEntityWithoutLevelRenderer f_174223_;
    public ModelManager modelManager = null;
    private static boolean renderItemGui = false;

    public ItemRenderer(Minecraft minecraftIn, TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn, BlockEntityWithoutLevelRenderer blockEntityRendererIn) {
        this.f_265848_ = minecraftIn;
        this.f_115096_ = textureManagerIn;
        this.modelManager = modelManagerIn;
        this.f_115095_ = Reflector.ForgeItemModelShaper_Constructor.exists() ? (ItemModelShaper)Reflector.newInstance((ReflectorConstructor)Reflector.ForgeItemModelShaper_Constructor, (Object[])new Object[]{this.modelManager}) : new ItemModelShaper(modelManagerIn);
        this.f_174223_ = blockEntityRendererIn;
        for (Item item : BuiltInRegistries.f_257033_) {
            if (f_115094_.contains(item)) continue;
            this.f_115095_.m_109396_(item, new ModelResourceLocation(BuiltInRegistries.f_257033_.m_7981_((Object)item), "inventory"));
        }
        this.f_115097_ = itemColorsIn;
    }

    public ItemModelShaper m_115103_() {
        return this.f_115095_;
    }

    public void m_115189_(BakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, VertexConsumer bufferIn) {
        if (Config.isMultiTexture()) {
            bufferIn.setRenderBlocks(true);
        }
        RandomSource randomsource = RandomSource.m_216327_();
        long i2 = 42L;
        for (Direction direction : Direction.f_122346_) {
            randomsource.m_188584_(42L);
            this.m_115162_(matrixStackIn, bufferIn, modelIn.m_213637_((BlockState)null, direction, randomsource), stack, combinedLightIn, combinedOverlayIn);
        }
        randomsource.m_188584_(42L);
        this.m_115162_(matrixStackIn, bufferIn, modelIn.m_213637_((BlockState)null, (Direction)null, randomsource), stack, combinedLightIn, combinedOverlayIn);
    }

    public void m_115143_(ItemStack itemStackIn, ItemDisplayContext transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn) {
        if (!itemStackIn.m_41619_()) {
            boolean flag;
            matrixStackIn.m_85836_();
            boolean bl = flag = transformTypeIn == ItemDisplayContext.GUI || transformTypeIn == ItemDisplayContext.GROUND || transformTypeIn == ItemDisplayContext.FIXED;
            if (flag) {
                if (itemStackIn.m_150930_(Items.f_42713_)) {
                    modelIn = this.f_115095_.m_109393_().m_119422_(f_244324_);
                } else if (itemStackIn.m_150930_(Items.f_151059_)) {
                    modelIn = this.f_115095_.m_109393_().m_119422_(f_244537_);
                }
            }
            if (Reflector.ForgeHooksClient_handleCameraTransforms.exists()) {
                modelIn = (BakedModel)Reflector.ForgeHooksClient_handleCameraTransforms.call(new Object[]{matrixStackIn, modelIn, transformTypeIn, leftHand});
            } else {
                modelIn.m_7442_().m_269404_(transformTypeIn).m_111763_(leftHand, matrixStackIn);
            }
            matrixStackIn.m_252880_(-0.5f, -0.5f, -0.5f);
            if (!(modelIn.m_7521_() || itemStackIn.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemDisplayContext.GUI && !transformTypeIn.m_269069_() && itemStackIn.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                boolean forge = Reflector.ForgeHooksClient.exists();
                List renderPassModels = forge ? modelIn.getRenderPasses(itemStackIn, flag1) : new SingleIterable((Object)modelIn);
                List renderTypes = forge ? modelIn.getRenderTypes(itemStackIn, flag1) : new SingleIterable((Object)ItemBlockRenderTypes.m_109279_((ItemStack)itemStackIn, (boolean)flag1));
                Iterator iterator = renderPassModels.iterator();
                while (iterator.hasNext()) {
                    BakedModel modelForge;
                    modelIn = modelForge = (BakedModel)iterator.next();
                    Iterator iterator2 = renderTypes.iterator();
                    while (iterator2.hasNext()) {
                        VertexConsumer vertexconsumer;
                        RenderType rendertype = (RenderType)iterator2.next();
                        if (ItemRenderer.m_285827_((ItemStack)itemStackIn) && itemStackIn.m_41790_()) {
                            matrixStackIn.m_85836_();
                            PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
                            if (transformTypeIn == ItemDisplayContext.GUI) {
                                MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.5f);
                            } else if (transformTypeIn.m_269069_()) {
                                MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.75f);
                            }
                            vertexconsumer = flag1 ? ItemRenderer.m_115207_((MultiBufferSource)bufferIn, (RenderType)rendertype, (PoseStack.Pose)posestack$pose) : ItemRenderer.m_115180_((MultiBufferSource)bufferIn, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                            matrixStackIn.m_85849_();
                        } else {
                            vertexconsumer = flag1 ? ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.m_41790_());
                        }
                        if (Config.isCustomItems()) {
                            modelIn = CustomItems.getCustomItemModel((ItemStack)itemStackIn, (BakedModel)modelIn, (ResourceLocation)ItemOverrides.lastModelLocation, (boolean)false);
                            ItemOverrides.lastModelLocation = null;
                        }
                        if (EmissiveTextures.isActive()) {
                            EmissiveTextures.beginRender();
                        }
                        this.m_115189_(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, vertexconsumer);
                        if (!EmissiveTextures.isActive()) continue;
                        if (EmissiveTextures.hasEmissive()) {
                            EmissiveTextures.beginRenderEmissive();
                            VertexConsumer vertexBuilderEmissive = vertexconsumer instanceof VertexBuilderWrapper ? ((VertexBuilderWrapper)vertexconsumer).getVertexBuilder() : vertexconsumer;
                            this.m_115189_(modelIn, itemStackIn, LightTexture.MAX_BRIGHTNESS, combinedOverlayIn, matrixStackIn, vertexBuilderEmissive);
                            EmissiveTextures.endRenderEmissive();
                        }
                        EmissiveTextures.endRender();
                    }
                }
            } else if (Reflector.MinecraftForge.exists()) {
                IClientItemExtensions.of((ItemStack)itemStackIn).getCustomRenderer().m_108829_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            } else {
                this.f_174223_.m_108829_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.m_85849_();
        }
    }

    private static boolean m_285827_(ItemStack itemStackIn) {
        return itemStackIn.m_204117_(ItemTags.f_215866_) || itemStackIn.m_150930_(Items.f_42524_);
    }

    public static VertexConsumer m_115184_(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean hasEffectIn) {
        if (Shaders.isShadowPass) {
            hasEffectIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            hasEffectIn = false;
        }
        return hasEffectIn ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(isItemIn ? RenderType.m_110481_() : RenderType.m_110484_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn)) : bufferIn.m_6299_(renderTypeIn);
    }

    public static VertexConsumer m_115180_(MultiBufferSource bufferIn, RenderType renderTypeIn, PoseStack.Pose entryIn) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(bufferIn.m_6299_(RenderType.m_110490_()), entryIn.m_252922_(), entryIn.m_252943_(), 0.0078125f), (VertexConsumer)bufferIn.m_6299_(renderTypeIn));
    }

    public static VertexConsumer m_115207_(MultiBufferSource bufferIn, RenderType renderTypeIn, PoseStack.Pose entryIn) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(bufferIn.m_6299_(RenderType.m_110493_()), entryIn.m_252922_(), entryIn.m_252943_(), 0.0078125f), (VertexConsumer)bufferIn.m_6299_(renderTypeIn));
    }

    public static VertexConsumer m_115211_(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        if (Shaders.isShadowPass) {
            glintIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            glintIn = false;
        }
        if (glintIn) {
            return Minecraft.m_91085_() && renderTypeIn == Sheets.m_110791_() ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(RenderType.m_110487_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn)) : VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(isItemIn ? RenderType.m_110490_() : RenderType.m_110496_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn));
        }
        return bufferIn.m_6299_(renderTypeIn);
    }

    public static VertexConsumer m_115222_(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean hasEffectIn) {
        if (Shaders.isShadowPass) {
            hasEffectIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            hasEffectIn = false;
        }
        return hasEffectIn ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(isItemIn ? RenderType.m_110493_() : RenderType.m_110499_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn)) : bufferIn.m_6299_(renderTypeIn);
    }

    private void m_115162_(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        boolean flag = !itemStackIn.m_41619_();
        PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
        boolean emissiveActive = EmissiveTextures.isActive();
        int listSize = quadsIn.size();
        int baseColorMul = listSize > 0 && Config.isCustomColors() ? CustomColors.getColorFromItemStack((ItemStack)itemStackIn, (int)-1, (int)-1) : -1;
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = quadsIn.get(ix);
            if (emissiveActive && (bakedquad = EmissiveTextures.getEmissiveQuad((BakedQuad)bakedquad)) == null) continue;
            int i2 = baseColorMul;
            if (flag && bakedquad.m_111304_()) {
                i2 = this.f_115097_.m_92676_(itemStackIn, bakedquad.m_111305_());
                if (Config.isCustomColors()) {
                    i2 = CustomColors.getColorFromItemStack((ItemStack)itemStackIn, (int)bakedquad.m_111305_(), (int)i2);
                }
            }
            float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
            float f22 = (float)(i2 & 0xFF) / 255.0f;
            if (Reflector.ForgeHooksClient.exists()) {
                bufferIn.putBulkData(posestack$pose, bakedquad, f2, f1, f22, 1.0f, combinedLightIn, combinedOverlayIn, true);
                continue;
            }
            bufferIn.m_85987_(posestack$pose, bakedquad, f2, f1, f22, combinedLightIn, combinedOverlayIn);
        }
    }

    public BakedModel m_174264_(ItemStack stack, @Nullable Level worldIn, @Nullable LivingEntity entityIn, int seedIn) {
        BakedModel bakedmodel = stack.m_150930_(Items.f_42713_) ? this.f_115095_.m_109393_().m_119422_(f_244055_) : (stack.m_150930_(Items.f_151059_) ? this.f_115095_.m_109393_().m_119422_(f_243706_) : this.f_115095_.m_109406_(stack));
        ClientLevel clientlevel = worldIn instanceof ClientLevel ? (ClientLevel)worldIn : null;
        ItemOverrides.lastModelLocation = null;
        BakedModel bakedmodel1 = bakedmodel.m_7343_().m_173464_(bakedmodel, stack, clientlevel, entityIn, seedIn);
        if (Config.isCustomItems()) {
            bakedmodel1 = CustomItems.getCustomItemModel((ItemStack)stack, (BakedModel)bakedmodel1, (ResourceLocation)ItemOverrides.lastModelLocation, (boolean)true);
        }
        return bakedmodel1 == null ? this.f_115095_.m_109393_().m_119409_() : bakedmodel1;
    }

    public void m_269128_(ItemStack itemStackIn, ItemDisplayContext contextIn, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, @Nullable Level worldIn, int seedIn) {
        this.m_269491_((LivingEntity)null, itemStackIn, contextIn, false, matrixStackIn, bufferIn, worldIn, combinedLightIn, combinedOverlayIn, seedIn);
    }

    public void m_269491_(@Nullable LivingEntity livingEntityIn, ItemStack itemStackIn, ItemDisplayContext contextIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, @Nullable Level worldIn, int combinedLightIn, int combinedOverlayIn, int seedIn) {
        if (!itemStackIn.m_41619_()) {
            BakedModel bakedmodel = this.m_174264_(itemStackIn, worldIn, livingEntityIn, seedIn);
            this.m_115143_(itemStackIn, contextIn, leftHand, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedmodel);
        }
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.f_115095_.m_109403_();
    }

    public static boolean isRenderItemGui() {
        return renderItemGui;
    }

    public static void setRenderItemGui(boolean renderItemGui) {
        ItemRenderer.renderItemGui = renderItemGui;
    }

    public BlockEntityWithoutLevelRenderer getBlockEntityRenderer() {
        return this.f_174223_;
    }
}

