/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorForge;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.util.Either;
import org.joml.Matrix4f;

public abstract class EntityRenderer<T extends Entity>
implements IEntityRenderer {
    protected static final float f_174006_ = 0.025f;
    protected final EntityRenderDispatcher f_114476_;
    private final Font f_174005_;
    public float f_114477_;
    public float f_114478_ = 1.0f;
    private EntityType entityType = null;
    private ResourceLocation locationTextureCustom = null;
    public float shadowOffsetX;
    public float shadowOffsetZ;

    protected EntityRenderer(EntityRendererProvider.Context contextIn) {
        this.f_114476_ = contextIn.m_174022_();
        this.f_174005_ = contextIn.m_174028_();
    }

    public final int m_114505_(T entityIn, float partialTicks) {
        BlockPos blockpos = BlockPos.m_274446_((Position)entityIn.m_7371_(partialTicks));
        return LightTexture.m_109885_((int)this.m_6086_(entityIn, blockpos), (int)this.m_114508_(entityIn, blockpos));
    }

    protected int m_114508_(T entityIn, BlockPos blockPosIn) {
        return entityIn.m_9236_().m_45517_(LightLayer.SKY, blockPosIn);
    }

    protected int m_6086_(T entityIn, BlockPos partialTicks) {
        return entityIn.m_6060_() ? 15 : entityIn.m_9236_().m_45517_(LightLayer.BLOCK, partialTicks);
    }

    public boolean m_5523_(T livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        if (!livingEntityIn.m_6000_(camX, camY, camZ)) {
            return false;
        }
        if (((Entity)livingEntityIn).f_19811_) {
            return true;
        }
        AABB aabb = livingEntityIn.m_6921_().m_82400_(0.5);
        if (aabb.m_82392_() || aabb.m_82309_() == 0.0) {
            aabb = new AABB(livingEntityIn.m_20185_() - 2.0, livingEntityIn.m_20186_() - 2.0, livingEntityIn.m_20189_() - 2.0, livingEntityIn.m_20185_() + 2.0, livingEntityIn.m_20186_() + 2.0, livingEntityIn.m_20189_() + 2.0);
        }
        return camera.m_113029_(aabb);
    }

    public Vec3 m_7860_(T entityIn, float partialTicks) {
        return Vec3.f_82478_;
    }

    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (Reflector.RenderNameTagEvent_Constructor.exists()) {
            Object renderNameplateEvent = Reflector.newInstance((ReflectorConstructor)Reflector.RenderNameTagEvent_Constructor, (Object[])new Object[]{entityIn, entityIn.m_5446_(), this, matrixStackIn, bufferIn, packedLightIn, Float.valueOf(partialTicks)});
            Reflector.postForgeBusEvent((Object)renderNameplateEvent);
            Object result = Reflector.call((Object)renderNameplateEvent, (ReflectorMethod)Reflector.Event_getResult, (Object[])new Object[0]);
            if (result != ReflectorForge.EVENT_RESULT_DENY && (result == ReflectorForge.EVENT_RESULT_ALLOW || this.m_6512_(entityIn))) {
                Component content = (Component)Reflector.call((Object)renderNameplateEvent, (ReflectorMethod)Reflector.RenderNameTagEvent_getContent, (Object[])new Object[0]);
                this.m_7649_(entityIn, content, matrixStackIn, bufferIn, packedLightIn);
            }
            return;
        }
        if (this.m_6512_(entityIn)) {
            this.m_7649_(entityIn, entityIn.m_5446_(), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected boolean m_6512_(T entity) {
        return entity.m_6052_() && entity.m_8077_();
    }

    public abstract ResourceLocation m_5478_(T var1);

    public Font m_114481_() {
        return this.f_174005_;
    }

    protected void m_7649_(T entityIn, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        boolean isNameplateInRenderDistance;
        double d0 = this.f_114476_.m_114471_(entityIn);
        boolean bl = isNameplateInRenderDistance = !(d0 > 4096.0);
        if (Reflector.ForgeHooksClient_isNameplateInRenderDistance.exists()) {
            isNameplateInRenderDistance = Reflector.ForgeHooksClient_isNameplateInRenderDistance.callBoolean(new Object[]{entityIn, d0});
        }
        if (isNameplateInRenderDistance) {
            boolean flag = !entityIn.m_20163_();
            float f2 = entityIn.m_278726_();
            int i2 = "deadmau5".equals(displayNameIn.getString()) ? -10 : 0;
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, f2, 0.0f);
            matrixStackIn.m_252781_(this.f_114476_.m_253208_());
            matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j2 = (int)(f1 * 255.0f) << 24;
            Font font = this.m_114481_();
            float f22 = -font.m_92852_((FormattedText)displayNameIn) / 2;
            font.m_272077_(displayNameIn, f22, (float)i2, 0x20FFFFFF, false, matrix4f, bufferIn, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j2, packedLightIn);
            if (flag) {
                font.m_272077_(displayNameIn, f22, (float)i2, -1, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, packedLightIn);
            }
            matrixStackIn.m_85849_();
        }
    }

    public Either<EntityType, BlockEntityType> getType() {
        if (this.entityType == null) {
            return null;
        }
        return Either.makeLeft((Object)this.entityType);
    }

    public void setType(Either<EntityType, BlockEntityType> type) {
        this.entityType = (EntityType)type.getLeft().get();
    }

    public ResourceLocation getLocationTextureCustom() {
        return this.locationTextureCustom;
    }

    public void setLocationTextureCustom(ResourceLocation locationTextureCustom) {
        this.locationTextureCustom = locationTextureCustom;
    }
}

