/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.model.data.ModelDataManager;

public class RenderChunkRegion
implements BlockAndTintGetter {
    private final int f_112899_;
    private final int f_112900_;
    protected final RenderChunk[][] f_112905_;
    protected final Level f_112908_;

    RenderChunkRegion(Level worldIn, int chunkStartXIn, int chunkStartYIn, RenderChunk[][] chunksIn) {
        this.f_112908_ = worldIn;
        this.f_112899_ = chunkStartXIn;
        this.f_112900_ = chunkStartYIn;
        this.f_112905_ = chunksIn;
    }

    public BlockState m_8055_(BlockPos pos) {
        int i2 = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int j2 = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        return this.f_112905_[i2][j2].m_200453_(pos);
    }

    public FluidState m_6425_(BlockPos pos) {
        int i2 = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int j2 = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        return this.f_112905_[i2][j2].m_200453_(pos).m_60819_();
    }

    public float m_7717_(Direction directionIn, boolean shadeIn) {
        return this.f_112908_.m_7717_(directionIn, shadeIn);
    }

    public LevelLightEngine m_5518_() {
        return this.f_112908_.m_5518_();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        int i2 = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int j2 = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        return this.f_112905_[i2][j2].m_200451_(pos);
    }

    public int m_6171_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        return this.f_112908_.m_6171_(blockPosIn, colorResolverIn);
    }

    public int m_141937_() {
        return this.f_112908_.m_141937_();
    }

    public int m_141928_() {
        return this.f_112908_.m_141928_();
    }

    public Biome getBiome(BlockPos pos) {
        return (Biome)this.f_112908_.m_204166_(pos).m_203334_();
    }

    public LevelChunk getChunk(int ix, int iz) {
        return this.f_112905_[ix][iz].getChunk();
    }

    public void finish() {
        for (int i2 = 0; i2 < this.f_112905_.length; ++i2) {
            RenderChunk[] rcs = this.f_112905_[i2];
            for (int j2 = 0; j2 < rcs.length; ++j2) {
                RenderChunk rc = rcs[j2];
                rc.finish();
            }
        }
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        if (this.f_112908_ instanceof ClientLevel) {
            ClientLevel clientWorld = (ClientLevel)this.f_112908_;
            return clientWorld.getShade(normalX, normalY, normalZ, shade);
        }
        return 1.0f;
    }

    public ModelDataManager getModelDataManager() {
        if (this.f_112908_ instanceof ClientLevel) {
            ClientLevel clientWorld = (ClientLevel)this.f_112908_;
            return clientWorld.getModelDataManager();
        }
        return null;
    }
}

