/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.shaders.Shaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignRenderer
implements BlockEntityRenderer<SignBlockEntity> {
    private static final String f_173629_ = "stick";
    private static final int f_173630_ = -988212;
    private static final int f_173631_ = Mth.m_144944_((int)16);
    private static final float f_278501_ = 0.6666667f;
    private static final Vec3 f_278459_ = new Vec3(0.0, 0.3333333432674408, 0.046666666865348816);
    private final Map<WoodType, SignModel> f_173632_ = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(woodTypeIn -> woodTypeIn, woodTypeIn -> new SignModel(contextIn.m_173582_(ModelLayers.m_171291_((WoodType)woodTypeIn)))));
    private final Font f_173633_;
    private static double textRenderDistanceSq = 4096.0;

    public SignRenderer(BlockEntityRendererProvider.Context contextIn) {
        this.f_173633_ = contextIn.m_173586_();
    }

    public void m_6922_(SignBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = tileEntityIn.m_58900_();
        SignBlock signblock = (SignBlock)blockstate.m_60734_();
        WoodType woodtype = SignBlock.m_247329_((Block)signblock);
        SignModel signrenderer$signmodel = (SignModel)this.f_173632_.get(woodtype);
        signrenderer$signmodel.f_112507_.f_104207_ = blockstate.m_60734_() instanceof StandingSignBlock;
        this.m_278756_(tileEntityIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, blockstate, signblock, woodtype, (Model)signrenderer$signmodel);
    }

    public float m_278770_() {
        return 0.6666667f;
    }

    public float m_278631_() {
        return 0.6666667f;
    }

    void m_278756_(SignBlockEntity tileEntityIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlockState stateIn, SignBlock blockIn, WoodType woodTypeIn, Model modelIn) {
        matrixStackIn.m_85836_();
        this.m_276777_(matrixStackIn, -blockIn.m_276903_(stateIn), stateIn);
        this.m_278784_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, woodTypeIn, modelIn);
        this.m_278841_(tileEntityIn.m_58899_(), tileEntityIn.m_277142_(), matrixStackIn, bufferIn, combinedLightIn, tileEntityIn.m_245065_(), tileEntityIn.m_245123_(), true);
        this.m_278841_(tileEntityIn.m_58899_(), tileEntityIn.m_277159_(), matrixStackIn, bufferIn, combinedLightIn, tileEntityIn.m_245065_(), tileEntityIn.m_245123_(), false);
        matrixStackIn.m_85849_();
    }

    void m_276777_(PoseStack matrixStackIn, float rotationIn, BlockState stateIn) {
        matrixStackIn.m_252880_(0.5f, 0.75f * this.m_278770_(), 0.5f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(rotationIn));
        if (!(stateIn.m_60734_() instanceof StandingSignBlock)) {
            matrixStackIn.m_252880_(0.0f, -0.3125f, -0.4375f);
        }
    }

    void m_278784_(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, WoodType woodTypeIn, Model modelIn) {
        matrixStackIn.m_85836_();
        float f2 = this.m_278770_();
        matrixStackIn.m_85841_(f2, -f2, -f2);
        Material material = this.m_245629_(woodTypeIn);
        VertexConsumer vertexconsumer = material.m_119194_(bufferIn, arg_0 -> ((Model)modelIn).m_103119_(arg_0));
        this.m_245885_(matrixStackIn, combinedLightIn, combinedOverlayIn, modelIn, vertexconsumer);
        matrixStackIn.m_85849_();
    }

    void m_245885_(PoseStack matrixStackIn, int packedLightIn, int packedOverlayIn, Model modelIn, VertexConsumer bufferIn) {
        SignModel signrenderer$signmodel = (SignModel)modelIn;
        signrenderer$signmodel.f_173655_.m_104301_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    Material m_245629_(WoodType typeIn) {
        return Sheets.m_173381_((WoodType)typeIn);
    }

    void m_278841_(BlockPos posIn, SignText textIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int lineHeight, int lineWidth, boolean frontIn) {
        int l2;
        boolean flag;
        int k2;
        if (!SignRenderer.isRenderText((BlockPos)posIn)) {
            return;
        }
        matrixStackIn.m_85836_();
        this.m_278823_(matrixStackIn, frontIn, this.m_278725_());
        int i2 = SignRenderer.m_173639_((SignText)textIn);
        int j2 = 4 * lineHeight / 2;
        FormattedCharSequence[] aformattedcharsequence = textIn.m_277130_(Minecraft.m_91087_().m_167974_(), p_276705_2_ -> {
            List list = this.f_173633_.m_92923_((FormattedText)p_276705_2_, lineWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (textIn.m_276843_()) {
            k2 = textIn.m_276773_().m_41071_();
            if (Config.isCustomColors()) {
                k2 = CustomColors.getSignTextColor((int)k2);
            }
            flag = SignRenderer.m_277119_((BlockPos)posIn, (int)k2);
            l2 = 0xF000F0;
        } else {
            k2 = i2;
            flag = false;
            l2 = combinedLightIn;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f2 = -this.f_173633_.m_92724_(formattedcharsequence) / 2;
            if (flag) {
                this.f_173633_.m_168645_(formattedcharsequence, f2, (float)(i1 * lineHeight - j2), k2, i2, matrixStackIn.m_85850_().m_252922_(), bufferIn, l2);
                continue;
            }
            this.f_173633_.m_272191_(formattedcharsequence, f2, (float)(i1 * lineHeight - j2), k2, false, matrixStackIn.m_85850_().m_252922_(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, l2);
        }
        matrixStackIn.m_85849_();
    }

    private void m_278823_(PoseStack matrixStackIn, boolean frontIn, Vec3 offsetIn) {
        if (!frontIn) {
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        float f2 = 0.015625f * this.m_278631_();
        matrixStackIn.m_85837_(offsetIn.f_82479_, offsetIn.f_82480_, offsetIn.f_82481_);
        matrixStackIn.m_85841_(f2, -f2, f2);
    }

    Vec3 m_278725_() {
        return f_278459_;
    }

    static boolean m_277119_(BlockPos posIn, int colorIn) {
        if (colorIn == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)posIn)) < (double)f_173631_;
    }

    static int m_173639_(SignText entityIn) {
        int i2 = entityIn.m_276773_().m_41071_();
        if (Config.isCustomColors()) {
            i2 = CustomColors.getSignTextColor((int)i2);
        }
        if (i2 == DyeColor.BLACK.m_41071_() && entityIn.m_276843_()) {
            return -988212;
        }
        double d0 = 0.4;
        int j2 = (int)((double)FastColor.ARGB32.m_13665_((int)i2) * 0.4);
        int k2 = (int)((double)FastColor.ARGB32.m_13667_((int)i2) * 0.4);
        int l2 = (int)((double)FastColor.ARGB32.m_13669_((int)i2) * 0.4);
        return FastColor.ARGB32.m_13660_((int)0, (int)j2, (int)k2, (int)l2);
    }

    public static SignModel m_173646_(EntityModelSet modelSetIn, WoodType woodTypeIn) {
        return new SignModel(modelSetIn.m_171103_(ModelLayers.m_171291_((WoodType)woodTypeIn)));
    }

    public static LayerDefinition m_173654_() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("sign", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f), PartPose.f_171404_);
        partdefinition.m_171599_("stick", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static boolean isRenderText(BlockPos tileEntityPos) {
        Entity viewEntity;
        double distSq;
        if (Shaders.isShadowPass) {
            return false;
        }
        return Config.zoomMode || !((distSq = (viewEntity = Minecraft.m_91087_().m_91288_()).m_20275_((double)tileEntityPos.m_123341_(), (double)tileEntityPos.m_123342_(), (double)tileEntityPos.m_123343_())) > textRenderDistanceSq);
    }

    public static void updateTextRenderDistance() {
        Minecraft mc = Minecraft.m_91087_();
        double fov = Config.limit((int)((Integer)mc.f_91066_.m_231837_().m_231551_()), (int)1, (int)120);
        double textRenderDistance = Math.max(1.5 * (double)mc.m_91268_().m_85444_() / fov, 16.0);
        textRenderDistanceSq = textRenderDistance * textRenderDistance;
    }
}

