/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShaderInstance
implements Shader,
AutoCloseable {
    public static final String f_173321_ = "shaders";
    private static final String f_244364_ = "shaders/core/";
    private static final String f_173322_ = "shaders/include/";
    static final Logger f_173323_ = LogUtils.getLogger();
    private static final AbstractUniform f_173324_ = new AbstractUniform();
    private static final boolean f_173325_ = true;
    private static ShaderInstance f_173326_;
    private static int f_173327_;
    private final Map<String, Object> f_173328_ = Maps.newHashMap();
    private final List<String> f_173329_ = Lists.newArrayList();
    private final List<Integer> f_173330_ = Lists.newArrayList();
    private final List<Uniform> f_173331_ = Lists.newArrayList();
    private final List<Integer> f_173332_ = Lists.newArrayList();
    private final Map<String, Uniform> f_173333_ = Maps.newHashMap();
    private final int f_173299_;
    private final String f_173300_;
    private boolean f_173301_;
    private final BlendMode f_173302_;
    private final List<Integer> f_173303_;
    private final List<String> f_173304_;
    private final Program f_173305_;
    private final Program f_173306_;
    private final VertexFormat f_173307_;
    @Nullable
    public final Uniform f_173308_;
    @Nullable
    public final Uniform f_173309_;
    @Nullable
    public final Uniform f_200956_;
    @Nullable
    public final Uniform f_173310_;
    @Nullable
    public final Uniform f_173311_;
    @Nullable
    public final Uniform f_173312_;
    @Nullable
    public final Uniform f_173313_;
    @Nullable
    public final Uniform f_173314_;
    @Nullable
    public final Uniform f_267422_;
    @Nullable
    public final Uniform f_173315_;
    @Nullable
    public final Uniform f_173316_;
    @Nullable
    public final Uniform f_173317_;
    @Nullable
    public final Uniform f_202432_;
    @Nullable
    public final Uniform f_173318_;
    @Nullable
    public final Uniform f_173319_;
    @Nullable
    public final Uniform f_173320_;

    public ShaderInstance(ResourceProvider providerIn, String nameIn, VertexFormat formatIn) throws IOException {
        this(providerIn, new ResourceLocation(nameIn), formatIn);
    }

    public ShaderInstance(ResourceProvider providerIn, ResourceLocation shaderLocation, VertexFormat formatIn) throws IOException {
        this.f_173300_ = shaderLocation.m_135827_().equals("minecraft") ? shaderLocation.m_135815_() : shaderLocation.toString();
        this.f_173307_ = formatIn;
        ResourceLocation resourcelocation = new ResourceLocation(shaderLocation.m_135827_(), "shaders/core/" + shaderLocation.m_135815_() + ".json");
        try (BufferedReader reader = providerIn.m_215597_(resourcelocation);){
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            JsonObject jsonobject = GsonHelper.m_13859_((Reader)reader);
            String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"vertex");
            String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"samplers", (JsonArray)null);
            if (jsonarray != null) {
                int i2 = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.m_173344_((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        ChainedJsonException chainedjsonexception1 = ChainedJsonException.m_135906_((Exception)exception2);
                        chainedjsonexception1.m_135908_("samplers[" + i2 + "]");
                        throw chainedjsonexception1;
                    }
                    ++i2;
                }
            }
            if ((jsonarray1 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"attributes", (JsonArray)null)) != null) {
                int j2 = 0;
                this.f_173303_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.f_173304_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (JsonElement jsonelement1 : jsonarray1) {
                    try {
                        this.f_173304_.add(GsonHelper.m_13805_((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.m_135906_((Exception)exception1);
                        chainedjsonexception2.m_135908_("attributes[" + j2 + "]");
                        throw chainedjsonexception2;
                    }
                    ++j2;
                }
            } else {
                this.f_173303_ = null;
                this.f_173304_ = null;
            }
            if ((jsonarray2 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
                int k2 = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.m_173354_(jsonelement2);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception3 = ChainedJsonException.m_135906_((Exception)exception);
                        chainedjsonexception3.m_135908_("uniforms[" + k2 + "]");
                        throw chainedjsonexception3;
                    }
                    ++k2;
                }
            }
            this.f_173302_ = ShaderInstance.m_173346_((JsonObject)GsonHelper.m_13841_((JsonObject)jsonobject, (String)"blend", (JsonObject)null));
            this.f_173305_ = ShaderInstance.m_173340_((ResourceProvider)providerIn, (Program.Type)Program.Type.VERTEX, (String)s1);
            this.f_173306_ = ShaderInstance.m_173340_((ResourceProvider)providerIn, (Program.Type)Program.Type.FRAGMENT, (String)s);
            this.f_173299_ = ProgramManager.m_85577_();
            if (this.f_173304_ != null) {
                int l2 = 0;
                for (String s2 : formatIn.m_166911_()) {
                    VertexFormatElement vfe = (VertexFormatElement)this.f_173307_.getElementMapping().get((Object)s2);
                    l2 = vfe.getAttributeIndex(l2);
                    if (l2 < 0) continue;
                    Uniform.m_166710_((int)this.f_173299_, (int)l2, (CharSequence)s2);
                    this.f_173303_.add(l2);
                    ++l2;
                }
            }
            ProgramManager.m_166623_((Shader)this);
            this.m_173366_();
        }
        catch (Exception exception3) {
            ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception3);
            chainedjsonexception.m_135910_(resourcelocation.m_135815_());
            throw chainedjsonexception;
        }
        this.m_108957_();
        this.f_173308_ = this.m_173348_("ModelViewMat");
        this.f_173309_ = this.m_173348_("ProjMat");
        this.f_200956_ = this.m_173348_("IViewRotMat");
        this.f_173310_ = this.m_173348_("TextureMat");
        this.f_173311_ = this.m_173348_("ScreenSize");
        this.f_173312_ = this.m_173348_("ColorModulator");
        this.f_173313_ = this.m_173348_("Light0_Direction");
        this.f_173314_ = this.m_173348_("Light1_Direction");
        this.f_267422_ = this.m_173348_("GlintAlpha");
        this.f_173315_ = this.m_173348_("FogStart");
        this.f_173316_ = this.m_173348_("FogEnd");
        this.f_173317_ = this.m_173348_("FogColor");
        this.f_202432_ = this.m_173348_("FogShape");
        this.f_173318_ = this.m_173348_("LineWidth");
        this.f_173319_ = this.m_173348_("GameTime");
        this.f_173320_ = this.m_173348_("ChunkOffset");
    }

    private static Program m_173340_(ResourceProvider providerIn, Program.Type typeIn, String nameIn) throws IOException {
        Program program;
        Program program1 = (Program)typeIn.m_85570_().get(nameIn);
        if (program1 == null) {
            ResourceLocation loc = new ResourceLocation(nameIn);
            String s = "shaders/core/" + loc.m_135815_() + typeIn.m_85569_();
            Resource resource = providerIn.m_215593_(new ResourceLocation(loc.m_135827_(), s));
            try (InputStream inputstream = resource.m_215507_();){
                String s1 = FileUtil.m_179922_((String)s);
                program = Program.m_166604_((Program.Type)typeIn, (String)nameIn, (InputStream)inputstream, (String)resource.m_215506_(), (GlslPreprocessor)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else {
            program = program1;
        }
        return program;
    }

    public static BlendMode m_173346_(JsonObject jsonIn) {
        if (jsonIn == null) {
            return new BlendMode();
        }
        int i2 = 32774;
        int j2 = 1;
        int k2 = 0;
        int l2 = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"func") && (i2 = BlendMode.m_85527_((String)jsonIn.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"srcrgb") && (j2 = BlendMode.m_85530_((String)jsonIn.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"dstrgb") && (k2 = BlendMode.m_85530_((String)jsonIn.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"srcalpha")) {
            l2 = BlendMode.m_85530_((String)jsonIn.get("srcalpha").getAsString());
            if (l2 != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"dstalpha")) {
            i1 = BlendMode.m_85530_((String)jsonIn.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new BlendMode();
        }
        return flag1 ? new BlendMode(j2, k2, l2, i1, i2) : new BlendMode(j2, k2, i2);
    }

    @Override
    public void close() {
        for (Uniform uniform : this.f_173331_) {
            uniform.close();
        }
        ProgramManager.m_166621_((Shader)this);
    }

    public void m_173362_() {
        RenderSystem.assertOnRenderThread();
        f_173327_ = -1;
        f_173326_ = null;
        int i2 = GlStateManager._getActiveTexture();
        if (Boolean.FALSE.booleanValue()) {
            for (int j2 = 0; j2 < this.f_173330_.size(); ++j2) {
                if (this.f_173328_.get(this.f_173329_.get(j2)) == null) continue;
                int textureUnit = this.getTextureUnit((String)this.f_173329_.get(j2), j2);
                GlStateManager._activeTexture((int)(33984 + textureUnit));
                GlStateManager._bindTexture((int)0);
            }
        }
        GlStateManager._activeTexture((int)i2);
    }

    public void m_173363_() {
        RenderSystem.assertOnRenderThread();
        this.f_173301_ = false;
        f_173326_ = this;
        this.f_173302_.m_85526_();
        if (this.f_173299_ != GlStateManager.getProgram()) {
            ProgramManager.m_85578_((int)this.f_173299_);
            f_173327_ = this.f_173299_;
        }
        int i2 = GlStateManager._getActiveTexture();
        for (int j2 = 0; j2 < this.f_173330_.size(); ++j2) {
            String s = (String)this.f_173329_.get(j2);
            if (this.f_173328_.get(s) == null) continue;
            int k2 = Uniform.m_85624_((int)this.f_173299_, (CharSequence)s);
            int textureUnit = this.getTextureUnit(s, j2);
            Uniform.m_85616_((int)k2, (int)textureUnit);
            RenderSystem.activeTexture((int)(33984 + textureUnit));
            Object object = this.f_173328_.get(s);
            int l2 = -1;
            if (object instanceof RenderTarget) {
                l2 = ((RenderTarget)object).m_83975_();
            } else if (object instanceof AbstractTexture) {
                l2 = ((AbstractTexture)object).m_117963_();
            } else if (object instanceof Integer) {
                l2 = (Integer)object;
            }
            if (textureUnit == 1 && Shaders.activeProgramID > 0 && Shaders.isOverlayDisabled() || l2 == -1) continue;
            if (Config.isShaders()) {
                ShadersTex.bindTexture((int)l2);
                continue;
            }
            RenderSystem.bindTexture((int)l2);
        }
        GlStateManager._activeTexture((int)i2);
        for (Uniform uniform : this.f_173331_) {
            uniform.m_85633_();
        }
        if (Config.isShaders() && Shaders.activeProgramID > 0) {
            GlStateManager._glUseProgram((int)Shaders.activeProgramID);
            boolean oldFlush = RenderUtils.setFlushRenderBuffers((boolean)false);
            Shaders.uniform_atlasSize.setValue(Shaders.atlasSizeX, Shaders.atlasSizeY);
            RenderUtils.setFlushRenderBuffers((boolean)oldFlush);
        }
    }

    public void m_108957_() {
        this.f_173301_ = true;
    }

    @Nullable
    public Uniform m_173348_(String nameIn) {
        RenderSystem.assertOnRenderThread();
        return (Uniform)this.f_173333_.get(nameIn);
    }

    public AbstractUniform m_173356_(String nameIn) {
        RenderSystem.assertOnGameThread();
        Uniform uniform = this.m_173348_(nameIn);
        return uniform == null ? f_173324_ : uniform;
    }

    private void m_173366_() {
        RenderSystem.assertOnRenderThread();
        IntArrayList intlist = new IntArrayList();
        for (int i2 = 0; i2 < this.f_173329_.size(); ++i2) {
            String s = (String)this.f_173329_.get(i2);
            int j2 = Uniform.m_85624_((int)this.f_173299_, (CharSequence)s);
            if (j2 == -1) {
                f_173323_.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.f_173300_, (Object)s);
                this.f_173328_.remove(s);
                intlist.add(i2);
                continue;
            }
            this.f_173330_.add(j2);
        }
        for (int l2 = intlist.size() - 1; l2 >= 0; --l2) {
            int i1 = intlist.getInt(l2);
            this.f_173329_.remove(i1);
        }
        for (Uniform uniform : this.f_173331_) {
            String s1 = uniform.m_85599_();
            int k2 = Uniform.m_85624_((int)this.f_173299_, (CharSequence)s1);
            if (k2 == -1) {
                f_173323_.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.f_173300_, (Object)s1);
                continue;
            }
            this.f_173332_.add(k2);
            uniform.m_85614_(k2);
            this.f_173333_.put(s1, uniform);
        }
    }

    private void m_173344_(JsonElement jsonElementIn) {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonElementIn, (String)"sampler");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        if (!GsonHelper.m_13813_((JsonObject)jsonobject, (String)"file")) {
            this.f_173328_.put(s, null);
            this.f_173329_.add(s);
        } else {
            this.f_173329_.add(s);
        }
    }

    public void m_173350_(String nameIn, Object samplerIn) {
        this.f_173328_.put(nameIn, samplerIn);
        this.m_108957_();
    }

    private void m_173354_(JsonElement jsonElementIn) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonElementIn, (String)"uniform");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        int i2 = Uniform.m_85629_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type"));
        int j2 = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j2, 16)];
        JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j2 && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j2 + ", found " + jsonarray.size() + ")");
        }
        int k2 = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k2] = GsonHelper.m_13888_((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception);
                chainedjsonexception.m_135908_("values[" + k2 + "]");
                throw chainedjsonexception;
            }
            ++k2;
        }
        if (j2 > 1 && jsonarray.size() == 1) {
            while (k2 < j2) {
                afloat[k2] = afloat[0];
                ++k2;
            }
        }
        int l2 = j2 > 1 && j2 <= 4 && i2 < 8 ? j2 - 1 : 0;
        Uniform uniform = new Uniform(s, i2 + l2, j2, (Shader)this);
        if (i2 <= 3) {
            uniform.m_7401_((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i2 <= 7) {
            uniform.m_5808_(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.m_5941_(Arrays.copyOfRange(afloat, 0, j2));
        }
        this.f_173331_.add(uniform);
    }

    public Program m_108962_() {
        return this.f_173305_;
    }

    public Program m_108964_() {
        return this.f_173306_;
    }

    public void m_142662_() {
        this.f_173306_.m_166610_((Shader)this);
        this.f_173305_.m_166610_((Shader)this);
    }

    public VertexFormat m_173364_() {
        return this.f_173307_;
    }

    public String m_173365_() {
        return this.f_173300_;
    }

    public int m_108943_() {
        return this.f_173299_;
    }

    public static void useVanillaProgram() {
        if (f_173327_ > 0) {
            GlStateManager._glUseProgram((int)f_173327_);
            return;
        }
    }

    private int getTextureUnit(String sampler, int index) {
        if (sampler.equals("Sampler0")) {
            return 0;
        }
        if (sampler.equals("Sampler1")) {
            return 1;
        }
        if (sampler.equals("Sampler2")) {
            return 2;
        }
        return index;
    }

    public void setSampler(int indexIn, Object samplerIn) {
        String samplerName = ShaderInstance.getSamplerName((int)indexIn);
        this.m_173350_(samplerName, samplerIn);
    }

    public static String getSamplerName(int indexIn) {
        switch (indexIn) {
            case 0: {
                return "Sampler0";
            }
            case 1: {
                return "Sampler1";
            }
            case 2: {
                return "Sampler2";
            }
            case 3: {
                return "Sampler3";
            }
            case 4: {
                return "Sampler4";
            }
            case 5: {
                return "Sampler5";
            }
            case 6: {
                return "Sampler6";
            }
            case 7: {
                return "Sampler7";
            }
            case 8: {
                return "Sampler8";
            }
            case 9: {
                return "Sampler9";
            }
            case 10: {
                return "Sampler10";
            }
            case 11: {
                return "Sampler11";
            }
        }
        return "Sampler" + indexIn;
    }

    static {
        f_173327_ = -1;
    }
}

