/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.Lagometer;
import net.optifine.RandomEntities;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.gui.GuiChatOF;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorField;
import net.optifine.reflect.ReflectorForge;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.reflect.ReflectorResolver;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.MemoryMonitor;
import net.optifine.util.TimedEvent;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class GameRenderer
implements AutoCloseable {
    private static final ResourceLocation f_109057_ = new ResourceLocation("textures/misc/nausea.png");
    static final Logger f_109058_ = LogUtils.getLogger();
    private static final boolean f_172636_ = false;
    public static final float f_172592_ = 0.05f;
    private static final float f_289032_ = 1000.0f;
    final Minecraft f_109059_;
    private final ResourceManager f_109060_;
    private final RandomSource f_109061_ = RandomSource.m_216327_();
    private float f_109062_;
    public final ItemInHandRenderer f_109055_;
    private final MapRenderer f_109063_;
    private final RenderBuffers f_109064_;
    private int f_109065_;
    private float f_109066_;
    private float f_109067_;
    private float f_109068_;
    private float f_109069_;
    private boolean f_109070_ = true;
    private boolean f_109071_ = true;
    private long f_109072_;
    private boolean f_182638_;
    private long f_109073_ = Util.m_137550_();
    private final LightTexture f_109074_;
    private final OverlayTexture f_109075_ = new OverlayTexture();
    private boolean f_109076_;
    private float f_109077_ = 1.0f;
    private float f_109078_;
    private float f_109079_;
    public static final int f_172634_ = 40;
    @Nullable
    private ItemStack f_109080_;
    private int f_109047_;
    private float f_109048_;
    private float f_109049_;
    @Nullable
    PostChain f_109050_;
    static final ResourceLocation[] f_109051_ = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int f_109056_ = f_109051_.length;
    int f_109052_ = f_109056_;
    private boolean f_109053_;
    private final Camera f_109054_ = new Camera();
    public ShaderInstance f_172635_;
    private final Map<String, ShaderInstance> f_172578_ = Maps.newHashMap();
    @Nullable
    private static ShaderInstance f_172579_;
    @Nullable
    private static ShaderInstance f_172580_;
    @Nullable
    private static ShaderInstance f_172581_;
    @Nullable
    private static ShaderInstance f_172582_;
    @Nullable
    private static ShaderInstance f_172583_;
    @Nullable
    private static ShaderInstance f_172586_;
    @Nullable
    private static ShaderInstance f_172587_;
    @Nullable
    private static ShaderInstance f_172588_;
    @Nullable
    private static ShaderInstance f_172589_;
    @Nullable
    private static ShaderInstance f_172590_;
    @Nullable
    private static ShaderInstance f_172591_;
    @Nullable
    private static ShaderInstance f_172608_;
    @Nullable
    private static ShaderInstance f_172609_;
    @Nullable
    private static ShaderInstance f_172610_;
    @Nullable
    private static ShaderInstance f_172611_;
    @Nullable
    private static ShaderInstance f_172612_;
    @Nullable
    private static ShaderInstance f_172613_;
    @Nullable
    private static ShaderInstance f_172614_;
    @Nullable
    private static ShaderInstance f_172615_;
    @Nullable
    private static ShaderInstance f_172616_;
    @Nullable
    private static ShaderInstance f_172617_;
    @Nullable
    private static ShaderInstance f_172618_;
    @Nullable
    private static ShaderInstance f_172619_;
    @Nullable
    private static ShaderInstance f_172620_;
    @Nullable
    private static ShaderInstance f_234217_;
    @Nullable
    private static ShaderInstance f_172621_;
    @Nullable
    private static ShaderInstance f_172622_;
    @Nullable
    private static ShaderInstance f_172623_;
    @Nullable
    private static ShaderInstance f_172624_;
    @Nullable
    private static ShaderInstance f_172625_;
    @Nullable
    private static ShaderInstance f_172626_;
    @Nullable
    private static ShaderInstance f_172627_;
    @Nullable
    private static ShaderInstance f_172628_;
    @Nullable
    private static ShaderInstance f_172629_;
    @Nullable
    private static ShaderInstance f_172630_;
    @Nullable
    private static ShaderInstance f_172631_;
    @Nullable
    private static ShaderInstance f_172632_;
    @Nullable
    private static ShaderInstance f_172633_;
    @Nullable
    private static ShaderInstance f_172593_;
    @Nullable
    private static ShaderInstance f_172594_;
    @Nullable
    private static ShaderInstance f_172595_;
    @Nullable
    private static ShaderInstance f_172596_;
    @Nullable
    private static ShaderInstance f_172597_;
    @Nullable
    private static ShaderInstance f_172598_;
    @Nullable
    private static ShaderInstance f_268423_;
    @Nullable
    private static ShaderInstance f_172599_;
    @Nullable
    private static ShaderInstance f_172600_;
    @Nullable
    private static ShaderInstance f_268525_;
    @Nullable
    private static ShaderInstance f_172601_;
    @Nullable
    private static ShaderInstance f_172602_;
    @Nullable
    private static ShaderInstance f_172603_;
    @Nullable
    private static ShaderInstance f_172604_;
    @Nullable
    private static ShaderInstance f_172605_;
    @Nullable
    private static ShaderInstance f_172606_;
    @Nullable
    private static ShaderInstance f_172607_;
    @Nullable
    private static ShaderInstance f_285653_;
    @Nullable
    private static ShaderInstance f_285598_;
    @Nullable
    private static ShaderInstance f_285623_;
    @Nullable
    private static ShaderInstance f_285569_;
    private boolean initialized = false;
    private Level updatedWorld = null;
    private float clipDistance = 128.0f;
    private long lastServerTime = 0L;
    private int lastServerTicks = 0;
    private int serverWaitTime = 0;
    private int serverWaitTimeCurrent = 0;
    private float avgServerTimeDiff = 0.0f;
    private float avgServerTickDiff = 0.0f;
    private PostChain[] fxaaShaders = new PostChain[10];
    private boolean guiLoadingVisible = false;
    private static float renderPartialTicks;

    public GameRenderer(Minecraft mcIn, ItemInHandRenderer itemRendererIn, ResourceManager resourceManagerIn, RenderBuffers renderTypeBuffersIn) {
        this.f_109059_ = mcIn;
        this.f_109060_ = resourceManagerIn;
        this.f_109055_ = itemRendererIn;
        this.f_109063_ = new MapRenderer(mcIn.m_91097_());
        this.f_109074_ = new LightTexture(this, mcIn);
        this.f_109064_ = renderTypeBuffersIn;
        this.f_109050_ = null;
    }

    @Override
    public void close() {
        this.f_109074_.close();
        this.f_109063_.close();
        this.f_109075_.close();
        this.m_109086_();
        this.m_172759_();
        if (this.f_172635_ != null) {
            this.f_172635_.close();
        }
    }

    public void m_172736_(boolean renderHandIn) {
        this.f_109070_ = renderHandIn;
    }

    public void m_172775_(boolean renderOutlineIn) {
        this.f_109071_ = renderOutlineIn;
    }

    public void m_172779_(boolean debugViewIn) {
        this.f_109076_ = debugViewIn;
    }

    public boolean m_172715_() {
        return this.f_109076_;
    }

    public void m_109086_() {
        if (this.f_109050_ != null) {
            this.f_109050_.close();
        }
        this.f_109050_ = null;
        this.f_109052_ = f_109056_;
    }

    public void m_109130_() {
        this.f_109053_ = !this.f_109053_;
    }

    public void m_109106_(@Nullable Entity entityIn) {
        if (this.f_109050_ != null) {
            this.f_109050_.close();
        }
        this.f_109050_ = null;
        if (entityIn instanceof Creeper) {
            this.m_109128_(new ResourceLocation("shaders/post/creeper.json"));
        } else if (entityIn instanceof Spider) {
            this.m_109128_(new ResourceLocation("shaders/post/spider.json"));
        } else if (entityIn instanceof EnderMan) {
            this.m_109128_(new ResourceLocation("shaders/post/invert.json"));
        } else if (Reflector.ForgeHooksClient_loadEntityShader.exists()) {
            Reflector.call((ReflectorMethod)Reflector.ForgeHooksClient_loadEntityShader, (Object[])new Object[]{entityIn, this});
        }
    }

    public void m_172783_() {
        if (this.f_109059_.m_91288_() instanceof Player) {
            if (this.f_109050_ != null) {
                this.f_109050_.close();
            }
            this.f_109052_ = (this.f_109052_ + 1) % (f_109051_.length + 1);
            if (this.f_109052_ == f_109056_) {
                this.f_109050_ = null;
            } else {
                this.m_109128_(f_109051_[this.f_109052_]);
            }
        }
    }

    void m_109128_(ResourceLocation resourceLocationIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        if (this.f_109050_ != null) {
            this.f_109050_.close();
        }
        try {
            this.f_109050_ = new PostChain(this.f_109059_.m_91097_(), this.f_109060_, this.f_109059_.m_91385_(), resourceLocationIn);
            this.f_109050_.m_110025_(this.f_109059_.m_91268_().m_85441_(), this.f_109059_.m_91268_().m_85442_());
            this.f_109053_ = true;
        }
        catch (IOException ioexception) {
            f_109058_.warn("Failed to load shader: {}", (Object)resourceLocationIn, (Object)ioexception);
            this.f_109052_ = f_109056_;
            this.f_109053_ = false;
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            f_109058_.warn("Failed to parse shader: {}", (Object)resourceLocationIn, (Object)jsonsyntaxexception);
            this.f_109052_ = f_109056_;
            this.f_109053_ = false;
        }
    }

    public PreparableReloadListener m_247116_() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void m_172722_(ResourceProvider providerIn) {
        if (this.f_172635_ != null) {
            throw new RuntimeException("Blit shader already preloaded");
        }
        try {
            this.f_172635_ = new ShaderInstance(providerIn, "blit_screen", DefaultVertexFormat.f_166850_);
        }
        catch (IOException ioexception) {
            throw new RuntimeException("could not preload blit shader", ioexception);
        }
        f_285653_ = this.m_172724_(providerIn, "rendertype_gui", DefaultVertexFormat.f_85815_);
        f_285598_ = this.m_172724_(providerIn, "rendertype_gui_overlay", DefaultVertexFormat.f_85815_);
        f_172579_ = this.m_172724_(providerIn, "position", DefaultVertexFormat.f_85814_);
        f_172580_ = this.m_172724_(providerIn, "position_color", DefaultVertexFormat.f_85815_);
        f_172581_ = this.m_172724_(providerIn, "position_color_tex", DefaultVertexFormat.f_85818_);
        f_172582_ = this.m_172724_(providerIn, "position_tex", DefaultVertexFormat.f_85817_);
        f_172583_ = this.m_172724_(providerIn, "position_tex_color", DefaultVertexFormat.f_85819_);
        f_172598_ = this.m_172724_(providerIn, "rendertype_text", DefaultVertexFormat.f_85820_);
    }

    private ShaderInstance m_172724_(ResourceProvider providerIn, String nameIn, VertexFormat formatIn) {
        try {
            ShaderInstance shaderinstance = new ShaderInstance(providerIn, nameIn, formatIn);
            this.f_172578_.put(nameIn, shaderinstance);
            return shaderinstance;
        }
        catch (Exception exception) {
            throw new IllegalStateException("could not preload shader " + nameIn, exception);
        }
    }

    void m_172767_(ResourceProvider providerIn) {
        RenderSystem.assertOnRenderThread();
        ArrayList list = Lists.newArrayList();
        list.addAll(Program.Type.FRAGMENT.m_85570_().values());
        list.addAll(Program.Type.VERTEX.m_85570_().values());
        list.forEach(Program::m_85543_);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)this.f_172578_.size());
        try {
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "particle", DefaultVertexFormat.f_85813_), p_172713_0_ -> {
                f_172586_ = p_172713_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position", DefaultVertexFormat.f_85814_), p_172710_0_ -> {
                f_172579_ = p_172710_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_color", DefaultVertexFormat.f_85815_), p_172707_0_ -> {
                f_172580_ = p_172707_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_color_lightmap", DefaultVertexFormat.f_85816_), p_172704_0_ -> {
                f_172587_ = p_172704_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_color_tex", DefaultVertexFormat.f_85818_), p_172701_0_ -> {
                f_172581_ = p_172701_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_color_tex_lightmap", DefaultVertexFormat.f_85820_), p_172698_0_ -> {
                f_172588_ = p_172698_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_tex", DefaultVertexFormat.f_85817_), p_172695_0_ -> {
                f_172582_ = p_172695_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_tex_color", DefaultVertexFormat.f_85819_), p_172692_0_ -> {
                f_172583_ = p_172692_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_tex_color_normal", DefaultVertexFormat.f_85822_), p_172689_0_ -> {
                f_172589_ = p_172689_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "position_tex_lightmap_color", DefaultVertexFormat.f_85821_), p_172686_0_ -> {
                f_172590_ = p_172686_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_solid", DefaultVertexFormat.f_85811_), p_172683_0_ -> {
                f_172591_ = p_172683_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_cutout_mipped", DefaultVertexFormat.f_85811_), p_172680_0_ -> {
                f_172608_ = p_172680_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_cutout", DefaultVertexFormat.f_85811_), p_172677_0_ -> {
                f_172609_ = p_172677_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_translucent", DefaultVertexFormat.f_85811_), p_172674_0_ -> {
                f_172610_ = p_172674_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_translucent_moving_block", DefaultVertexFormat.f_85811_), p_172671_0_ -> {
                f_172611_ = p_172671_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_translucent_no_crumbling", DefaultVertexFormat.f_85811_), p_172668_0_ -> {
                f_172612_ = p_172668_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_armor_cutout_no_cull", DefaultVertexFormat.f_85812_), p_172665_0_ -> {
                f_172613_ = p_172665_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_solid", DefaultVertexFormat.f_85812_), p_172662_0_ -> {
                f_172614_ = p_172662_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_cutout", DefaultVertexFormat.f_85812_), p_172659_0_ -> {
                f_172615_ = p_172659_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_cutout_no_cull", DefaultVertexFormat.f_85812_), p_172656_0_ -> {
                f_172616_ = p_172656_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_cutout_no_cull_z_offset", DefaultVertexFormat.f_85812_), p_172653_0_ -> {
                f_172617_ = p_172653_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_item_entity_translucent_cull", DefaultVertexFormat.f_85812_), p_172650_0_ -> {
                f_172618_ = p_172650_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_translucent_cull", DefaultVertexFormat.f_85812_), p_172647_0_ -> {
                f_172619_ = p_172647_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_translucent", DefaultVertexFormat.f_85812_), p_172644_0_ -> {
                f_172620_ = p_172644_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_translucent_emissive", DefaultVertexFormat.f_85812_), p_172641_0_ -> {
                f_234217_ = p_172641_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_smooth_cutout", DefaultVertexFormat.f_85812_), p_172638_0_ -> {
                f_172621_ = p_172638_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_beacon_beam", DefaultVertexFormat.f_85811_), p_172839_0_ -> {
                f_172622_ = p_172839_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_decal", DefaultVertexFormat.f_85812_), p_172836_0_ -> {
                f_172623_ = p_172836_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_no_outline", DefaultVertexFormat.f_85812_), p_172833_0_ -> {
                f_172624_ = p_172833_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_shadow", DefaultVertexFormat.f_85812_), p_172830_0_ -> {
                f_172625_ = p_172830_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_alpha", DefaultVertexFormat.f_85812_), p_172827_0_ -> {
                f_172626_ = p_172827_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_eyes", DefaultVertexFormat.f_85812_), p_172824_0_ -> {
                f_172627_ = p_172824_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_energy_swirl", DefaultVertexFormat.f_85812_), p_172821_0_ -> {
                f_172628_ = p_172821_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_leash", DefaultVertexFormat.f_85816_), p_172818_0_ -> {
                f_172629_ = p_172818_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_water_mask", DefaultVertexFormat.f_85814_), p_172815_0_ -> {
                f_172630_ = p_172815_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_outline", DefaultVertexFormat.f_85818_), p_172812_0_ -> {
                f_172631_ = p_172812_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_armor_glint", DefaultVertexFormat.f_85817_), p_172809_0_ -> {
                f_172632_ = p_172809_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_armor_entity_glint", DefaultVertexFormat.f_85817_), p_172806_0_ -> {
                f_172633_ = p_172806_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_glint_translucent", DefaultVertexFormat.f_85817_), p_172804_0_ -> {
                f_172593_ = p_172804_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_glint", DefaultVertexFormat.f_85817_), p_172802_0_ -> {
                f_172594_ = p_172802_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_glint_direct", DefaultVertexFormat.f_85817_), p_172800_0_ -> {
                f_172595_ = p_172800_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_glint", DefaultVertexFormat.f_85817_), p_172798_0_ -> {
                f_172596_ = p_172798_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_entity_glint_direct", DefaultVertexFormat.f_85817_), p_172795_0_ -> {
                f_172597_ = p_172795_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_text", DefaultVertexFormat.f_85820_), p_172793_0_ -> {
                f_172598_ = p_172793_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_text_background", DefaultVertexFormat.f_85816_), p_268793_0_ -> {
                f_268423_ = p_268793_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_text_intensity", DefaultVertexFormat.f_85820_), p_172791_0_ -> {
                f_172599_ = p_172791_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_text_see_through", DefaultVertexFormat.f_85820_), p_172788_0_ -> {
                f_172600_ = p_172788_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_text_background_see_through", DefaultVertexFormat.f_85816_), p_268792_0_ -> {
                f_268525_ = p_268792_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_text_intensity_see_through", DefaultVertexFormat.f_85820_), p_172786_0_ -> {
                f_172601_ = p_172786_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_lightning", DefaultVertexFormat.f_85815_), p_172784_0_ -> {
                f_172602_ = p_172784_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_tripwire", DefaultVertexFormat.f_85811_), p_172781_0_ -> {
                f_172603_ = p_172781_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_end_portal", DefaultVertexFormat.f_85814_), p_172777_0_ -> {
                f_172604_ = p_172777_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_end_gateway", DefaultVertexFormat.f_85814_), p_172773_0_ -> {
                f_172605_ = p_172773_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_lines", DefaultVertexFormat.f_166851_), p_172732_0_ -> {
                f_172606_ = p_172732_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_crumbling", DefaultVertexFormat.f_85811_), p_234229_0_ -> {
                f_172607_ = p_234229_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_gui", DefaultVertexFormat.f_85815_), p_285677_0_ -> {
                f_285653_ = p_285677_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_gui_overlay", DefaultVertexFormat.f_85815_), p_285675_0_ -> {
                f_285598_ = p_285675_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_gui_text_highlight", DefaultVertexFormat.f_85815_), p_285674_0_ -> {
                f_285623_ = p_285674_0_;
            }));
            list1.add(Pair.of((Object)new ShaderInstance(providerIn, "rendertype_gui_ghost_recipe_overlay", DefaultVertexFormat.f_85815_), p_285676_0_ -> {
                f_285569_ = p_285676_0_;
            }));
            ReflectorForge.postModLoaderEvent((ReflectorConstructor)Reflector.RegisterShadersEvent_Constructor, (Object[])new Object[]{providerIn, list1});
        }
        catch (IOException ioexception) {
            list1.forEach(p_172728_0_ -> ((ShaderInstance)p_172728_0_.getFirst()).close());
            throw new RuntimeException("could not reload shaders", ioexception);
        }
        this.m_172759_();
        list1.forEach(p_234224_1_ -> {
            ShaderInstance shaderinstance = (ShaderInstance)p_234224_1_.getFirst();
            this.f_172578_.put(shaderinstance.m_173365_(), shaderinstance);
            ((Consumer)p_234224_1_.getSecond()).accept(shaderinstance);
        });
    }

    private void m_172759_() {
        RenderSystem.assertOnRenderThread();
        this.f_172578_.values().forEach(ShaderInstance::close);
        this.f_172578_.clear();
    }

    @Nullable
    public ShaderInstance m_172734_(@Nullable String nameIn) {
        return nameIn == null ? null : (ShaderInstance)this.f_172578_.get(nameIn);
    }

    public void m_109148_() {
        this.m_109156_();
        this.f_109074_.m_109880_();
        if (this.f_109059_.m_91288_() == null) {
            this.f_109059_.m_91118_((Entity)this.f_109059_.f_91074_);
        }
        this.f_109054_.m_90565_();
        ++this.f_109065_;
        this.f_109055_.m_109311_();
        this.f_109059_.f_91060_.m_109693_(this.f_109054_);
        this.f_109069_ = this.f_109068_;
        if (this.f_109059_.f_91065_.m_93090_().m_93714_()) {
            this.f_109068_ += 0.05f;
            if (this.f_109068_ > 1.0f) {
                this.f_109068_ = 1.0f;
            }
        } else if (this.f_109068_ > 0.0f) {
            this.f_109068_ -= 0.0125f;
        }
        if (this.f_109047_ > 0) {
            --this.f_109047_;
            if (this.f_109047_ == 0) {
                this.f_109080_ = null;
            }
        }
    }

    @Nullable
    public PostChain m_109149_() {
        return this.f_109050_;
    }

    public void m_109097_(int width, int height) {
        if (this.f_109050_ != null) {
            this.f_109050_.m_110025_(width, height);
        }
        this.f_109059_.f_91060_.m_109487_(width, height);
    }

    public void m_109087_(float partialTicks) {
        Entity entity = this.f_109059_.m_91288_();
        if (entity != null && this.f_109059_.f_91073_ != null) {
            boolean forgeHitCheck;
            boolean vanillaExtendedReach;
            double forgeReach;
            this.f_109059_.m_91307_().m_6180_("pick");
            this.f_109059_.f_91076_ = null;
            double d0 = this.f_109059_.f_91072_.m_105286_();
            boolean forgeReachActive = Reflector.IForgePlayer_getEntityReach.exists();
            double forgeEntityReach = forgeReach = d0;
            if (forgeReachActive) {
                forgeEntityReach = Reflector.callDouble((Object)this.f_109059_.f_91074_, (ReflectorMethod)Reflector.IForgePlayer_getEntityReach, (Object[])new Object[0]);
                forgeReach = Math.max(d0, forgeEntityReach);
            }
            this.f_109059_.f_91077_ = entity.m_19907_(forgeReach, partialTicks, false);
            Vec3 vec3 = entity.m_20299_(partialTicks);
            boolean flag = false;
            int i2 = 3;
            double d1 = d0;
            boolean bl = vanillaExtendedReach = !Reflector.IForgePlayer_getEntityReach.exists();
            if (vanillaExtendedReach && this.f_109059_.f_91072_.m_105291_()) {
                d0 = d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            if (forgeReachActive) {
                d0 = d1 = Math.max(d0, forgeEntityReach);
            }
            d1 *= d1;
            boolean bl2 = forgeReachActive ? this.f_109059_.f_91077_.m_6662_() != HitResult.Type.MISS : (forgeHitCheck = true);
            if (this.f_109059_.f_91077_ != null && forgeHitCheck) {
                double blockReach;
                d1 = this.f_109059_.f_91077_.m_82450_().m_82557_(vec3);
                if (Reflector.IForgePlayer_getBlockReach.exists() && d1 > (blockReach = Reflector.callDouble((Object)this.f_109059_.f_91074_, (ReflectorMethod)Reflector.IForgePlayer_getBlockReach, (Object[])new Object[0])) * blockReach) {
                    Vec3 pos = this.f_109059_.f_91077_.m_82450_();
                    this.f_109059_.f_91077_ = BlockHitResult.m_82426_((Vec3)pos, (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)BlockPos.m_274446_((Position)pos));
                }
            }
            Vec3 vec31 = entity.m_20252_(1.0f);
            Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * d0, vec31.f_82480_ * d0, vec31.f_82481_ * d0);
            float f2 = 1.0f;
            AABB aabb = entity.m_20191_().m_82369_(vec31.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, entityIn -> !entityIn.m_5833_() && entityIn.m_6087_(), (double)d1);
            if (entityhitresult != null) {
                boolean forgeCheck;
                Entity entity1 = entityhitresult.m_82443_();
                Vec3 vec33 = entityhitresult.m_82450_();
                double d2 = vec3.m_82557_(vec33);
                boolean bl3 = forgeCheck = d2 > d1 || d2 > forgeEntityReach * forgeEntityReach;
                if (forgeReachActive ? forgeCheck : flag && d2 > 9.0) {
                    this.f_109059_.f_91077_ = BlockHitResult.m_82426_((Vec3)vec33, (Direction)Direction.m_122366_((double)vec31.f_82479_, (double)vec31.f_82480_, (double)vec31.f_82481_), (BlockPos)BlockPos.m_274446_((Position)vec33));
                } else if (d2 < d1 || this.f_109059_.f_91077_ == null) {
                    this.f_109059_.f_91077_ = entityhitresult;
                    if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrame) {
                        this.f_109059_.f_91076_ = entity1;
                    }
                }
            }
            this.f_109059_.m_91307_().m_7238_();
        }
    }

    private void m_109156_() {
        float f2 = 1.0f;
        if (this.f_109059_.m_91288_() instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)this.f_109059_.m_91288_();
            f2 = abstractclientplayer.m_108565_();
        }
        this.f_109067_ = this.f_109066_;
        this.f_109066_ += (f2 - this.f_109066_) * 0.5f;
        if (this.f_109066_ > 1.5f) {
            this.f_109066_ = 1.5f;
        }
        if (this.f_109066_ < 0.1f) {
            this.f_109066_ = 0.1f;
        }
    }

    public double m_109141_(Camera activeRenderInfoIn, float partialTicks, boolean useFOVSetting) {
        FogType fogtype;
        if (this.f_109076_) {
            return 90.0;
        }
        double d0 = 70.0;
        if (useFOVSetting) {
            boolean playerScoping;
            d0 = ((Integer)this.f_109059_.f_91066_.m_231837_().m_231551_()).intValue();
            boolean bl = playerScoping = this.f_109059_.m_91288_() instanceof AbstractClientPlayer && ((AbstractClientPlayer)this.f_109059_.m_91288_()).m_150108_();
            if (Config.isDynamicFov() || playerScoping) {
                d0 *= (double)Mth.m_14179_((float)partialTicks, (float)this.f_109067_, (float)this.f_109066_);
            }
        }
        boolean zoomActive = false;
        if (this.f_109059_.f_91080_ == null) {
            zoomActive = this.f_109059_.f_91066_.ofKeyBindZoom.m_90857_();
        }
        if (zoomActive) {
            if (!Config.zoomMode) {
                Config.zoomMode = true;
                Config.zoomSmoothCamera = this.f_109059_.f_91066_.f_92067_;
                this.f_109059_.f_91066_.f_92067_ = true;
                this.f_109059_.f_91060_.m_109826_();
            }
            if (Config.zoomMode) {
                d0 /= 4.0;
            }
        } else if (Config.zoomMode) {
            Config.zoomMode = false;
            this.f_109059_.f_91066_.f_92067_ = Config.zoomSmoothCamera;
            this.f_109059_.f_91060_.m_109826_();
        }
        if (activeRenderInfoIn.m_90592_() instanceof LivingEntity && ((LivingEntity)activeRenderInfoIn.m_90592_()).m_21224_()) {
            float f2 = Math.min((float)((LivingEntity)activeRenderInfoIn.m_90592_()).f_20919_ + partialTicks, 20.0f);
            d0 /= (double)((1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f);
        }
        if ((fogtype = activeRenderInfoIn.m_167685_()) == FogType.LAVA || fogtype == FogType.WATER) {
            d0 *= Mth.m_14139_((double)((Double)this.f_109059_.f_91066_.m_231925_().m_231551_()), (double)1.0, (double)0.8571428656578064);
        }
        if (Reflector.ForgeHooksClient_getFieldOfView.exists()) {
            return Reflector.callDouble((ReflectorMethod)Reflector.ForgeHooksClient_getFieldOfView, (Object[])new Object[]{this, activeRenderInfoIn, Float.valueOf(partialTicks), d0, useFOVSetting});
        }
        return d0;
    }

    private void m_109117_(PoseStack matrixStackIn, float partialTicks) {
        if (this.f_109059_.m_91288_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)this.f_109059_.m_91288_();
            float f2 = (float)livingentity.f_20916_ - partialTicks;
            if (livingentity.m_21224_()) {
                float f1 = Math.min((float)livingentity.f_20919_ + partialTicks, 20.0f);
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(40.0f - 8000.0f / (f1 + 200.0f)));
            }
            if (f2 < 0.0f) {
                return;
            }
            f2 /= (float)livingentity.f_20917_;
            f2 = Mth.m_14031_((float)(f2 * f2 * f2 * f2 * (float)Math.PI));
            float f3 = livingentity.m_264297_();
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-f3));
            float f22 = (float)((double)(-f2) * 14.0 * (Double)this.f_109059_.f_91066_.m_269326_().m_231551_());
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(f22));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f3));
        }
    }

    private void m_109138_(PoseStack matrixStackIn, float partialTicks) {
        if (this.f_109059_.m_91288_() instanceof Player) {
            Player player = (Player)this.f_109059_.m_91288_();
            float f2 = player.f_19787_ - player.f_19867_;
            float f1 = -(player.f_19787_ + f2 * partialTicks);
            float f22 = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            matrixStackIn.m_252880_(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f22 * 0.5f, -Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f22), 0.0f);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f22 * 3.0f));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f22) * 5.0f));
        }
    }

    public void m_172718_(float zoomIn, float yawIn, float pitchIn) {
        this.f_109077_ = zoomIn;
        this.f_109078_ = yawIn;
        this.f_109079_ = pitchIn;
        this.m_172775_(false);
        this.m_172736_(false);
        this.m_109089_(1.0f, 0L, new PoseStack());
        this.f_109077_ = 1.0f;
    }

    private void m_109120_(PoseStack matrixStackIn, Camera activeRenderInfoIn, float partialTicks) {
        this.renderHand(matrixStackIn, activeRenderInfoIn, partialTicks, true, true, false);
    }

    public void renderHand(PoseStack matrixStackIn, Camera activeRenderInfoIn, float partialTicks, boolean renderItem, boolean renderOverlay, boolean renderTranslucent) {
        if (!this.f_109076_) {
            Shaders.beginRenderFirstPersonHand((boolean)renderTranslucent);
            this.m_252879_(this.m_253088_(this.m_109141_(activeRenderInfoIn, partialTicks, false)));
            matrixStackIn.m_166856_();
            boolean flag = false;
            if (renderItem) {
                matrixStackIn.m_85836_();
                this.m_109117_(matrixStackIn, partialTicks);
                if (((Boolean)this.f_109059_.f_91066_.m_231830_().m_231551_()).booleanValue()) {
                    this.m_109138_(matrixStackIn, partialTicks);
                }
                boolean bl = flag = this.f_109059_.m_91288_() instanceof LivingEntity && ((LivingEntity)this.f_109059_.m_91288_()).m_5803_();
                if (this.f_109059_.f_91066_.m_92176_().m_90612_() && !flag && !this.f_109059_.f_91066_.f_92062_ && this.f_109059_.f_91072_.m_105295_() != GameType.SPECTATOR) {
                    this.f_109074_.m_109896_();
                    if (Config.isShaders()) {
                        ShadersRender.renderItemFP((ItemInHandRenderer)this.f_109055_, (float)partialTicks, (PoseStack)matrixStackIn, (MultiBufferSource.BufferSource)this.f_109064_.m_110104_(), (LocalPlayer)this.f_109059_.f_91074_, (int)this.f_109059_.m_91290_().m_114394_((Entity)this.f_109059_.f_91074_, partialTicks), (boolean)renderTranslucent);
                    } else {
                        this.f_109055_.m_109314_(partialTicks, matrixStackIn, this.f_109064_.m_110104_(), this.f_109059_.f_91074_, this.f_109059_.m_91290_().m_114394_((Entity)this.f_109059_.f_91074_, partialTicks));
                    }
                    this.f_109074_.m_109891_();
                }
                matrixStackIn.m_85849_();
            }
            Shaders.endRenderFirstPersonHand();
            if (!renderOverlay) {
                return;
            }
            this.f_109074_.m_109891_();
            if (this.f_109059_.f_91066_.m_92176_().m_90612_() && !flag) {
                ScreenEffectRenderer.m_110718_((Minecraft)this.f_109059_, (PoseStack)matrixStackIn);
                this.m_109117_(matrixStackIn, partialTicks);
            }
            if (((Boolean)this.f_109059_.f_91066_.m_231830_().m_231551_()).booleanValue()) {
                this.m_109138_(matrixStackIn, partialTicks);
            }
        }
    }

    public void m_252879_(Matrix4f matrixIn) {
        RenderSystem.setProjectionMatrix((Matrix4f)matrixIn, (VertexSorting)VertexSorting.f_276450_);
    }

    public Matrix4f m_253088_(double fovModifierIn) {
        PoseStack posestack = new PoseStack();
        posestack.m_85850_().m_252922_().identity();
        if (Config.isShaders() && Shaders.isRenderingFirstPersonHand()) {
            Shaders.applyHandDepth((PoseStack)posestack);
        }
        this.clipDistance = this.f_109062_ + 1024.0f;
        if (this.f_109077_ != 1.0f) {
            posestack.m_252880_(this.f_109078_, -this.f_109079_, 0.0f);
            posestack.m_85841_(this.f_109077_, this.f_109077_, 1.0f);
        }
        posestack.m_85850_().m_252922_().mul((Matrix4fc)new Matrix4f().setPerspective((float)(fovModifierIn * 0.01745329238474369), (float)this.f_109059_.m_91268_().m_85441_() / (float)this.f_109059_.m_91268_().m_85442_(), 0.05f, this.clipDistance));
        return posestack.m_85850_().m_252922_();
    }

    public float m_172790_() {
        return this.f_109062_ * 4.0f;
    }

    public static float m_109108_(LivingEntity livingEntityIn, float entitylivingbaseIn) {
        MobEffectInstance mobeffectinstance = livingEntityIn.m_21124_(MobEffects.f_19611_);
        return !mobeffectinstance.m_267633_(200) ? 1.0f : 0.7f + Mth.m_14031_((float)(((float)mobeffectinstance.m_19557_() - entitylivingbaseIn) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    public void m_109093_(float partialTicks, long nanoTime, boolean renderWorldIn) {
        this.frameInit();
        renderPartialTicks = partialTicks;
        if (!(this.f_109059_.m_91302_() || !this.f_109059_.f_91066_.f_92126_ || ((Boolean)this.f_109059_.f_91066_.m_231828_().m_231551_()).booleanValue() && this.f_109059_.f_91067_.m_91584_())) {
            if (Util.m_137550_() - this.f_109073_ > 500L) {
                this.f_109059_.m_91358_(false);
            }
        } else {
            this.f_109073_ = Util.m_137550_();
        }
        if (!this.f_109059_.f_91079_) {
            int i2 = (int)(this.f_109059_.f_91067_.m_91589_() * (double)this.f_109059_.m_91268_().m_85445_() / (double)this.f_109059_.m_91268_().m_85443_());
            int j2 = (int)(this.f_109059_.f_91067_.m_91594_() * (double)this.f_109059_.m_91268_().m_85446_() / (double)this.f_109059_.m_91268_().m_85444_());
            if (renderWorldIn && this.f_109059_.f_91073_ != null && !Config.isReloadingResources()) {
                this.f_109059_.m_91307_().m_6180_("level");
                this.m_109089_(partialTicks, nanoTime, new PoseStack());
                this.m_182644_();
                this.f_109059_.f_91060_.m_109769_();
                if (this.f_109050_ != null && this.f_109053_) {
                    RenderSystem.disableBlend();
                    RenderSystem.disableDepthTest();
                    RenderSystem.resetTextureMatrix();
                    this.f_109050_.m_110023_(partialTicks);
                    RenderSystem.enableTexture();
                }
                this.f_109059_.m_91385_().m_83947_(true);
            } else {
                RenderSystem.viewport((int)0, (int)0, (int)this.f_109059_.m_91268_().m_85441_(), (int)this.f_109059_.m_91268_().m_85442_());
            }
            Window window = this.f_109059_.m_91268_();
            RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
            float guiFarPlane = Reflector.ForgeHooksClient_getGuiFarPlane.exists() ? Reflector.ForgeHooksClient_getGuiFarPlane.callFloat(new Object[0]) : 21000.0f;
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.m_85441_() / window.m_85449_()), (float)((double)window.m_85442_() / window.m_85449_()), 0.0f, 1000.0f, guiFarPlane);
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
            PoseStack posestack = RenderSystem.getModelViewStack();
            posestack.m_85836_();
            posestack.m_166856_();
            float guiOffsetZ = Reflector.ForgeHooksClient_getGuiFarPlane.exists() ? 1000.0f - guiFarPlane : -11000.0f;
            posestack.m_252880_(0.0f, 0.0f, guiOffsetZ);
            RenderSystem.applyModelViewMatrix();
            Lighting.m_84931_();
            GuiGraphics guigraphics = new GuiGraphics(this.f_109059_, this.f_109064_.m_110104_());
            if (this.f_109074_.isCustom()) {
                this.f_109074_.setAllowed(false);
            }
            if (renderWorldIn && this.f_109059_.f_91073_ != null) {
                this.f_109059_.m_91307_().m_6182_("gui");
                if (this.f_109059_.f_91074_ != null) {
                    float f2 = Mth.m_14179_((float)partialTicks, (float)this.f_109059_.f_91074_.f_108590_, (float)this.f_109059_.f_91074_.f_108589_);
                    float f1 = ((Double)this.f_109059_.f_91066_.m_231924_().m_231551_()).floatValue();
                    if (f2 > 0.0f && this.f_109059_.f_91074_.m_21023_(MobEffects.f_19604_) && f1 < 1.0f) {
                        this.m_280083_(guigraphics, f2 * (1.0f - f1));
                    }
                }
                if (!this.f_109059_.f_91066_.f_92062_ || this.f_109059_.f_91080_ != null) {
                    this.m_109100_(this.f_109059_.m_91268_().m_85445_(), this.f_109059_.m_91268_().m_85446_(), partialTicks);
                    this.f_109059_.f_91065_.m_280421_(guigraphics, partialTicks);
                    if (this.f_109059_.f_91066_.ofShowFps && !this.f_109059_.f_91066_.f_92063_) {
                        Config.drawFps((GuiGraphics)guigraphics);
                    }
                    if (this.f_109059_.f_91066_.f_92063_) {
                        Lagometer.showLagometer((GuiGraphics)guigraphics, (int)((int)this.f_109059_.m_91268_().m_85449_()));
                    }
                    RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
                }
                this.f_109059_.m_91307_().m_7238_();
            }
            if (this.guiLoadingVisible != (this.f_109059_.m_91265_() != null)) {
                if (this.f_109059_.m_91265_() != null) {
                    LoadingOverlay.m_96189_((Minecraft)this.f_109059_);
                    if (this.f_109059_.m_91265_() instanceof LoadingOverlay) {
                        LoadingOverlay rlpg = (LoadingOverlay)this.f_109059_.m_91265_();
                        rlpg.update();
                    }
                }
                boolean bl = this.guiLoadingVisible = this.f_109059_.m_91265_() != null;
            }
            if (this.f_109059_.m_91265_() != null) {
                try {
                    this.f_109059_.m_91265_().m_88315_(guigraphics, i2, j2, this.f_109059_.m_91297_());
                }
                catch (Throwable throwable2) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable2, (String)"Rendering overlay");
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("Overlay render details");
                    crashreportcategory.m_128165_("Overlay name", () -> this.f_109059_.m_91265_().getClass().getCanonicalName());
                    throw new ReportedException(crashreport);
                }
            }
            if (this.f_109059_.f_91080_ != null) {
                try {
                    if (Config.isCustomEntityModels()) {
                        CustomEntityModels.onRenderScreen((Screen)this.f_109059_.f_91080_);
                    }
                    if (Reflector.ForgeHooksClient_drawScreen.exists()) {
                        Reflector.callVoid((ReflectorMethod)Reflector.ForgeHooksClient_drawScreen, (Object[])new Object[]{this.f_109059_.f_91080_, guigraphics, i2, j2, Float.valueOf(this.f_109059_.m_91297_())});
                    } else {
                        this.f_109059_.f_91080_.m_280264_(guigraphics, i2, j2, this.f_109059_.m_91297_());
                    }
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport1 = CrashReport.m_127521_((Throwable)throwable1, (String)"Rendering screen");
                    CrashReportCategory crashreportcategory1 = crashreport1.m_127514_("Screen render details");
                    crashreportcategory1.m_128165_("Screen name", () -> this.f_109059_.f_91080_.getClass().getCanonicalName());
                    crashreportcategory1.m_128165_("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", i2, j2, this.f_109059_.f_91067_.m_91589_(), this.f_109059_.f_91067_.m_91594_()));
                    crashreportcategory1.m_128165_("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.f_109059_.m_91268_().m_85445_(), this.f_109059_.m_91268_().m_85446_(), this.f_109059_.m_91268_().m_85441_(), this.f_109059_.m_91268_().m_85442_(), this.f_109059_.m_91268_().m_85449_()));
                    throw new ReportedException(crashreport1);
                }
                try {
                    if (this.f_109059_.f_91080_ != null) {
                        this.f_109059_.f_91080_.m_169417_();
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport2 = CrashReport.m_127521_((Throwable)throwable, (String)"Narrating screen");
                    CrashReportCategory crashreportcategory2 = crashreport2.m_127514_("Screen details");
                    crashreportcategory2.m_128165_("Screen name", () -> this.f_109059_.f_91080_.getClass().getCanonicalName());
                    throw new ReportedException(crashreport2);
                }
            }
            this.f_109059_.m_91307_().m_6180_("toasts");
            this.f_109059_.m_91300_().m_94920_(guigraphics);
            this.f_109059_.m_91307_().m_7238_();
            guigraphics.m_280262_();
            posestack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            this.f_109074_.setAllowed(true);
        }
        this.frameFinish();
        this.waitForServerThread();
        MemoryMonitor.update();
        Lagometer.updateLagometer();
        if (this.f_109059_.f_91066_.ofProfiler) {
            this.f_109059_.f_91066_.f_92064_ = true;
        }
    }

    private void m_182644_() {
        long i2;
        if (!this.f_182638_ && this.f_109059_.m_91090_() && (i2 = Util.m_137550_()) - this.f_109072_ >= 1000L) {
            this.f_109072_ = i2;
            IntegratedServer integratedserver = this.f_109059_.m_91092_();
            if (integratedserver != null && !integratedserver.m_129918_()) {
                integratedserver.m_182649_().ifPresent(p_234238_1_ -> {
                    if (Files.isRegularFile(p_234238_1_, new LinkOption[0])) {
                        this.f_182638_ = true;
                    } else {
                        this.m_182642_(p_234238_1_);
                    }
                });
            }
        }
    }

    private void m_182642_(Path pathIn) {
        if (this.f_109059_.f_91060_.m_109821_() > 10 && this.f_109059_.f_91060_.m_109825_()) {
            NativeImage nativeimage = Screenshot.m_92279_((RenderTarget)this.f_109059_.m_91385_());
            Util.m_183992_().execute(() -> {
                int i2 = nativeimage.m_84982_();
                int j2 = nativeimage.m_85084_();
                int k2 = 0;
                int l2 = 0;
                if (i2 > j2) {
                    k2 = (i2 - j2) / 2;
                    i2 = j2;
                } else {
                    l2 = (j2 - i2) / 2;
                    j2 = i2;
                }
                try (NativeImage nativeimage1 = new NativeImage(64, 64, false);){
                    nativeimage.m_85034_(k2, l2, i2, j2, nativeimage1);
                    nativeimage1.m_85066_(pathIn);
                }
                catch (IOException ioexception) {
                    f_109058_.warn("Couldn't save auto screenshot", (Throwable)ioexception);
                }
                finally {
                    nativeimage.close();
                }
            });
        }
    }

    private boolean m_109158_() {
        boolean flag;
        if (!this.f_109071_) {
            return false;
        }
        Entity entity = this.f_109059_.m_91288_();
        boolean bl = flag = entity instanceof Player && !this.f_109059_.f_91066_.f_92062_;
        if (flag && !((Player)entity).m_150110_().f_35938_) {
            ItemStack itemstack = ((LivingEntity)entity).m_21205_();
            HitResult hitresult = this.f_109059_.f_91077_;
            if (hitresult != null && hitresult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
                BlockState blockstate = this.f_109059_.f_91073_.m_8055_(blockpos);
                if (this.f_109059_.f_91072_.m_105295_() == GameType.SPECTATOR) {
                    flag = blockstate.m_60750_((Level)this.f_109059_.f_91073_, blockpos) != null;
                } else {
                    BlockInWorld blockinworld = new BlockInWorld((LevelReader)this.f_109059_.f_91073_, blockpos, false);
                    Registry registry = this.f_109059_.f_91073_.m_9598_().m_175515_(Registries.f_256747_);
                    flag = !itemstack.m_41619_() && (itemstack.m_204128_(registry, blockinworld) || itemstack.m_204121_(registry, blockinworld));
                }
            }
        }
        return flag;
    }

    public void m_109089_(float partialTicks, long finishTimeNano, PoseStack matrixStackIn) {
        this.f_109074_.m_109881_(partialTicks);
        if (this.f_109059_.m_91288_() == null) {
            this.f_109059_.m_91118_((Entity)this.f_109059_.f_91074_);
        }
        this.m_109087_(partialTicks);
        if (Config.isShaders()) {
            Shaders.beginRender((Minecraft)this.f_109059_, (Camera)this.f_109054_, (float)partialTicks, (long)finishTimeNano);
        }
        this.f_109059_.m_91307_().m_6180_("center");
        boolean isShaders = Config.isShaders();
        if (isShaders) {
            Shaders.beginRenderPass((float)partialTicks, (long)finishTimeNano);
        }
        boolean flag = this.m_109158_();
        this.f_109059_.m_91307_().m_6182_("camera");
        Camera camera = this.f_109054_;
        this.f_109062_ = this.f_109059_.f_91066_.m_193772_() * 16;
        PoseStack posestack = new PoseStack();
        double d0 = this.m_109141_(camera, partialTicks, true);
        posestack.m_252931_(this.m_253088_(d0));
        PoseStack matrixStackProjection = posestack;
        if (Shaders.isEffectsModelView()) {
            posestack = matrixStackIn;
        }
        this.m_109117_(posestack, partialTicks);
        if (((Boolean)this.f_109059_.f_91066_.m_231830_().m_231551_()).booleanValue()) {
            this.m_109138_(posestack, partialTicks);
        }
        float f2 = ((Double)this.f_109059_.f_91066_.m_231924_().m_231551_()).floatValue();
        float f1 = Mth.m_14179_((float)partialTicks, (float)this.f_109059_.f_91074_.f_108590_, (float)this.f_109059_.f_91074_.f_108589_) * f2 * f2;
        if (f1 > 0.0f) {
            int i2 = this.f_109059_.f_91074_.m_21023_(MobEffects.f_19604_) ? 7 : 20;
            float f22 = 5.0f / (f1 * f1 + 5.0f) - f1 * 0.04f;
            f22 *= f22;
            Axis axis = Axis.m_253057_((Vector3f)new Vector3f(0.0f, Mth.f_13994_ / 2.0f, Mth.f_13994_ / 2.0f));
            posestack.m_252781_(axis.m_252977_(((float)this.f_109065_ + partialTicks) * (float)i2));
            posestack.m_85841_(1.0f / f22, 1.0f, 1.0f);
            float f3 = -((float)this.f_109065_ + partialTicks) * (float)i2;
            posestack.m_252781_(axis.m_252977_(f3));
        }
        if (Shaders.isEffectsModelView()) {
            posestack = matrixStackProjection;
        }
        Matrix4f matrix4f = posestack.m_85850_().m_252922_();
        this.m_252879_(matrix4f);
        camera.m_90575_((BlockGetter)this.f_109059_.f_91073_, (Entity)(this.f_109059_.m_91288_() == null ? this.f_109059_.f_91074_ : this.f_109059_.m_91288_()), !this.f_109059_.f_91066_.m_92176_().m_90612_(), this.f_109059_.f_91066_.m_92176_().m_90613_(), partialTicks);
        if (Reflector.ForgeHooksClient_onCameraSetup.exists()) {
            Object cameraSetup = Reflector.ForgeHooksClient_onCameraSetup.call(new Object[]{this, camera, Float.valueOf(partialTicks)});
            float cameraSetupYaw = Reflector.callFloat((Object)cameraSetup, (ReflectorMethod)Reflector.ViewportEvent_ComputeCameraAngles_getYaw, (Object[])new Object[0]);
            float cameraSetupPitch = Reflector.callFloat((Object)cameraSetup, (ReflectorMethod)Reflector.ViewportEvent_ComputeCameraAngles_getPitch, (Object[])new Object[0]);
            float cameraSetupRoll = Reflector.callFloat((Object)cameraSetup, (ReflectorMethod)Reflector.ViewportEvent_ComputeCameraAngles_getRoll, (Object[])new Object[0]);
            camera.setAnglesInternal(cameraSetupYaw, cameraSetupPitch);
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(cameraSetupRoll));
        }
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(camera.m_90590_() + 180.0f));
        Matrix3f matrix3f = new Matrix3f((Matrix3fc)matrixStackIn.m_85850_().m_252943_()).invert();
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)matrix3f);
        this.f_109059_.f_91060_.m_253210_(matrixStackIn, camera.m_90583_(), this.m_253088_(Math.max(d0, (double)((Integer)this.f_109059_.f_91066_.m_231837_().m_231551_()).intValue())));
        this.f_109059_.f_91060_.m_109599_(matrixStackIn, partialTicks, finishTimeNano, flag, camera, this, this.f_109074_, matrix4f);
        this.f_109059_.m_91307_().m_6182_("forge_render_last");
        if (Reflector.ForgeHooksClient_dispatchRenderStageS.exists()) {
            ReflectorForge.dispatchRenderStageS((ReflectorField)Reflector.RenderLevelStageEvent_Stage_AFTER_LEVEL, (LevelRenderer)this.f_109059_.f_91060_, (PoseStack)posestack, (Matrix4f)matrix4f, (int)this.f_109059_.f_91060_.getTicks(), (Camera)camera, (Frustum)this.f_109059_.f_91060_.getFrustum());
        }
        this.f_109059_.m_91307_().m_6182_("hand");
        if (this.f_109070_ && !Shaders.isShadowPass) {
            if (isShaders) {
                ShadersRender.renderHand1((GameRenderer)this, (PoseStack)matrixStackIn, (Camera)camera, (float)partialTicks);
                Shaders.renderCompositeFinal();
            }
            RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
            if (isShaders) {
                ShadersRender.renderFPOverlay((GameRenderer)this, (PoseStack)matrixStackIn, (Camera)camera, (float)partialTicks);
            } else {
                this.m_109120_(matrixStackIn, camera, partialTicks);
            }
        }
        if (isShaders) {
            Shaders.endRender();
        }
        this.f_109059_.m_91307_().m_7238_();
    }

    public void m_109150_() {
        this.f_109080_ = null;
        this.f_109063_.m_93260_();
        this.f_109054_.m_90598_();
        this.f_182638_ = false;
    }

    public MapRenderer m_109151_() {
        return this.f_109063_;
    }

    private void waitForServerThread() {
        this.serverWaitTimeCurrent = 0;
        if (!Config.isSmoothWorld() || !Config.isSingleProcessor()) {
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (!this.f_109059_.m_91090_()) {
            return;
        }
        IntegratedServer srv = this.f_109059_.m_91092_();
        if (srv == null) {
            return;
        }
        boolean paused = this.f_109059_.m_91104_();
        if (paused || this.f_109059_.f_91080_ instanceof ReceivingLevelScreen) {
            if (this.f_109059_.f_91080_ instanceof ReceivingLevelScreen) {
                Config.sleep((long)20L);
            }
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            return;
        }
        if (this.serverWaitTime > 0) {
            Lagometer.timerServer.start();
            Config.sleep((long)this.serverWaitTime);
            Lagometer.timerServer.end();
            this.serverWaitTimeCurrent = this.serverWaitTime;
        }
        long timeNow = System.nanoTime() / 1000000L;
        if (this.lastServerTime == 0L || this.lastServerTicks == 0) {
            this.lastServerTime = timeNow;
            this.lastServerTicks = srv.m_129921_();
            this.avgServerTickDiff = 1.0f;
            this.avgServerTimeDiff = 50.0f;
            return;
        }
        long timeDiff = timeNow - this.lastServerTime;
        if (timeDiff < 0L) {
            this.lastServerTime = timeNow;
            timeDiff = 0L;
        }
        if (timeDiff < 50L) {
            return;
        }
        this.lastServerTime = timeNow;
        int ticks = srv.m_129921_();
        int tickDiff = ticks - this.lastServerTicks;
        if (tickDiff < 0) {
            this.lastServerTicks = ticks;
            tickDiff = 0;
        }
        if (tickDiff < 1 && this.serverWaitTime < 100) {
            this.serverWaitTime += 2;
        }
        if (tickDiff > 1 && this.serverWaitTime > 0) {
            --this.serverWaitTime;
        }
        this.lastServerTicks = ticks;
    }

    private void frameInit() {
        ClientLevel world;
        Config.frameStart();
        GlErrors.frameStart();
        if (!this.initialized) {
            ReflectorResolver.resolve();
            if (Config.getBitsOs() == 64 && Config.getBitsJre() == 32) {
                Config.setNotify64BitJava((boolean)true);
            }
            this.initialized = true;
        }
        if ((world = this.f_109059_.f_91073_) != null) {
            if (Config.getNewRelease() != null) {
                String userEdition = "HD_U".replace("HD_U", "HD Ultra").replace("L", "Light");
                String fullNewVer = userEdition + " " + Config.getNewRelease();
                MutableComponent msg = Component.m_237113_((String)I18n.m_118938_((String)"of.message.newVersion", (Object[])new Object[]{"\u00a7n" + fullNewVer + "\u00a7r"}));
                msg.m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://optifine.net/downloads")));
                this.f_109059_.f_91065_.m_93076_().m_93785_((Component)msg);
                Config.setNewRelease(null);
            }
            if (Config.isNotify64BitJava()) {
                Config.setNotify64BitJava((boolean)false);
                MutableComponent msg = Component.m_237113_((String)I18n.m_118938_((String)"of.message.java64Bit", (Object[])new Object[0]));
                this.f_109059_.f_91065_.m_93076_().m_93785_((Component)msg);
            }
        }
        if (this.updatedWorld != world) {
            RandomEntities.worldChanged((Level)this.updatedWorld, (Level)world);
            Config.updateThreadPriorities();
            this.lastServerTime = 0L;
            this.lastServerTicks = 0;
            this.updatedWorld = world;
        }
        if (!this.setFxaaShader(Shaders.configAntialiasingLevel)) {
            Shaders.configAntialiasingLevel = 0;
        }
        if (this.f_109059_.f_91080_ != null && this.f_109059_.f_91080_.getClass() == ChatScreen.class) {
            this.f_109059_.m_91152_((Screen)new GuiChatOF((ChatScreen)this.f_109059_.f_91080_));
        }
    }

    private void frameFinish() {
        int err2;
        if (this.f_109059_.f_91073_ != null && Config.isShowGlErrors() && TimedEvent.isActive((String)"CheckGlErrorFrameFinish", (long)10000L) && (err2 = GlStateManager._getError()) != 0 && GlErrors.isEnabled((int)err2)) {
            String text = Config.getGlErrorString((int)err2);
            MutableComponent msg = Component.m_237113_((String)I18n.m_118938_((String)"of.message.openglError", (Object[])new Object[]{err2, text}));
            this.f_109059_.f_91065_.m_93076_().m_93785_((Component)msg);
        }
    }

    public boolean setFxaaShader(int fxaaLevel) {
        if (!GLX.isUsingFBOs()) {
            return false;
        }
        if (this.f_109050_ != null && this.f_109050_ != this.fxaaShaders[2] && this.f_109050_ != this.fxaaShaders[4]) {
            return true;
        }
        if (fxaaLevel == 2 || fxaaLevel == 4) {
            if (this.f_109050_ != null && this.f_109050_ == this.fxaaShaders[fxaaLevel]) {
                return true;
            }
            if (this.f_109059_.f_91073_ == null) {
                return true;
            }
            this.m_109128_(new ResourceLocation("shaders/post/fxaa_of_" + fxaaLevel + "x.json"));
            this.fxaaShaders[fxaaLevel] = this.f_109050_;
            return this.f_109053_;
        }
        if (this.f_109050_ == null) {
            return true;
        }
        this.f_109050_.close();
        this.f_109050_ = null;
        return true;
    }

    public static float getRenderPartialTicks() {
        return renderPartialTicks;
    }

    public void m_109113_(ItemStack stack) {
        this.f_109080_ = stack;
        this.f_109047_ = 40;
        this.f_109048_ = this.f_109061_.m_188501_() * 2.0f - 1.0f;
        this.f_109049_ = this.f_109061_.m_188501_() * 2.0f - 1.0f;
    }

    private void m_109100_(int widthsp, int heightScaled, float partialTicks) {
        if (this.f_109080_ != null && this.f_109047_ > 0) {
            int i2 = 40 - this.f_109047_;
            float f2 = ((float)i2 + partialTicks) / 40.0f;
            float f1 = f2 * f2;
            float f22 = f2 * f1;
            float f3 = 10.25f * f22 * f1 - 24.95f * f1 * f1 + 25.5f * f22 - 13.8f * f1 + 4.0f * f2;
            float f4 = f3 * (float)Math.PI;
            float f5 = this.f_109048_ * (float)(widthsp / 4);
            float f6 = this.f_109049_ * (float)(heightScaled / 4);
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            PoseStack posestack = new PoseStack();
            posestack.m_85836_();
            posestack.m_252880_((float)(widthsp / 2) + f5 * Mth.m_14154_((float)Mth.m_14031_((float)(f4 * 2.0f))), (float)(heightScaled / 2) + f6 * Mth.m_14154_((float)Mth.m_14031_((float)(f4 * 2.0f))), -50.0f);
            float f7 = 50.0f + 175.0f * Mth.m_14031_((float)f4);
            posestack.m_85841_(f7, -f7, f7);
            posestack.m_252781_(Axis.f_252436_.m_252977_(900.0f * Mth.m_14154_((float)Mth.m_14031_((float)f4))));
            posestack.m_252781_(Axis.f_252529_.m_252977_(6.0f * Mth.m_14089_((float)(f2 * 8.0f))));
            posestack.m_252781_(Axis.f_252403_.m_252977_(6.0f * Mth.m_14089_((float)(f2 * 8.0f))));
            MultiBufferSource.BufferSource multibuffersource$buffersource = this.f_109064_.m_110104_();
            this.f_109059_.m_91291_().m_269128_(this.f_109080_, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, posestack, (MultiBufferSource)multibuffersource$buffersource, (Level)this.f_109059_.f_91073_, 0);
            posestack.m_85849_();
            multibuffersource$buffersource.m_109911_();
            RenderSystem.enableCull();
            RenderSystem.disableDepthTest();
        }
    }

    private void m_280083_(GuiGraphics graphicsIn, float scaleIn) {
        int i2 = graphicsIn.m_280182_();
        int j2 = graphicsIn.m_280206_();
        graphicsIn.m_280168_().m_85836_();
        float f2 = Mth.m_14179_((float)scaleIn, (float)2.0f, (float)1.0f);
        graphicsIn.m_280168_().m_252880_((float)i2 / 2.0f, (float)j2 / 2.0f, 0.0f);
        graphicsIn.m_280168_().m_85841_(f2, f2, f2);
        graphicsIn.m_280168_().m_252880_((float)(-i2) / 2.0f, (float)(-j2) / 2.0f, 0.0f);
        float f1 = 0.2f * scaleIn;
        float f22 = 0.4f * scaleIn;
        float f3 = 0.2f * scaleIn;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        graphicsIn.m_280246_(f1, f22, f3, 1.0f);
        graphicsIn.m_280398_(f_109057_, 0, 0, -90, 0.0f, 0.0f, i2, j2, i2, j2);
        graphicsIn.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphicsIn.m_280168_().m_85849_();
    }

    public Minecraft m_172797_() {
        return this.f_109059_;
    }

    public float m_109131_(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.f_109069_, (float)this.f_109068_);
    }

    public float m_109152_() {
        return this.f_109062_;
    }

    public Camera m_109153_() {
        return this.f_109054_;
    }

    public LightTexture m_109154_() {
        return this.f_109074_;
    }

    public OverlayTexture m_109155_() {
        return this.f_109075_;
    }

    @Nullable
    public static ShaderInstance m_172808_() {
        return f_172579_;
    }

    @Nullable
    public static ShaderInstance m_172811_() {
        return f_172580_;
    }

    @Nullable
    public static ShaderInstance m_172814_() {
        return f_172581_;
    }

    @Nullable
    public static ShaderInstance m_172817_() {
        return f_172582_;
    }

    @Nullable
    public static ShaderInstance m_172820_() {
        return f_172583_;
    }

    @Nullable
    public static ShaderInstance m_172829_() {
        return f_172586_;
    }

    @Nullable
    public static ShaderInstance m_172832_() {
        return f_172587_;
    }

    @Nullable
    public static ShaderInstance m_172835_() {
        return f_172588_;
    }

    @Nullable
    public static ShaderInstance m_172838_() {
        return f_172589_;
    }

    @Nullable
    public static ShaderInstance m_172637_() {
        return f_172590_;
    }

    @Nullable
    public static ShaderInstance m_172640_() {
        return f_172591_;
    }

    @Nullable
    public static ShaderInstance m_172643_() {
        return f_172608_;
    }

    @Nullable
    public static ShaderInstance m_172646_() {
        return f_172609_;
    }

    @Nullable
    public static ShaderInstance m_172649_() {
        return f_172610_;
    }

    @Nullable
    public static ShaderInstance m_172652_() {
        return f_172611_;
    }

    @Nullable
    public static ShaderInstance m_172655_() {
        return f_172612_;
    }

    @Nullable
    public static ShaderInstance m_172658_() {
        return f_172613_;
    }

    @Nullable
    public static ShaderInstance m_172661_() {
        return f_172614_;
    }

    @Nullable
    public static ShaderInstance m_172664_() {
        return f_172615_;
    }

    @Nullable
    public static ShaderInstance m_172667_() {
        return f_172616_;
    }

    @Nullable
    public static ShaderInstance m_172670_() {
        return f_172617_;
    }

    @Nullable
    public static ShaderInstance m_172673_() {
        return f_172618_;
    }

    @Nullable
    public static ShaderInstance m_172676_() {
        return f_172619_;
    }

    @Nullable
    public static ShaderInstance m_172679_() {
        return f_172620_;
    }

    @Nullable
    public static ShaderInstance m_234223_() {
        return f_234217_;
    }

    @Nullable
    public static ShaderInstance m_172682_() {
        return f_172621_;
    }

    @Nullable
    public static ShaderInstance m_172685_() {
        return f_172622_;
    }

    @Nullable
    public static ShaderInstance m_172688_() {
        return f_172623_;
    }

    @Nullable
    public static ShaderInstance m_172691_() {
        return f_172624_;
    }

    @Nullable
    public static ShaderInstance m_172694_() {
        return f_172625_;
    }

    @Nullable
    public static ShaderInstance m_172697_() {
        return f_172626_;
    }

    @Nullable
    public static ShaderInstance m_172700_() {
        return f_172627_;
    }

    @Nullable
    public static ShaderInstance m_172703_() {
        return f_172628_;
    }

    @Nullable
    public static ShaderInstance m_172706_() {
        return f_172629_;
    }

    @Nullable
    public static ShaderInstance m_172709_() {
        return f_172630_;
    }

    @Nullable
    public static ShaderInstance m_172712_() {
        return f_172631_;
    }

    @Nullable
    public static ShaderInstance m_172738_() {
        return f_172632_;
    }

    @Nullable
    public static ShaderInstance m_172741_() {
        return f_172633_;
    }

    @Nullable
    public static ShaderInstance m_172744_() {
        return f_172593_;
    }

    @Nullable
    public static ShaderInstance m_172745_() {
        return f_172594_;
    }

    @Nullable
    public static ShaderInstance m_172746_() {
        return f_172595_;
    }

    @Nullable
    public static ShaderInstance m_172747_() {
        return f_172596_;
    }

    @Nullable
    public static ShaderInstance m_172748_() {
        return f_172597_;
    }

    @Nullable
    public static ShaderInstance m_172749_() {
        return f_172598_;
    }

    @Nullable
    public static ShaderInstance m_269563_() {
        return f_268423_;
    }

    @Nullable
    public static ShaderInstance m_172750_() {
        return f_172599_;
    }

    @Nullable
    public static ShaderInstance m_172751_() {
        return f_172600_;
    }

    @Nullable
    public static ShaderInstance m_269511_() {
        return f_268525_;
    }

    @Nullable
    public static ShaderInstance m_172752_() {
        return f_172601_;
    }

    @Nullable
    public static ShaderInstance m_172753_() {
        return f_172602_;
    }

    @Nullable
    public static ShaderInstance m_172754_() {
        return f_172603_;
    }

    @Nullable
    public static ShaderInstance m_172755_() {
        return f_172604_;
    }

    @Nullable
    public static ShaderInstance m_172756_() {
        return f_172605_;
    }

    @Nullable
    public static ShaderInstance m_172757_() {
        return f_172606_;
    }

    @Nullable
    public static ShaderInstance m_172758_() {
        return f_172607_;
    }

    @Nullable
    public static ShaderInstance m_285858_() {
        return f_285653_;
    }

    @Nullable
    public static ShaderInstance m_285975_() {
        return f_285598_;
    }

    @Nullable
    public static ShaderInstance m_285738_() {
        return f_285623_;
    }

    @Nullable
    public static ShaderInstance m_285862_() {
        return f_285569_;
    }
}

