/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.AshParticle;
import net.minecraft.client.particle.AttackSweepParticle;
import net.minecraft.client.particle.BlockMarker;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.BubbleColumnUpParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.BubblePopParticle;
import net.minecraft.client.particle.CampfireSmokeParticle;
import net.minecraft.client.particle.CherryParticle;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.particle.DragonBreathParticle;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.DustColorTransitionParticle;
import net.minecraft.client.particle.DustParticle;
import net.minecraft.client.particle.EnchantmentTableParticle;
import net.minecraft.client.particle.EndRodParticle;
import net.minecraft.client.particle.ExplodeParticle;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.client.particle.HeartParticle;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.HugeExplosionSeedParticle;
import net.minecraft.client.particle.LargeSmokeParticle;
import net.minecraft.client.particle.LavaParticle;
import net.minecraft.client.particle.MobAppearanceParticle;
import net.minecraft.client.particle.NoteParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.PlayerCloudParticle;
import net.minecraft.client.particle.PortalParticle;
import net.minecraft.client.particle.ReversePortalParticle;
import net.minecraft.client.particle.SculkChargeParticle;
import net.minecraft.client.particle.SculkChargePopParticle;
import net.minecraft.client.particle.ShriekParticle;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SnowflakeParticle;
import net.minecraft.client.particle.SonicBoomParticle;
import net.minecraft.client.particle.SoulParticle;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.particle.SpitParticle;
import net.minecraft.client.particle.SplashParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.SquidInkParticle;
import net.minecraft.client.particle.SuspendedParticle;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.particle.TotemParticle;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.particle.VibrationSignalParticle;
import net.minecraft.client.particle.WakeParticle;
import net.minecraft.client.particle.WaterCurrentDownParticle;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.particle.WhiteAshParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;
import net.optifine.render.RenderEnv;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParticleEngine
implements PreparableReloadListener {
    private static final Logger f_243727_ = LogUtils.getLogger();
    private static final FileToIdConverter f_243929_ = FileToIdConverter.m_246568_((String)"particles");
    private static final ResourceLocation f_260634_ = new ResourceLocation("particles");
    private static final int f_172264_ = 16384;
    private static final List<ParticleRenderType> f_107288_ = ImmutableList.of((Object)ParticleRenderType.f_107429_, (Object)ParticleRenderType.f_107430_, (Object)ParticleRenderType.f_107432_, (Object)ParticleRenderType.f_107431_, (Object)ParticleRenderType.f_107433_);
    protected ClientLevel f_107287_;
    private Map<ParticleRenderType, Queue<Particle>> f_107289_ = Maps.newIdentityHashMap();
    private final Queue<TrackingEmitter> f_107290_ = Queues.newArrayDeque();
    private final TextureManager f_107291_;
    private final RandomSource f_107292_ = RandomSource.m_216327_();
    private final Map<ResourceLocation, ParticleProvider<?>> f_107293_ = new HashMap();
    private final Queue<Particle> f_107294_ = Queues.newArrayDeque();
    private final Map<ResourceLocation, MutableSpriteSet> f_107295_ = Maps.newHashMap();
    private final TextureAtlas f_107296_;
    private final Object2IntOpenHashMap<ParticleGroup> f_172265_ = new Object2IntOpenHashMap();
    private RenderEnv renderEnv = new RenderEnv(null, null);

    public ParticleEngine(ClientLevel worldIn, TextureManager rendererIn) {
        Comparator comp;
        if (Reflector.ForgeHooksClient_makeParticleRenderTypeComparator.exists() && (comp = (Comparator)Reflector.ForgeHooksClient_makeParticleRenderTypeComparator.call((Object)f_107288_)) != null) {
            this.f_107289_ = Maps.newTreeMap((Comparator)comp);
        }
        this.f_107296_ = new TextureAtlas(TextureAtlas.f_118260_);
        rendererIn.m_118495_(this.f_107296_.m_118330_(), (AbstractTexture)this.f_107296_);
        this.f_107287_ = worldIn;
        this.f_107291_ = rendererIn;
        this.m_107404_();
    }

    private void m_107404_() {
        this.m_107378_((ParticleType)ParticleTypes.f_123770_, SpellParticle.AmbientMobProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123792_, HeartParticle.AngryVillagerProvider::new);
        this.m_107381_(ParticleTypes.f_194652_, (ParticleProvider)new BlockMarker.Provider());
        this.m_107381_(ParticleTypes.f_123794_, (ParticleProvider)new TerrainParticle.Provider());
        this.m_107378_((ParticleType)ParticleTypes.f_123795_, BubbleParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123774_, BubbleColumnUpParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123772_, BubblePopParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123777_, CampfireSmokeParticle.CosyProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123778_, CampfireSmokeParticle.SignalProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123796_, PlayerCloudParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123749_, SuspendedTownParticle.ComposterFillProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123797_, CritParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123773_, WaterCurrentDownParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123798_, CritParticle.DamageIndicatorProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123799_, DragonBreathParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123776_, SuspendedTownParticle.DolphinSpeedProvider::new);
        this.m_272137_((ParticleType)ParticleTypes.f_123800_, DripParticle::m_272109_);
        this.m_272137_((ParticleType)ParticleTypes.f_123801_, DripParticle::m_272026_);
        this.m_272137_((ParticleType)ParticleTypes.f_123802_, DripParticle::m_271885_);
        this.m_272137_((ParticleType)ParticleTypes.f_123803_, DripParticle::m_272020_);
        this.m_272137_((ParticleType)ParticleTypes.f_123804_, DripParticle::m_271915_);
        this.m_107378_(ParticleTypes.f_123805_, DustParticle.Provider::new);
        this.m_107378_(ParticleTypes.f_175836_, DustColorTransitionParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123806_, SpellParticle.Provider::new);
        this.m_107381_((ParticleType)ParticleTypes.f_123807_, (ParticleProvider)new MobAppearanceParticle.Provider());
        this.m_107378_((ParticleType)ParticleTypes.f_123808_, CritParticle.MagicProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123809_, EnchantmentTableParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123810_, EndRodParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123811_, SpellParticle.MobProvider::new);
        this.m_107381_((ParticleType)ParticleTypes.f_123812_, (ParticleProvider)new HugeExplosionSeedParticle.Provider());
        this.m_107378_((ParticleType)ParticleTypes.f_123813_, HugeExplosionParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_235902_, SonicBoomParticle.Provider::new);
        this.m_107378_(ParticleTypes.f_123814_, FallingDustParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123815_, FireworkParticles.SparkProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123816_, WakeParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123744_, FlameParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_235898_, SoulParticle.EmissiveProvider::new);
        this.m_107378_(ParticleTypes.f_235899_, SculkChargeParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_235900_, SculkChargePopParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123746_, SoulParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123745_, FlameParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123747_, FireworkParticles.FlashProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123748_, SuspendedTownParticle.HappyVillagerProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123750_, HeartParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123751_, SpellParticle.InstantProvider::new);
        this.m_107381_(ParticleTypes.f_123752_, (ParticleProvider)new BreakingItemParticle.Provider());
        this.m_107381_((ParticleType)ParticleTypes.f_123753_, (ParticleProvider)new BreakingItemParticle.SlimeProvider());
        this.m_107381_((ParticleType)ParticleTypes.f_123754_, (ParticleProvider)new BreakingItemParticle.SnowballProvider());
        this.m_107378_((ParticleType)ParticleTypes.f_123755_, LargeSmokeParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123756_, LavaParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123757_, SuspendedTownParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123775_, EnchantmentTableParticle.NautilusProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123758_, NoteParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123759_, ExplodeParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123760_, PortalParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123761_, WaterDropParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123762_, SmokeParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123763_, PlayerCloudParticle.SneezeProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175821_, SnowflakeParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123764_, SpitParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123766_, AttackSweepParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123767_, TotemParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123765_, SquidInkParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123768_, SuspendedParticle.UnderwaterProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123769_, SplashParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123771_, SpellParticle.WitchProvider::new);
        this.m_272137_((ParticleType)ParticleTypes.f_123779_, DripParticle::m_272107_);
        this.m_272137_((ParticleType)ParticleTypes.f_123780_, DripParticle::m_272030_);
        this.m_272137_((ParticleType)ParticleTypes.f_123781_, DripParticle::m_271744_);
        this.m_272137_((ParticleType)ParticleTypes.f_123782_, DripParticle::m_272129_);
        this.m_272137_((ParticleType)ParticleTypes.f_175832_, DripParticle::m_272261_);
        this.m_107378_((ParticleType)ParticleTypes.f_175833_, SuspendedParticle.SporeBlossomAirProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123783_, AshParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123784_, SuspendedParticle.CrimsonSporeProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123785_, SuspendedParticle.WarpedSporeProvider::new);
        this.m_272137_((ParticleType)ParticleTypes.f_123786_, DripParticle::m_271935_);
        this.m_272137_((ParticleType)ParticleTypes.f_123787_, DripParticle::m_271941_);
        this.m_272137_((ParticleType)ParticleTypes.f_123788_, DripParticle::m_272251_);
        this.m_107378_((ParticleType)ParticleTypes.f_123789_, ReversePortalParticle.ReversePortalProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_123790_, WhiteAshParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175834_, FlameParticle.SmallFlameProvider::new);
        this.m_272137_((ParticleType)ParticleTypes.f_175824_, DripParticle::m_272002_);
        this.m_272137_((ParticleType)ParticleTypes.f_175825_, DripParticle::m_271993_);
        this.m_107378_((ParticleType)ParticleTypes.f_276452_, p_276702_0_ -> (p_276703_1_, p_276703_2_, p_276703_3_, p_276703_5_, p_276703_7_, p_276703_9_, p_276703_11_, p_276703_13_) -> new CherryParticle(p_276703_2_, p_276703_3_, p_276703_5_, p_276703_7_, p_276702_0_));
        this.m_272137_((ParticleType)ParticleTypes.f_175822_, DripParticle::m_271789_);
        this.m_272137_((ParticleType)ParticleTypes.f_175823_, DripParticle::m_271760_);
        this.m_107378_(ParticleTypes.f_175820_, VibrationSignalParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175826_, SquidInkParticle.GlowInkProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175827_, GlowParticle.GlowSquidProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175828_, GlowParticle.WaxOnProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175829_, GlowParticle.WaxOffProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175830_, GlowParticle.ElectricSparkProvider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_175831_, GlowParticle.ScrapeProvider::new);
        this.m_107378_(ParticleTypes.f_235901_, ShriekParticle.Provider::new);
        this.m_107378_((ParticleType)ParticleTypes.f_276512_, SuspendedTownParticle.EggCrackProvider::new);
    }

    private <T extends ParticleOptions> void m_107381_(ParticleType<T> particleTypeIn, ParticleProvider<T> particleFactoryIn) {
        this.f_107293_.put(BuiltInRegistries.f_257034_.m_7981_(particleTypeIn), particleFactoryIn);
    }

    private <T extends ParticleOptions> void m_272137_(ParticleType<T> p_272137_1_, ParticleProvider.Sprite<T> p_272137_2_) {
        this.m_107378_(p_272137_1_, p_271560_1_ -> (p_271561_2_, p_271561_3_, p_271561_4_, p_271561_6_, p_271561_8_, p_271561_10_, p_271561_12_, p_271561_14_) -> {
            TextureSheetParticle texturesheetparticle = p_272137_2_.m_272232_(p_271561_2_, p_271561_3_, p_271561_4_, p_271561_6_, p_271561_8_, p_271561_10_, p_271561_12_, p_271561_14_);
            if (texturesheetparticle != null) {
                texturesheetparticle.m_108335_(p_271560_1_);
            }
            return texturesheetparticle;
        });
    }

    private <T extends ParticleOptions> void m_107378_(ParticleType<T> particleTypeIn, SpriteParticleRegistration<T> particleMetaFactoryIn) {
        MutableSpriteSet particleengine$mutablespriteset = new MutableSpriteSet();
        this.f_107295_.put(BuiltInRegistries.f_257034_.m_7981_(particleTypeIn), particleengine$mutablespriteset);
        this.f_107293_.put(BuiltInRegistries.f_257034_.m_7981_(particleTypeIn), particleMetaFactoryIn.m_107419_((SpriteSet)particleengine$mutablespriteset));
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        CompletionStage completablefuture = CompletableFuture.supplyAsync(() -> f_243929_.m_247457_(resourceManager), backgroundExecutor).thenCompose(p_244721_2_ -> {
            ArrayList list = new ArrayList(p_244721_2_.size());
            p_244721_2_.forEach((p_244716_3_, p_244716_4_) -> {
                ResourceLocation resourcelocation = f_243929_.m_245273_(p_244716_3_);
                list.add(CompletableFuture.supplyAsync(() -> new ParticleDefinition(resourcelocation, this.m_245118_(resourcelocation, p_244716_4_)), backgroundExecutor));
            });
            return Util.m_137567_(list);
        });
        CompletionStage completablefuture1 = SpriteLoader.m_245483_((TextureAtlas)this.f_107296_).m_260881_(resourceManager, f_260634_, 0, backgroundExecutor).thenCompose(SpriteLoader.Preparations::m_246429_);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture1, completablefuture}).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$9(reloadProfiler, (CompletableFuture)completablefuture1, (CompletableFuture)completablefuture, arg_0), gameExecutor);
    }

    public void m_107301_() {
        this.f_107296_.m_118329_();
    }

    private Optional<List<ResourceLocation>> m_245118_(ResourceLocation locationIn, Resource resourceIn) {
        Optional<List<ResourceLocation>> optional;
        block9: {
            if (!this.f_107295_.containsKey(locationIn)) {
                f_243727_.debug("Redundant texture list for particle: {}", (Object)locationIn);
                return Optional.empty();
            }
            BufferedReader reader = resourceIn.m_215508_();
            try {
                ParticleDescription particledescription = ParticleDescription.m_107285_((JsonObject)GsonHelper.m_13859_((Reader)reader));
                optional = Optional.of(particledescription.m_107282_());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load description for particle " + locationIn, ioexception);
                }
            }
            ((Reader)reader).close();
        }
        return optional;
    }

    public void m_107329_(Entity entityIn, ParticleOptions particleData) {
        this.f_107290_.add(new TrackingEmitter(this.f_107287_, entityIn, particleData));
    }

    public void m_107332_(Entity entityIn, ParticleOptions dataIn, int lifetimeIn) {
        this.f_107290_.add(new TrackingEmitter(this.f_107287_, entityIn, dataIn, lifetimeIn));
    }

    @Nullable
    public Particle m_107370_(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle = this.m_107395_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.m_107344_(particle);
            return particle;
        }
        return null;
    }

    @Nullable
    private <T extends ParticleOptions> Particle m_107395_(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ParticleProvider particleprovider = (ParticleProvider)this.f_107293_.get(BuiltInRegistries.f_257034_.m_7981_((Object)particleData.m_6012_()));
        return particleprovider == null ? null : particleprovider.m_6966_(particleData, this.f_107287_, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_107344_(Particle effect) {
        if (effect == null) {
            return;
        }
        if (effect instanceof FireworkParticles.SparkParticle && !Config.isFireworkParticles()) {
            return;
        }
        Optional optional = effect.m_142654_();
        if (optional.isPresent()) {
            if (this.m_172279_((ParticleGroup)optional.get())) {
                this.f_107294_.add(effect);
                this.m_172281_((ParticleGroup)optional.get(), 1);
            }
        } else {
            this.f_107294_.add(effect);
        }
    }

    public void m_107388_() {
        this.f_107289_.forEach((p_287801_1_, p_287801_2_) -> {
            this.f_107287_.m_46473_().m_6180_(p_287801_1_.toString());
            this.m_107384_((Collection)p_287801_2_);
            this.f_107287_.m_46473_().m_7238_();
        });
        if (!this.f_107290_.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (TrackingEmitter trackingemitter : this.f_107290_) {
                trackingemitter.m_5989_();
                if (trackingemitter.m_107276_()) continue;
                list.add(trackingemitter);
            }
            this.f_107290_.removeAll(list);
        }
        if (!this.f_107294_.isEmpty()) {
            Particle particle;
            while ((particle = (Particle)this.f_107294_.poll()) != null) {
                Queue queue = this.f_107289_.computeIfAbsent(particle.m_7556_(), renderTypeIn -> EvictingQueue.create((int)16384));
                queue.add(particle);
            }
        }
    }

    private void m_107384_(Collection<Particle> particlesIn) {
        if (!particlesIn.isEmpty()) {
            long timeStartMs = System.currentTimeMillis();
            int countLeft = particlesIn.size();
            Iterator<Particle> iterator = particlesIn.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                this.m_107393_(particle);
                if (!particle.m_107276_()) {
                    particle.m_142654_().ifPresent(groupIn -> this.m_172281_(groupIn, -1));
                    iterator.remove();
                }
                --countLeft;
                if (System.currentTimeMillis() <= timeStartMs + 20L) continue;
                break;
            }
            if (countLeft > 0) {
                Iterator<Particle> it = particlesIn.iterator();
                for (int countToRemove = countLeft; it.hasNext() && countToRemove > 0; --countToRemove) {
                    Particle particle = it.next();
                    particle.m_107274_();
                    it.remove();
                }
            }
        }
    }

    private void m_172281_(ParticleGroup groupIn, int countIn) {
        this.f_172265_.addTo((Object)groupIn, countIn);
    }

    private void m_107393_(Particle particle) {
        try {
            particle.m_5989_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Particle being ticked");
            crashreportcategory.m_128165_("Particle", () -> ((Particle)particle).toString());
            crashreportcategory.m_128165_("Particle Type", particle.m_7556_()::toString);
            throw new ReportedException(crashreport);
        }
    }

    public void m_107336_(PoseStack matrixStackIn, MultiBufferSource.BufferSource bufferIn, LightTexture lightTextureIn, Camera activeRenderInfoIn, float partialTicks) {
        this.render(matrixStackIn, bufferIn, lightTextureIn, activeRenderInfoIn, partialTicks, null);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource.BufferSource bufferIn, LightTexture lightTextureIn, Camera activeRenderInfoIn, float partialTicks, Frustum clippingHelper) {
        lightTextureIn.m_109896_();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        FogType cameraFogType = activeRenderInfoIn.m_167685_();
        boolean isEyeInWater = cameraFogType == FogType.WATER;
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252931_(matrixStackIn.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        Collection<Object> renderTypes = f_107288_;
        if (Reflector.ForgeHooksClient.exists()) {
            renderTypes = this.f_107289_.keySet();
        }
        for (ParticleRenderType particlerendertype : renderTypes) {
            Iterable iterable;
            if (particlerendertype == ParticleRenderType.f_107434_ || (iterable = (Iterable)this.f_107289_.get(particlerendertype)) == null) continue;
            RenderSystem.setShader(GameRenderer::m_172829_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            particlerendertype.m_6505_(bufferbuilder, this.f_107291_);
            for (Particle particle : iterable) {
                if (clippingHelper != null && particle.shouldCull() && !clippingHelper.m_113029_(particle.m_107277_())) continue;
                try {
                    if (!isEyeInWater && particle instanceof SuspendedParticle && particle.f_107215_ == 0.0 && particle.f_107216_ == 0.0 && particle.f_107217_ == 0.0) continue;
                    particle.m_5744_((VertexConsumer)bufferbuilder, activeRenderInfoIn, partialTicks);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("Particle being rendered");
                    crashreportcategory.m_128165_("Particle", () -> ((Particle)particle).toString());
                    crashreportcategory.m_128165_("Particle Type", particlerendertype::toString);
                    throw new ReportedException(crashreport);
                }
            }
            particlerendertype.m_6294_(tesselator);
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        lightTextureIn.m_109891_();
        RenderSystem.enableDepthTest();
        GlStateManager._glUseProgram((int)0);
    }

    public void m_107342_(@Nullable ClientLevel worldIn) {
        this.f_107287_ = worldIn;
        this.m_263560_();
        this.f_107290_.clear();
    }

    public void m_107355_(BlockPos pos, BlockState state) {
        boolean forgeAddDestroyEffects = false;
        IClientBlockExtensions cbe = IClientBlockExtensions.of((BlockState)state);
        if (cbe != null) {
            forgeAddDestroyEffects = cbe.addDestroyEffects(state, (Level)this.f_107287_, pos, this);
        }
        if (!state.m_60795_() && state.m_245147_() && !forgeAddDestroyEffects) {
            VoxelShape voxelshape = state.m_60808_((BlockGetter)this.f_107287_, pos);
            double d0 = 0.25;
            voxelshape.m_83286_((p_172270_3_, p_172270_5_, p_172270_7_, p_172270_9_, p_172270_11_, p_172270_13_) -> {
                double d1 = Math.min(1.0, p_172270_9_ - p_172270_3_);
                double d2 = Math.min(1.0, p_172270_11_ - p_172270_5_);
                double d3 = Math.min(1.0, p_172270_13_ - p_172270_7_);
                int i2 = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                int j2 = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                int k2 = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                for (int l2 = 0; l2 < i2; ++l2) {
                    for (int i1 = 0; i1 < j2; ++i1) {
                        for (int j1 = 0; j1 < k2; ++j1) {
                            double d4 = ((double)l2 + 0.5) / (double)i2;
                            double d5 = ((double)i1 + 0.5) / (double)j2;
                            double d6 = ((double)j1 + 0.5) / (double)k2;
                            double d7 = d4 * d1 + p_172270_3_;
                            double d8 = d5 * d2 + p_172270_5_;
                            double d9 = d6 * d3 + p_172270_7_;
                            TerrainParticle tp = new TerrainParticle(this.f_107287_, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, pos);
                            if (Reflector.TerrainParticle_updateSprite.exists()) {
                                Reflector.call((Object)tp, (ReflectorMethod)Reflector.TerrainParticle_updateSprite, (Object[])new Object[]{state, pos});
                            }
                            if (Config.isCustomColors()) {
                                ParticleEngine.updateTerrainParticleColor((Particle)tp, (BlockState)state, (BlockAndTintGetter)this.f_107287_, (BlockPos)pos, (RenderEnv)this.renderEnv);
                            }
                            this.m_107344_((Particle)tp);
                        }
                    }
                }
            });
        }
    }

    public void m_107367_(BlockPos pos, Direction side) {
        BlockState blockstate = this.f_107287_.m_8055_(pos);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            int i2 = pos.m_123341_();
            int j2 = pos.m_123342_();
            int k2 = pos.m_123343_();
            float f2 = 0.1f;
            AABB aabb = blockstate.m_60808_((BlockGetter)this.f_107287_, pos).m_83215_();
            double d0 = (double)i2 + this.f_107292_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - (double)0.2f) + (double)0.1f + aabb.f_82288_;
            double d1 = (double)j2 + this.f_107292_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - (double)0.2f) + (double)0.1f + aabb.f_82289_;
            double d2 = (double)k2 + this.f_107292_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - (double)0.2f) + (double)0.1f + aabb.f_82290_;
            if (side == Direction.DOWN) {
                d1 = (double)j2 + aabb.f_82289_ - (double)0.1f;
            }
            if (side == Direction.UP) {
                d1 = (double)j2 + aabb.f_82292_ + (double)0.1f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k2 + aabb.f_82290_ - (double)0.1f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k2 + aabb.f_82293_ + (double)0.1f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i2 + aabb.f_82288_ - (double)0.1f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i2 + aabb.f_82291_ + (double)0.1f;
            }
            Particle tp = new TerrainParticle(this.f_107287_, d0, d1, d2, 0.0, 0.0, 0.0, blockstate, pos).m_107268_(0.2f).m_6569_(0.6f);
            if (Reflector.TerrainParticle_updateSprite.exists()) {
                Reflector.call((Object)tp, (ReflectorMethod)Reflector.TerrainParticle_updateSprite, (Object[])new Object[]{blockstate, pos});
            }
            if (Config.isCustomColors()) {
                ParticleEngine.updateTerrainParticleColor((Particle)tp, (BlockState)blockstate, (BlockAndTintGetter)this.f_107287_, (BlockPos)pos, (RenderEnv)this.renderEnv);
            }
            this.m_107344_(tp);
        }
    }

    public String m_107403_() {
        return String.valueOf(this.f_107289_.values().stream().mapToInt(Collection::size).sum());
    }

    private boolean m_172279_(ParticleGroup groupIn) {
        return this.f_172265_.getInt((Object)groupIn) < groupIn.m_175819_();
    }

    private void m_263560_() {
        this.f_107289_.clear();
        this.f_107294_.clear();
        this.f_107290_.clear();
        this.f_172265_.clear();
    }

    private boolean reuseBarrierParticle(Particle entityfx, Queue<Particle> deque) {
        for (Particle particle : deque) {
        }
        return false;
    }

    public static void updateTerrainParticleColor(Particle particle, BlockState state, BlockAndTintGetter world, BlockPos pos, RenderEnv renderEnv) {
        renderEnv.reset(state, pos);
        int col = CustomColors.getColorMultiplier((boolean)true, (BlockState)state, (BlockAndTintGetter)world, (BlockPos)pos, (RenderEnv)renderEnv);
        if (col != -1) {
            particle.f_107227_ = 0.6f * (float)(col >> 16 & 0xFF) / 255.0f;
            particle.f_107228_ = 0.6f * (float)(col >> 8 & 0xFF) / 255.0f;
            particle.f_107229_ = 0.6f * (float)(col & 0xFF) / 255.0f;
        }
    }

    public void addBlockHitEffects(BlockPos pos, BlockHitResult target) {
        BlockState state = this.f_107287_.m_8055_(pos);
        if (!IClientBlockExtensions.of((BlockState)state).addHitEffects(state, (Level)this.f_107287_, (HitResult)target, this)) {
            this.m_107367_(pos, target.m_82434_());
        }
    }

    private /* synthetic */ void lambda$reload$9(ProfilerFiller reloadProfiler, CompletableFuture completablefuture1, CompletableFuture completablefuture, Void p_244715_4_) {
        this.m_263560_();
        reloadProfiler.m_7242_();
        reloadProfiler.m_6180_("upload");
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)completablefuture1.join();
        this.f_107296_.m_247065_(spriteloader$preparations);
        reloadProfiler.m_6182_("bindSpriteSets");
        HashSet set = new HashSet();
        TextureAtlasSprite textureatlassprite = spriteloader$preparations.f_243912_();
        ((List)completablefuture.join()).forEach(p_244719_4_ -> {
            Optional optional = p_244719_4_.f_243741_();
            if (!optional.isEmpty()) {
                ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
                for (ResourceLocation resourcelocation : (List)optional.get()) {
                    TextureAtlasSprite textureatlassprite1 = (TextureAtlasSprite)spriteloader$preparations.f_243807_().get(resourcelocation);
                    if (textureatlassprite1 == null) {
                        set.add(resourcelocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(textureatlassprite1);
                }
                if (list.isEmpty()) {
                    list.add(textureatlassprite);
                }
                ((MutableSpriteSet)this.f_107295_.get(p_244719_4_.f_244103_())).m_107415_(list);
            }
        });
        if (!set.isEmpty()) {
            f_243727_.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(ResourceLocation::toString).collect(Collectors.joining(",")));
        }
        reloadProfiler.m_7238_();
        reloadProfiler.m_7241_();
    }
}

