/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.LanguageSelectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.reflect.ReflectorMethod;
import org.slf4j.Logger;

public class TitleScreen
extends Screen {
    private static final Logger f_96717_ = LogUtils.getLogger();
    private static final String f_169439_ = "Demo_World";
    public static final Component f_169438_ = Component.m_237113_((String)"Copyright Mojang AB. Do not distribute!");
    public static final CubeMap f_96716_ = new CubeMap(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation f_96718_ = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    @Nullable
    private SplashRenderer f_96721_;
    private Button f_96722_;
    @Nullable
    private RealmsNotificationsScreen f_96726_;
    private final PanoramaRenderer f_96729_ = new PanoramaRenderer(f_96716_);
    private final boolean f_96714_;
    private long f_96715_;
    @Nullable
    private WarningLabel f_232768_;
    private final LogoRenderer f_263781_;
    private Screen modUpdateNotification;

    public TitleScreen() {
        this(false);
    }

    public TitleScreen(boolean fadeIn) {
        this(fadeIn, (LogoRenderer)null);
    }

    public TitleScreen(boolean fadeIn, @Nullable LogoRenderer logoRendererIn) {
        super((Component)Component.m_237115_((String)"narrator.screen.title"));
        this.f_96714_ = fadeIn;
        this.f_263781_ = Objects.requireNonNullElseGet(logoRendererIn, () -> new LogoRenderer(false));
    }

    private boolean m_96789_() {
        return this.f_96726_ != null;
    }

    public void m_86600_() {
        if (this.m_96789_()) {
            this.f_96726_.m_86600_();
        }
        this.f_96541_.m_231416_().m_232208_((Screen)this);
    }

    public static CompletableFuture<Void> m_96754_(TextureManager texMngr, Executor backgroundExecutor) {
        return CompletableFuture.allOf(texMngr.m_118501_(LogoRenderer.f_263712_, backgroundExecutor), texMngr.m_118501_(LogoRenderer.f_263806_, backgroundExecutor), texMngr.m_118501_(f_96718_, backgroundExecutor), f_96716_.m_108854_(texMngr, backgroundExecutor));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return false;
    }

    protected void m_7856_() {
        if (this.f_96721_ == null) {
            this.f_96721_ = this.f_96541_.m_91310_().m_280369_();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int day = calendar.get(5);
            int month = calendar.get(2) + 1;
            if (day == 8 && month == 4) {
                this.f_96721_ = new SplashRenderer("Happy birthday, OptiFine!");
            }
            if (day == 14 && month == 8) {
                this.f_96721_ = new SplashRenderer("Happy birthday, sp614x!");
            }
        }
        int i2 = this.f_96547_.m_92852_((FormattedText)f_169438_);
        int j2 = this.f_96543_ - i2 - 2;
        int k2 = 24;
        int l2 = this.f_96544_ / 4 + 48;
        Button modButton = null;
        if (this.f_96541_.m_91402_()) {
            this.m_96772_(l2, 24);
        } else {
            this.m_96763_(l2, 24);
            if (Reflector.ModListScreen_Constructor.exists()) {
                modButton = ReflectorForge.makeButtonMods((TitleScreen)this, (int)l2, (int)24);
                this.m_142416_((GuiEventListener)modButton);
            }
        }
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 - 124, l2 + 72 + 12, 20, 20, 0, 106, 20, Button.f_93617_, 256, 256, p_279793_1_ -> this.f_96541_.m_91152_((Screen)new LanguageSelectScreen((Screen)this, this.f_96541_.f_91066_, this.f_96541_.m_91102_())), (Component)Component.m_237115_((String)"narrator.button.language")));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menu.options"), p_279800_1_ -> this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_))).m_252987_(this.f_96543_ / 2 - 100, l2 + 72 + 12, 98, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menu.quit"), p_279794_1_ -> this.f_96541_.m_91395_()).m_252987_(this.f_96543_ / 2 + 2, l2 + 72 + 12, 98, 20).m_253136_());
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 + 104, l2 + 72 + 12, 20, 20, 0, 0, 20, Button.f_267372_, 32, 64, p_279798_1_ -> this.f_96541_.m_91152_((Screen)new AccessibilityOptionsScreen((Screen)this, this.f_96541_.f_91066_)), (Component)Component.m_237115_((String)"narrator.button.accessibility")));
        this.m_142416_((GuiEventListener)new PlainTextButton(j2, this.f_96544_ - 10, i2, 10, f_169438_, p_279797_1_ -> this.f_96541_.m_91152_((Screen)new CreditsAndAttributionScreen((Screen)this)), this.f_96547_));
        this.f_96541_.m_91372_(false);
        if (this.f_96726_ == null) {
            this.f_96726_ = new RealmsNotificationsScreen();
        }
        if (this.m_96789_()) {
            this.f_96726_.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
        if (!this.f_96541_.m_91103_()) {
            this.f_232768_ = new WarningLabel(this.f_96547_, MultiLineLabel.m_94345_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"title.32bit.deprecation"), (int)350, (int)2), this.f_96543_ / 2, l2 - 24);
        }
        if (Reflector.TitleScreenModUpdateIndicator_init.exists()) {
            this.modUpdateNotification = (Screen)Reflector.call((ReflectorMethod)Reflector.TitleScreenModUpdateIndicator_init, (Object[])new Object[]{this, modButton});
        }
    }

    private void m_96763_(int yIn, int rowHeightIn) {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menu.singleplayer"), p_279795_1_ -> this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this))).m_252987_(this.f_96543_ / 2 - 100, yIn, 200, 20).m_253136_());
        Component component = this.m_240255_();
        boolean flag = component == null;
        Tooltip tooltip = component != null ? Tooltip.m_257550_((Component)component) : null;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menu.multiplayer"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$addSingleplayerMultiplayerButtons$7(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((TitleScreen)this)).m_252987_((int)(this.f_96543_ / 2 - 100), (int)(yIn + rowHeightIn * 1), (int)200, (int)20).m_257505_((Tooltip)tooltip).m_253136_())).f_93623_ = flag;
        boolean forge = Reflector.ModListScreen_Constructor.exists();
        int realmsX = forge ? this.f_96543_ / 2 + 2 : this.f_96543_ / 2 - 100;
        int realmsWidth = forge ? 98 : 200;
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menu.online"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$addSingleplayerMultiplayerButtons$8(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((TitleScreen)this)).m_252987_((int)realmsX, (int)(yIn + rowHeightIn * 2), (int)realmsWidth, (int)20).m_257505_((Tooltip)tooltip).m_253136_())).f_93623_ = flag;
    }

    @Nullable
    private Component m_240255_() {
        if (this.f_96541_.m_91400_()) {
            return null;
        }
        BanDetails bandetails = this.f_96541_.m_239210_();
        if (bandetails != null) {
            return bandetails.expires() != null ? Component.m_237115_((String)"title.multiplayer.disabled.banned.temporary") : Component.m_237115_((String)"title.multiplayer.disabled.banned.permanent");
        }
        return Component.m_237115_((String)"title.multiplayer.disabled");
    }

    private void m_96772_(int yIn, int rowHeightIn) {
        boolean flag = this.m_96792_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menu.playdemo"), p_279799_2_ -> {
            if (flag) {
                this.f_96541_.m_231466_().m_233133_((Screen)this, f_169439_);
            } else {
                this.f_96541_.m_231466_().m_233157_(f_169439_, MinecraftServer.f_129743_, WorldOptions.f_244225_, WorldPresets::m_246552_);
            }
        }).m_252987_(this.f_96543_ / 2 - 100, yIn, 200, 20).m_253136_());
        this.f_96722_ = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"menu.resetdemo"), p_232769_1_ -> {
            LevelStorageSource levelstoragesource = this.f_96541_.m_91392_();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.m_78260_(f_169439_);){
                LevelSummary levelsummary = levelstoragesource$levelstorageaccess.m_78308_();
                if (levelsummary != null) {
                    this.f_96541_.m_91152_((Screen)new ConfirmScreen(arg_0 -> this.m_96777_(arg_0), (Component)Component.m_237115_((String)"selectWorld.deleteQuestion"), (Component)Component.m_237110_((String)"selectWorld.deleteWarning", (Object[])new Object[]{levelsummary.m_78361_()}), (Component)Component.m_237115_((String)"selectWorld.deleteButton"), CommonComponents.f_130656_));
                }
            }
            catch (IOException ioexception) {
                SystemToast.m_94852_((Minecraft)this.f_96541_, (String)f_169439_);
                f_96717_.warn("Failed to access demo world", (Throwable)ioexception);
            }
        }).m_252987_(this.f_96543_ / 2 - 100, yIn + rowHeightIn * 1, 200, 20).m_253136_());
        this.f_96722_.f_93623_ = flag;
    }

    private boolean m_96792_() {
        try {
            boolean flag;
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(f_169439_);){
                flag = levelstoragesource$levelstorageaccess.m_78308_() != null;
            }
            return flag;
        }
        catch (IOException ioexception) {
            SystemToast.m_94852_((Minecraft)this.f_96541_, (String)f_169439_);
            f_96717_.warn("Failed to read demo world data", (Throwable)ioexception);
            return false;
        }
    }

    private void m_96793_() {
        this.f_96541_.m_91152_((Screen)new RealmsMainScreen((Screen)this));
    }

    public void m_88315_(GuiGraphics graphicsIn, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96715_ == 0L && this.f_96714_) {
            this.f_96715_ = Util.m_137550_();
        }
        float f2 = this.f_96714_ ? (float)(Util.m_137550_() - this.f_96715_) / 1000.0f : 1.0f;
        GlStateManager._disableDepthTest();
        this.f_96729_.m_110003_(partialTicks, Mth.m_14036_((float)f2, (float)0.0f, (float)1.0f));
        RenderSystem.enableBlend();
        graphicsIn.m_280246_(1.0f, 1.0f, 1.0f, this.f_96714_ ? (float)Mth.m_14167_((float)Mth.m_14036_((float)f2, (float)0.0f, (float)1.0f)) : 1.0f);
        graphicsIn.m_280411_(f_96718_, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 128, 16, 128);
        graphicsIn.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        float f1 = this.f_96714_ ? Mth.m_14036_((float)(f2 - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        this.f_263781_.m_280037_(graphicsIn, this.f_96543_, f1);
        int i2 = Mth.m_14167_((float)(f1 * 255.0f)) << 24;
        if ((i2 & 0xFC000000) != 0) {
            if (this.f_232768_ != null) {
                this.f_232768_.m_280409_(graphicsIn, i2);
            }
            if (Reflector.ForgeHooksClient_renderMainMenu.exists()) {
                Reflector.callVoid((ReflectorMethod)Reflector.ForgeHooksClient_renderMainMenu, (Object[])new Object[]{this, graphicsIn, this.f_96547_, this.f_96543_, this.f_96544_, i2});
            }
            if (this.f_96721_ != null) {
                this.f_96721_.m_280672_(graphicsIn, this.f_96543_, this.f_96547_, i2);
            }
            String s = "Minecraft " + SharedConstants.m_183709_().m_132493_();
            s = this.f_96541_.m_91402_() ? s + " Demo" : s + (String)("release".equalsIgnoreCase(this.f_96541_.m_91389_()) ? "" : "/" + this.f_96541_.m_91389_());
            if (Minecraft.m_193589_().m_184597_()) {
                s = s + I18n.m_118938_((String)"menu.modded", (Object[])new Object[0]);
            }
            if (Reflector.BrandingControl.exists()) {
                BiConsumer<Integer, String> lineConsumer;
                if (Reflector.BrandingControl_forEachLine.exists()) {
                    lineConsumer = (brdline, brd) -> {
                        int n2 = brdline;
                        Objects.requireNonNull(this.f_96547_);
                        graphicsIn.m_280488_(this.f_96547_, brd, 2, this.f_96544_ - (10 + n2 * (9 + 1)), 0xFFFFFF | i2);
                    };
                    Reflector.call((ReflectorMethod)Reflector.BrandingControl_forEachLine, (Object[])new Object[]{true, true, lineConsumer});
                }
                if (Reflector.BrandingControl_forEachAboveCopyrightLine.exists()) {
                    lineConsumer = (brdline, brd) -> {
                        int n2 = this.f_96543_ - this.f_96547_.m_92895_(brd);
                        int n3 = brdline + 1;
                        Objects.requireNonNull(this.f_96547_);
                        graphicsIn.m_280488_(this.f_96547_, brd, n2, this.f_96544_ - (10 + n3 * (9 + 1)), 0xFFFFFF | i2);
                    };
                    Reflector.call((ReflectorMethod)Reflector.BrandingControl_forEachAboveCopyrightLine, (Object[])new Object[]{lineConsumer});
                }
            } else {
                graphicsIn.m_280488_(this.f_96547_, s, 2, this.f_96544_ - 10, 0xFFFFFF | i2);
            }
            for (GuiEventListener guieventlistener : this.m_6702_()) {
                if (!(guieventlistener instanceof AbstractWidget)) continue;
                ((AbstractWidget)guieventlistener).m_93650_(f1);
            }
            super.m_88315_(graphicsIn, mouseX, mouseY, partialTicks);
            if (this.m_96789_() && f1 >= 1.0f) {
                RenderSystem.enableDepthTest();
                this.f_96726_.m_88315_(graphicsIn, mouseX, mouseY, partialTicks);
            }
        }
        if (this.modUpdateNotification != null && f1 >= 1.0f) {
            this.modUpdateNotification.m_88315_(graphicsIn, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return this.m_96789_() && this.f_96726_.m_6375_(mouseX, mouseY, button);
    }

    public void m_7861_() {
        if (this.f_96726_ != null) {
            this.f_96726_.m_7861_();
        }
    }

    public void m_274333_() {
        super.m_274333_();
        if (this.f_96726_ != null) {
            this.f_96726_.m_274333_();
        }
    }

    private void m_96777_(boolean confirmIn) {
        if (confirmIn) {
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(f_169439_);){
                levelstoragesource$levelstorageaccess.m_78311_();
            }
            catch (IOException ioexception) {
                SystemToast.m_94866_((Minecraft)this.f_96541_, (String)f_169439_);
                f_96717_.warn("Failed to delete demo world", (Throwable)ioexception);
            }
        }
        this.f_96541_.m_91152_((Screen)this);
    }

    private /* synthetic */ void lambda$addSingleplayerMultiplayerButtons$8(Button p_210871_1_) {
        this.m_96793_();
    }

    private /* synthetic */ void lambda$addSingleplayerMultiplayerButtons$7(Button p_279796_1_) {
        JoinMultiplayerScreen screen = this.f_96541_.f_91066_.f_92083_ ? new JoinMultiplayerScreen((Screen)this) : new SafetyScreen((Screen)this);
        this.f_96541_.m_91152_((Screen)screen);
    }
}

