/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.optifine.Config;
import net.optifine.render.GlBlendState;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.util.PropertiesOrdered;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoadingOverlay
extends Overlay {
    static final ResourceLocation f_96160_ = new ResourceLocation("textures/gui/title/mojangstudios.png");
    private static final int f_169316_ = FastColor.ARGB32.m_13660_((int)255, (int)239, (int)50, (int)61);
    private static final int f_169317_ = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0);
    private static final IntSupplier f_96161_ = () -> (Boolean)Minecraft.m_91087_().f_91066_.m_231838_().m_231551_() != false ? f_169317_ : f_169316_;
    private static final int f_169318_ = 240;
    private static final float f_169319_ = 60.0f;
    private static final int f_169320_ = 60;
    private static final int f_169321_ = 120;
    private static final float f_169322_ = 0.0625f;
    private static final float f_169323_ = 0.95f;
    public static final long f_169314_ = 1000L;
    public static final long f_169315_ = 500L;
    private final Minecraft f_96163_;
    private final ReloadInstance f_96164_;
    private final Consumer<Optional<Throwable>> f_96165_;
    private final boolean f_96166_;
    private float f_96167_;
    private long f_96168_ = -1L;
    private long f_96169_ = -1L;
    private int colorBackground = f_96161_.getAsInt();
    private int colorBar = f_96161_.getAsInt();
    private int colorOutline = 0xFFFFFF;
    private int colorProgress = 0xFFFFFF;
    private GlBlendState blendState = null;
    private boolean fadeOut = false;

    public LoadingOverlay(Minecraft mcIn, ReloadInstance reloaderIn, Consumer<Optional<Throwable>> completedIn, boolean reloadingIn) {
        this.f_96163_ = mcIn;
        this.f_96164_ = reloaderIn;
        this.f_96165_ = completedIn;
        this.f_96166_ = false;
    }

    public static void m_96189_(Minecraft mc) {
        mc.m_91097_().m_118495_(f_96160_, (AbstractTexture)new LogoTexture());
    }

    private static int m_169324_(int colorIn, int alphaIn) {
        return colorIn & 0xFFFFFF | alphaIn << 24;
    }

    public void m_88315_(GuiGraphics graphicsIn, int mouseX, int mouseY, float partialTicks) {
        float f2;
        float f1;
        int i2 = graphicsIn.m_280182_();
        int j2 = graphicsIn.m_280206_();
        long k2 = Util.m_137550_();
        if (this.f_96166_ && this.f_96169_ == -1L) {
            this.f_96169_ = k2;
        }
        float f3 = this.f_96168_ > -1L ? (float)(k2 - this.f_96168_) / 1000.0f : -1.0f;
        float f4 = f1 = this.f_96169_ > -1L ? (float)(k2 - this.f_96169_) / 500.0f : -1.0f;
        if (f3 >= 1.0f) {
            this.fadeOut = true;
            if (this.f_96163_.f_91080_ != null) {
                this.f_96163_.f_91080_.m_88315_(graphicsIn, 0, 0, partialTicks);
            }
            int l2 = Mth.m_14167_((float)((1.0f - Mth.m_14036_((float)(f3 - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
            graphicsIn.m_285944_(RenderType.m_286086_(), 0, 0, i2, j2, LoadingOverlay.m_169324_((int)this.colorBackground, (int)l2));
            f2 = 1.0f - Mth.m_14036_((float)(f3 - 1.0f), (float)0.0f, (float)1.0f);
        } else if (this.f_96166_) {
            if (this.f_96163_.f_91080_ != null && f1 < 1.0f) {
                this.f_96163_.f_91080_.m_88315_(graphicsIn, mouseX, mouseY, partialTicks);
            }
            int l1 = Mth.m_14165_((double)(Mth.m_14008_((double)f1, (double)0.15, (double)1.0) * 255.0));
            graphicsIn.m_285944_(RenderType.m_286086_(), 0, 0, i2, j2, LoadingOverlay.m_169324_((int)this.colorBackground, (int)l1));
            f2 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        } else {
            int i22 = this.colorBackground;
            float f32 = (float)(i22 >> 16 & 0xFF) / 255.0f;
            float f42 = (float)(i22 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(i22 & 0xFF) / 255.0f;
            GlStateManager._clearColor((float)f32, (float)f42, (float)f5, (float)1.0f);
            GlStateManager._clear((int)16384, (boolean)Minecraft.f_91002_);
            f2 = 1.0f;
        }
        int j22 = (int)((double)graphicsIn.m_280182_() * 0.5);
        int k22 = (int)((double)graphicsIn.m_280206_() * 0.5);
        double d1 = Math.min((double)graphicsIn.m_280182_() * 0.75, (double)graphicsIn.m_280206_()) * 0.25;
        int i1 = (int)(d1 * 0.5);
        double d0 = d1 * 4.0;
        int j1 = (int)(d0 * 0.5);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        graphicsIn.m_280246_(1.0f, 1.0f, 1.0f, f2);
        boolean renderLogo = true;
        if (this.blendState != null) {
            this.blendState.apply();
            if (!this.blendState.isEnabled() && this.fadeOut) {
                renderLogo = false;
            }
        }
        if (renderLogo) {
            graphicsIn.m_280411_(f_96160_, j22 - j1, k22 - i1, j1, (int)d1, -0.0625f, 0.0f, 120, 60, 120, 120);
            graphicsIn.m_280411_(f_96160_, j22, k22 - i1, j1, (int)d1, 0.0625f, 60.0f, 120, 60, 120, 120);
        }
        graphicsIn.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        int k1 = (int)((double)graphicsIn.m_280206_() * 0.8325);
        float f6 = this.f_96164_.m_7750_();
        this.f_96167_ = Mth.m_14036_((float)(this.f_96167_ * 0.95f + f6 * 0.050000012f), (float)0.0f, (float)1.0f);
        if (f3 < 1.0f) {
            this.m_96182_(graphicsIn, i2 / 2 - j1, k1 - 5, i2 / 2 + j1, k1 + 5, 1.0f - Mth.m_14036_((float)f3, (float)0.0f, (float)1.0f));
        }
        if (f3 >= 2.0f) {
            this.f_96163_.m_91150_((Overlay)null);
        }
        if (this.f_96168_ == -1L && this.f_96164_.m_7746_() && (!this.f_96166_ || f1 >= 2.0f)) {
            this.f_96168_ = Util.m_137550_();
            try {
                this.f_96164_.m_7748_();
                this.f_96165_.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.f_96165_.accept(Optional.of(throwable));
            }
            if (this.f_96163_.f_91080_ != null) {
                this.f_96163_.f_91080_.m_6575_(this.f_96163_, graphicsIn.m_280182_(), graphicsIn.m_280206_());
            }
        }
    }

    private void m_96182_(GuiGraphics graphicsIn, int left, int top, int right, int bottom, float alpha) {
        int i2 = Mth.m_14167_((float)((float)(right - left - 2) * this.f_96167_));
        int j2 = Math.round(alpha * 255.0f);
        if (this.colorBar != this.colorBackground) {
            int colBgR = this.colorBar >> 16 & 0xFF;
            int colBgG = this.colorBar >> 8 & 0xFF;
            int colBgB = this.colorBar & 0xFF;
            int colBg = FastColor.ARGB32.m_13660_((int)j2, (int)colBgR, (int)colBgG, (int)colBgB);
            graphicsIn.m_280509_(left, top, right, bottom, colBg);
        }
        int colProgR = this.colorProgress >> 16 & 0xFF;
        int colProgG = this.colorProgress >> 8 & 0xFF;
        int colProgB = this.colorProgress & 0xFF;
        int k2 = FastColor.ARGB32.m_13660_((int)j2, (int)colProgR, (int)colProgG, (int)colProgB);
        graphicsIn.m_280509_(left + 2, top + 2, left + i2, bottom - 2, k2);
        int colOutR = this.colorOutline >> 16 & 0xFF;
        int colOutG = this.colorOutline >> 8 & 0xFF;
        int colOutB = this.colorOutline & 0xFF;
        k2 = FastColor.ARGB32.m_13660_((int)j2, (int)colOutR, (int)colOutG, (int)colOutB);
        graphicsIn.m_280509_(left + 1, top, right - 1, top + 1, k2);
        graphicsIn.m_280509_(left + 1, bottom, right - 1, bottom - 1, k2);
        graphicsIn.m_280509_(left, top, left + 1, bottom, k2);
        graphicsIn.m_280509_(right, top, right - 1, bottom, k2);
    }

    public boolean m_7859_() {
        return true;
    }

    public void update() {
        this.colorBackground = f_96161_.getAsInt();
        this.colorBar = f_96161_.getAsInt();
        this.colorOutline = 0xFFFFFF;
        this.colorProgress = 0xFFFFFF;
        if (!Config.isCustomColors()) {
            return;
        }
        try {
            String fileName = "optifine/color.properties";
            ResourceLocation loc = new ResourceLocation(fileName);
            if (!Config.hasResource((ResourceLocation)loc)) {
                return;
            }
            InputStream in = Config.getResourceStream((ResourceLocation)loc);
            Config.dbg((String)("Loading " + fileName));
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            this.colorBackground = LoadingOverlay.readColor((Properties)props, (String)"screen.loading", (int)this.colorBackground);
            this.colorOutline = LoadingOverlay.readColor((Properties)props, (String)"screen.loading.outline", (int)this.colorOutline);
            this.colorBar = LoadingOverlay.readColor((Properties)props, (String)"screen.loading.bar", (int)this.colorBar);
            this.colorProgress = LoadingOverlay.readColor((Properties)props, (String)"screen.loading.progress", (int)this.colorProgress);
            this.blendState = ShaderPackParser.parseBlendState((String)props.getProperty("screen.loading.blend"));
        }
        catch (Exception e2) {
            Config.warn((String)(e2.getClass().getName() + ": " + e2.getMessage()));
        }
    }

    private static int readColor(Properties props, String name, int colDef) {
        String str = props.getProperty(name);
        if (str == null) {
            return colDef;
        }
        int color = LoadingOverlay.parseColor((String)(str = str.trim()), (int)colDef);
        if (color < 0) {
            Config.warn((String)("Invalid color: " + name + " = " + str));
            return color;
        }
        Config.dbg((String)(name + " = " + str));
        return color;
    }

    private static int parseColor(String str, int colDef) {
        if (str == null) {
            return colDef;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e2) {
            return colDef;
        }
    }

    public boolean isFadeOut() {
        return this.fadeOut;
    }
}

