/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;

public class BossHealthOverlay {
    private static final ResourceLocation f_93697_ = new ResourceLocation("textures/gui/bars.png");
    private static final int f_168805_ = 182;
    private static final int f_168806_ = 5;
    private static final int f_168807_ = 80;
    private final Minecraft f_93698_;
    final Map<UUID, LerpingBossEvent> f_93699_ = Maps.newLinkedHashMap();

    public BossHealthOverlay(Minecraft clientIn) {
        this.f_93698_ = clientIn;
    }

    public void m_280652_(GuiGraphics graphicsIn) {
        if (!this.f_93699_.isEmpty()) {
            int i2 = graphicsIn.m_280182_();
            int j2 = 12;
            for (LerpingBossEvent lerpingbossevent : this.f_93699_.values()) {
                int k2 = i2 / 2 - 91;
                boolean render = true;
                int increment = 19;
                if (Reflector.ForgeHooksClient_onCustomizeBossEventProgress.exists()) {
                    Object[] objectArray = new Object[6];
                    objectArray[0] = graphicsIn;
                    objectArray[1] = this.f_93698_.m_91268_();
                    objectArray[2] = lerpingbossevent;
                    objectArray[3] = k2;
                    objectArray[4] = j2;
                    Objects.requireNonNull(this.f_93698_.f_91062_);
                    objectArray[5] = 10 + 9;
                    Object event = Reflector.ForgeHooksClient_onCustomizeBossEventProgress.call(objectArray);
                    render = !Reflector.callBoolean((Object)event, (ReflectorMethod)Reflector.Event_isCanceled, (Object[])new Object[0]);
                    increment = Reflector.callInt((Object)event, (ReflectorMethod)Reflector.CustomizeGuiOverlayEvent_BossEventProgress_getIncrement, (Object[])new Object[0]);
                }
                if (render) {
                    this.m_280106_(graphicsIn, k2, j2, (BossEvent)lerpingbossevent);
                    Component component = lerpingbossevent.m_18861_();
                    int l2 = this.f_93698_.f_91062_.m_92852_((FormattedText)component);
                    int i1 = i2 / 2 - l2 / 2;
                    int j1 = j2 - 9;
                    int col = 0xFFFFFF;
                    if (Config.isCustomColors()) {
                        col = CustomColors.getBossTextColor((int)col);
                    }
                    graphicsIn.m_280430_(this.f_93698_.f_91062_, component, i1, j1, col);
                }
                if ((j2 += increment) < graphicsIn.m_280206_() / 3) continue;
                break;
            }
        }
    }

    private void m_280106_(GuiGraphics graphicsIn, int xIn, int yIn, BossEvent eventIn) {
        this.m_280093_(graphicsIn, xIn, yIn, eventIn, 182, 0);
        int i2 = (int)(eventIn.m_142717_() * 183.0f);
        if (i2 > 0) {
            this.m_280093_(graphicsIn, xIn, yIn, eventIn, i2, 5);
        }
    }

    private void m_280093_(GuiGraphics graphicsIn, int xIn, int yIn, BossEvent eventIn, int widthIn, int vOffsetIn) {
        graphicsIn.m_280218_(f_93697_, xIn, yIn, 0, eventIn.m_18862_().ordinal() * 5 * 2 + vOffsetIn, widthIn, 5);
        if (eventIn.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.enableBlend();
            graphicsIn.m_280218_(f_93697_, xIn, yIn, 0, 80 + (eventIn.m_18863_().ordinal() - 1) * 5 * 2 + vOffsetIn, widthIn, 5);
            RenderSystem.disableBlend();
        }
    }

    public void m_93711_(ClientboundBossEventPacket packetIn) {
        packetIn.m_178643_((ClientboundBossEventPacket.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void m_93703_() {
        this.f_93699_.clear();
    }

    public boolean m_93713_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                if (!bossevent.m_18865_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93714_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                if (!bossevent.m_18864_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_93715_() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                if (!bossevent.m_18866_()) continue;
                return true;
            }
        }
        return false;
    }

    public String getBossName() {
        if (!this.f_93699_.isEmpty()) {
            for (BossEvent bossevent : this.f_93699_.values()) {
                ComponentContents cont;
                Component name = bossevent.m_18861_();
                if (name == null || !((cont = name.m_214077_()) instanceof TranslatableContents)) continue;
                TranslatableContents tranCont = (TranslatableContents)cont;
                return tranCont.m_237508_();
            }
        }
        return null;
    }
}

