/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Divisor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.IForgeGuiGraphics;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorMethod;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2ic;

/*
 * Exception performing whole class analysis ignored.
 */
public class GuiGraphics
implements IForgeGuiGraphics {
    public static final float f_289044_ = 10000.0f;
    public static final float f_289038_ = -10000.0f;
    private static final int f_279564_ = 2;
    private final Minecraft f_279544_;
    private final PoseStack f_279612_;
    private final MultiBufferSource.BufferSource f_279627_;
    private final ScissorStack f_279587_ = new ScissorStack();
    private boolean f_285610_;
    private ItemStack tooltipStack = ItemStack.f_41583_;

    private GuiGraphics(Minecraft minecraftIn, PoseStack matrixStackIn, MultiBufferSource.BufferSource bufferSourceIn) {
        this.f_279544_ = minecraftIn;
        this.f_279612_ = matrixStackIn;
        this.f_279627_ = bufferSourceIn;
    }

    public GuiGraphics(Minecraft minecraftIn, MultiBufferSource.BufferSource bufferSourceIn) {
        this(minecraftIn, new PoseStack(), bufferSourceIn);
    }

    @Deprecated
    public void m_286007_(Runnable runnableIn) {
        this.m_280262_();
        this.f_285610_ = true;
        runnableIn.run();
        this.f_285610_ = false;
        this.m_280262_();
    }

    @Deprecated
    private void m_286081_() {
        if (!this.f_285610_) {
            this.m_280262_();
        }
    }

    @Deprecated
    private void m_287246_() {
        if (this.f_285610_) {
            this.m_280262_();
        }
    }

    public int m_280182_() {
        return this.f_279544_.m_91268_().m_85445_();
    }

    public int m_280206_() {
        return this.f_279544_.m_91268_().m_85446_();
    }

    public PoseStack m_280168_() {
        return this.f_279612_;
    }

    public MultiBufferSource.BufferSource m_280091_() {
        return this.f_279627_;
    }

    public void m_280262_() {
        RenderSystem.disableDepthTest();
        this.f_279627_.m_109911_();
        RenderSystem.enableDepthTest();
    }

    public void m_280656_(int startX, int endX, int y, int colorIn) {
        this.m_285844_(RenderType.m_285907_(), startX, endX, y, colorIn);
    }

    public void m_285844_(RenderType renderTypeIn, int startX, int endX, int y, int colorIn) {
        if (endX < startX) {
            int i2 = startX;
            startX = endX;
            endX = i2;
        }
        this.m_285944_(renderTypeIn, startX, y, endX + 1, y + 1, colorIn);
    }

    public void m_280315_(int x, int startY, int endY, int colorIn) {
        this.m_285886_(RenderType.m_285907_(), x, startY, endY, colorIn);
    }

    public void m_285886_(RenderType renderTypeIn, int x, int startY, int endY, int colorIn) {
        if (endY < startY) {
            int i2 = startY;
            startY = endY;
            endY = i2;
        }
        this.m_285944_(renderTypeIn, x, startY + 1, x + 1, endY, colorIn);
    }

    public void m_280588_(int left, int top, int right, int bottom) {
        this.m_280185_(this.f_279587_.m_280318_(new ScreenRectangle(left, top, right - left, bottom - top)));
    }

    public void m_280618_() {
        this.m_280185_(this.f_279587_.m_280462_());
    }

    private void m_280185_(@Nullable ScreenRectangle rectIn) {
        this.m_287246_();
        if (rectIn != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            int i2 = window.m_85442_();
            double d0 = window.m_85449_();
            double d1 = (double)rectIn.m_274563_() * d0;
            double d2 = (double)i2 - (double)rectIn.m_274349_() * d0;
            double d3 = (double)rectIn.f_263770_() * d0;
            double d4 = (double)rectIn.f_263800_() * d0;
            RenderSystem.enableScissor((int)((int)d1), (int)((int)d2), (int)Math.max(0, (int)d3), (int)Math.max(0, (int)d4));
        } else {
            RenderSystem.disableScissor();
        }
    }

    public void m_280246_(float red, float green, float blue, float alpha) {
        this.m_287246_();
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void m_280509_(int left, int top, int right, int bottom, int colorIn) {
        this.m_280046_(left, top, right, bottom, 0, colorIn);
    }

    public void m_280046_(int left, int top, int right, int bottom, int z, int colorIn) {
        this.m_285795_(RenderType.m_285907_(), left, top, right, bottom, z, colorIn);
    }

    public void m_285944_(RenderType renderTypeIn, int left, int top, int right, int bottom, int colorIn) {
        this.m_285795_(renderTypeIn, left, top, right, bottom, 0, colorIn);
    }

    public void m_285795_(RenderType renderTypeIn, int left, int top, int right, int bottom, int z, int colorIn) {
        Matrix4f matrix4f = this.f_279612_.m_85850_().m_252922_();
        if (left < right) {
            int i2 = left;
            left = right;
            right = i2;
        }
        if (top < bottom) {
            int j2 = top;
            top = bottom;
            bottom = j2;
        }
        float f3 = (float)FastColor.ARGB32.m_13655_((int)colorIn) / 255.0f;
        float f2 = (float)FastColor.ARGB32.m_13665_((int)colorIn) / 255.0f;
        float f1 = (float)FastColor.ARGB32.m_13667_((int)colorIn) / 255.0f;
        float f22 = (float)FastColor.ARGB32.m_13669_((int)colorIn) / 255.0f;
        VertexConsumer vertexconsumer = this.f_279627_.m_6299_(renderTypeIn);
        vertexconsumer.m_252986_(matrix4f, (float)left, (float)top, (float)z).m_85950_(f2, f1, f22, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)left, (float)bottom, (float)z).m_85950_(f2, f1, f22, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)right, (float)bottom, (float)z).m_85950_(f2, f1, f22, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)right, (float)top, (float)z).m_85950_(f2, f1, f22, f3).m_5752_();
        this.m_286081_();
    }

    public void m_280024_(int left, int top, int right, int bottom, int startColor, int endColor) {
        this.m_280120_(left, top, right, bottom, 0, startColor, endColor);
    }

    public void m_280120_(int left, int top, int right, int bottom, int z, int startColor, int endColor) {
        this.m_285978_(RenderType.m_285907_(), left, top, right, bottom, startColor, endColor, z);
    }

    public void m_285978_(RenderType renderTypeIn, int left, int top, int right, int bottom, int startColor, int endColor, int z) {
        VertexConsumer vertexconsumer = this.f_279627_.m_6299_(renderTypeIn);
        this.m_280584_(vertexconsumer, left, top, right, bottom, z, startColor, endColor);
        this.m_286081_();
    }

    private void m_280584_(VertexConsumer bufferIn, int left, int top, int right, int bottom, int z, int startColor, int endColor) {
        float f2 = (float)FastColor.ARGB32.m_13655_((int)startColor) / 255.0f;
        float f1 = (float)FastColor.ARGB32.m_13665_((int)startColor) / 255.0f;
        float f22 = (float)FastColor.ARGB32.m_13667_((int)startColor) / 255.0f;
        float f3 = (float)FastColor.ARGB32.m_13669_((int)startColor) / 255.0f;
        float f4 = (float)FastColor.ARGB32.m_13655_((int)endColor) / 255.0f;
        float f5 = (float)FastColor.ARGB32.m_13665_((int)endColor) / 255.0f;
        float f6 = (float)FastColor.ARGB32.m_13667_((int)endColor) / 255.0f;
        float f7 = (float)FastColor.ARGB32.m_13669_((int)endColor) / 255.0f;
        Matrix4f matrix4f = this.f_279612_.m_85850_().m_252922_();
        bufferIn.m_252986_(matrix4f, (float)left, (float)top, (float)z).m_85950_(f1, f22, f3, f2).m_5752_();
        bufferIn.m_252986_(matrix4f, (float)left, (float)bottom, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
        bufferIn.m_252986_(matrix4f, (float)right, (float)bottom, (float)z).m_85950_(f5, f6, f7, f4).m_5752_();
        bufferIn.m_252986_(matrix4f, (float)right, (float)top, (float)z).m_85950_(f1, f22, f3, f2).m_5752_();
    }

    public void m_280137_(Font font, String text, int x, int y, int color) {
        this.m_280488_(font, text, x - font.m_92895_(text) / 2, y, color);
    }

    public void m_280653_(Font font, Component text, int x, int y, int color) {
        FormattedCharSequence formattedcharsequence = text.m_7532_();
        this.m_280648_(font, formattedcharsequence, x - font.m_92724_(formattedcharsequence) / 2, y, color);
    }

    public void m_280364_(Font font, FormattedCharSequence text, int x, int y, int color) {
        this.m_280648_(font, text, x - font.m_92724_(text) / 2, y, color);
    }

    public int m_280488_(Font font, @Nullable String text, int x, int y, int color) {
        return this.m_280056_(font, text, x, y, color, true);
    }

    public int m_280056_(Font font, @Nullable String text, int x, int y, int color, boolean shadow) {
        return this.drawString(font, text, (float)x, (float)y, color, shadow);
    }

    public int drawString(Font font, @Nullable String text, float x, float y, int color, boolean shadow) {
        if (text == null) {
            return 0;
        }
        int i2 = font.m_272078_(text, x, y, color, shadow, this.f_279612_.m_85850_().m_252922_(), (MultiBufferSource)this.f_279627_, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
        this.m_286081_();
        return i2;
    }

    public int m_280648_(Font font, FormattedCharSequence text, int x, int y, int color) {
        return this.m_280649_(font, text, x, y, color, true);
    }

    public int m_280649_(Font font, FormattedCharSequence text, int x, int y, int color, boolean shadow) {
        return this.drawString(font, text, (float)x, (float)y, color, shadow);
    }

    public int drawString(Font font, FormattedCharSequence text, float x, float y, int color, boolean shadow) {
        int i2 = font.m_272191_(text, x, y, color, shadow, this.f_279612_.m_85850_().m_252922_(), (MultiBufferSource)this.f_279627_, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.m_286081_();
        return i2;
    }

    public int m_280430_(Font font, Component component, int x, int y, int color) {
        return this.m_280614_(font, component, x, y, color, true);
    }

    public int m_280614_(Font font, Component component, int x, int y, int color, boolean shadow) {
        return this.m_280649_(font, component.m_7532_(), x, y, color, shadow);
    }

    public void m_280554_(Font font, FormattedText text, int x, int y, int width, int color) {
        for (FormattedCharSequence formattedcharsequence : font.m_92923_(text, width)) {
            this.m_280649_(font, formattedcharsequence, x, y, color, false);
            y += 9;
        }
    }

    public void m_280159_(int x, int y, int depth, int width, int height, TextureAtlasSprite spriteIn) {
        this.m_280444_(spriteIn.m_247685_(), x, x + width, y, y + height, depth, spriteIn.m_118409_(), spriteIn.m_118410_(), spriteIn.m_118411_(), spriteIn.m_118412_());
    }

    public void m_280565_(int x, int y, int z, int width, int height, TextureAtlasSprite spriteIn, float red, float green, float blue, float alpha) {
        this.m_280479_(spriteIn.m_247685_(), x, x + width, y, y + height, z, spriteIn.m_118409_(), spriteIn.m_118410_(), spriteIn.m_118411_(), spriteIn.m_118412_(), red, green, blue, alpha);
    }

    public void m_280637_(int left, int top, int width, int height, int colorIn) {
        this.m_280509_(left, top, left + width, top + 1, colorIn);
        this.m_280509_(left, top + height - 1, left + width, top + height, colorIn);
        this.m_280509_(left, top + 1, left + 1, top + height - 1, colorIn);
        this.m_280509_(left + width - 1, top + 1, left + width, top + height - 1, colorIn);
    }

    public void m_280218_(ResourceLocation locationIn, int x, int y, int rectX, int rectY, int width, int height) {
        this.m_280398_(locationIn, x, y, 0, (float)rectX, (float)rectY, width, height, 256, 256);
    }

    public void m_280398_(ResourceLocation locationIn, int x, int y, int depth, float rectX, float rectY, int width, int height, int texWidth, int texHeight) {
        this.m_280312_(locationIn, x, x + width, y, y + height, depth, width, height, rectX, rectY, texWidth, texHeight);
    }

    public void m_280411_(ResourceLocation locationIn, int x, int y, int width, int height, float rectX, float rectY, int rectWidth, int rectHeight, int texWidth, int texHeight) {
        this.m_280312_(locationIn, x, x + width, y, y + height, 0, rectWidth, rectHeight, rectX, rectY, texWidth, texHeight);
    }

    public void m_280163_(ResourceLocation locationIn, int x, int y, float rectX, float rectY, int width, int height, int texWidth, int texHeight) {
        this.m_280411_(locationIn, x, y, width, height, rectX, rectY, width, height, texWidth, texHeight);
    }

    void m_280312_(ResourceLocation locationIn, int startX, int endX, int startY, int endY, int depth, int rectWidth, int rectHeight, float rectX, float rectY, int texWidth, int texHeight) {
        this.m_280444_(locationIn, startX, endX, startY, endY, depth, (rectX + 0.0f) / (float)texWidth, (rectX + (float)rectWidth) / (float)texWidth, (rectY + 0.0f) / (float)texHeight, (rectY + (float)rectHeight) / (float)texHeight);
    }

    void m_280444_(ResourceLocation locationIn, int startX, int endX, int startY, int endY, int depth, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)locationIn);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = this.f_279612_.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)startX, (float)startY, (float)depth).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)startX, (float)endY, (float)depth).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)endX, (float)endY, (float)depth).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)endX, (float)startY, (float)depth).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    void m_280479_(ResourceLocation locationIn, int startX, int endX, int startY, int endY, int depth, float minU, float maxU, float minV, float maxV, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)locationIn);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = this.f_279612_.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_252986_(matrix4f, (float)startX, (float)startY, (float)depth).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)startX, (float)endY, (float)depth).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)endX, (float)endY, (float)depth).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)endX, (float)startY, (float)depth).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public void m_280260_(ResourceLocation locationIn, int x, int y, int width, int height, int p_280260_6_, int p_280260_7_, int p_280260_8_, int p_280260_9_, int p_280260_10_) {
        this.m_280195_(locationIn, x, y, width, height, p_280260_6_, p_280260_6_, p_280260_6_, p_280260_6_, p_280260_7_, p_280260_8_, p_280260_9_, p_280260_10_);
    }

    public void m_280027_(ResourceLocation locationIn, int x, int y, int width, int height, int p_280027_6_, int p_280027_7_, int p_280027_8_, int p_280027_9_, int p_280027_10_, int p_280027_11_) {
        this.m_280195_(locationIn, x, y, width, height, p_280027_6_, p_280027_7_, p_280027_6_, p_280027_7_, p_280027_8_, p_280027_9_, p_280027_10_, p_280027_11_);
    }

    public void m_280195_(ResourceLocation locationIn, int x, int y, int width, int height, int p_280195_6_, int p_280195_7_, int p_280195_8_, int p_280195_9_, int p_280195_10_, int p_280195_11_, int p_280195_12_, int p_280195_13_) {
        p_280195_6_ = Math.min(p_280195_6_, width / 2);
        p_280195_8_ = Math.min(p_280195_8_, width / 2);
        p_280195_7_ = Math.min(p_280195_7_, height / 2);
        p_280195_9_ = Math.min(p_280195_9_, height / 2);
        if (width == p_280195_10_ && height == p_280195_11_) {
            this.m_280218_(locationIn, x, y, p_280195_12_, p_280195_13_, width, height);
        } else if (height == p_280195_11_) {
            this.m_280218_(locationIn, x, y, p_280195_12_, p_280195_13_, p_280195_6_, height);
            this.m_280543_(locationIn, x + p_280195_6_, y, width - p_280195_8_ - p_280195_6_, height, p_280195_12_ + p_280195_6_, p_280195_13_, p_280195_10_ - p_280195_8_ - p_280195_6_, p_280195_11_);
            this.m_280218_(locationIn, x + width - p_280195_8_, y, p_280195_12_ + p_280195_10_ - p_280195_8_, p_280195_13_, p_280195_8_, height);
        } else if (width == p_280195_10_) {
            this.m_280218_(locationIn, x, y, p_280195_12_, p_280195_13_, width, p_280195_7_);
            this.m_280543_(locationIn, x, y + p_280195_7_, width, height - p_280195_9_ - p_280195_7_, p_280195_12_, p_280195_13_ + p_280195_7_, p_280195_10_, p_280195_11_ - p_280195_9_ - p_280195_7_);
            this.m_280218_(locationIn, x, y + height - p_280195_9_, p_280195_12_, p_280195_13_ + p_280195_11_ - p_280195_9_, width, p_280195_9_);
        } else {
            this.m_280218_(locationIn, x, y, p_280195_12_, p_280195_13_, p_280195_6_, p_280195_7_);
            this.m_280543_(locationIn, x + p_280195_6_, y, width - p_280195_8_ - p_280195_6_, p_280195_7_, p_280195_12_ + p_280195_6_, p_280195_13_, p_280195_10_ - p_280195_8_ - p_280195_6_, p_280195_7_);
            this.m_280218_(locationIn, x + width - p_280195_8_, y, p_280195_12_ + p_280195_10_ - p_280195_8_, p_280195_13_, p_280195_8_, p_280195_7_);
            this.m_280218_(locationIn, x, y + height - p_280195_9_, p_280195_12_, p_280195_13_ + p_280195_11_ - p_280195_9_, p_280195_6_, p_280195_9_);
            this.m_280543_(locationIn, x + p_280195_6_, y + height - p_280195_9_, width - p_280195_8_ - p_280195_6_, p_280195_9_, p_280195_12_ + p_280195_6_, p_280195_13_ + p_280195_11_ - p_280195_9_, p_280195_10_ - p_280195_8_ - p_280195_6_, p_280195_9_);
            this.m_280218_(locationIn, x + width - p_280195_8_, y + height - p_280195_9_, p_280195_12_ + p_280195_10_ - p_280195_8_, p_280195_13_ + p_280195_11_ - p_280195_9_, p_280195_8_, p_280195_9_);
            this.m_280543_(locationIn, x, y + p_280195_7_, p_280195_6_, height - p_280195_9_ - p_280195_7_, p_280195_12_, p_280195_13_ + p_280195_7_, p_280195_6_, p_280195_11_ - p_280195_9_ - p_280195_7_);
            this.m_280543_(locationIn, x + p_280195_6_, y + p_280195_7_, width - p_280195_8_ - p_280195_6_, height - p_280195_9_ - p_280195_7_, p_280195_12_ + p_280195_6_, p_280195_13_ + p_280195_7_, p_280195_10_ - p_280195_8_ - p_280195_6_, p_280195_11_ - p_280195_9_ - p_280195_7_);
            this.m_280543_(locationIn, x + width - p_280195_8_, y + p_280195_7_, p_280195_6_, height - p_280195_9_ - p_280195_7_, p_280195_12_ + p_280195_10_ - p_280195_8_, p_280195_13_ + p_280195_7_, p_280195_8_, p_280195_11_ - p_280195_9_ - p_280195_7_);
        }
    }

    public void m_280543_(ResourceLocation p_280543_1_, int p_280543_2_, int p_280543_3_, int p_280543_4_, int p_280543_5_, int p_280543_6_, int p_280543_7_, int p_280543_8_, int p_280543_9_) {
        this.blitRepeating(p_280543_1_, p_280543_2_, p_280543_3_, p_280543_4_, p_280543_5_, p_280543_6_, p_280543_7_, p_280543_8_, p_280543_9_, 256, 256);
    }

    public void blitRepeating(ResourceLocation p_280543_1_, int p_280543_2_, int p_280543_3_, int p_280543_4_, int p_280543_5_, int p_280543_6_, int p_280543_7_, int p_280543_8_, int p_280543_9_, int textureWidth, int textureHeight) {
        int i2 = p_280543_2_;
        IntIterator intiterator = GuiGraphics.m_280358_((int)p_280543_4_, (int)p_280543_8_);
        while (intiterator.hasNext()) {
            int j2 = intiterator.nextInt();
            int k2 = (p_280543_8_ - j2) / 2;
            int l2 = p_280543_3_;
            IntIterator intiterator1 = GuiGraphics.m_280358_((int)p_280543_5_, (int)p_280543_9_);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (p_280543_9_ - i1) / 2;
                this.m_280163_(p_280543_1_, i2, l2, (float)(p_280543_6_ + k2), (float)(p_280543_7_ + j1), j2, i1, textureWidth, textureHeight);
                l2 += i1;
            }
            i2 += j2;
        }
    }

    private static IntIterator m_280358_(int p_280358_0_, int p_280358_1_) {
        int i2 = Mth.m_184652_((int)p_280358_0_, (int)p_280358_1_);
        return new Divisor(p_280358_0_, i2);
    }

    public void m_280480_(ItemStack stackIn, int xIn, int yIn) {
        this.m_280053_((LivingEntity)this.f_279544_.f_91074_, (Level)this.f_279544_.f_91073_, stackIn, xIn, yIn, 0);
    }

    public void m_280256_(ItemStack stackIn, int xIn, int yIn, int seedIn) {
        this.m_280053_((LivingEntity)this.f_279544_.f_91074_, (Level)this.f_279544_.f_91073_, stackIn, xIn, yIn, seedIn);
    }

    public void m_280064_(ItemStack stackIn, int xIn, int yIn, int seedIn, int depthIn) {
        this.m_280405_((LivingEntity)this.f_279544_.f_91074_, (Level)this.f_279544_.f_91073_, stackIn, xIn, yIn, seedIn, depthIn);
    }

    public void m_280203_(ItemStack stackIn, int xIn, int yIn) {
        this.m_280053_((LivingEntity)null, (Level)this.f_279544_.f_91073_, stackIn, xIn, yIn, 0);
    }

    public void m_280638_(LivingEntity entityIn, ItemStack stackIn, int xIn, int yIn, int seedIn) {
        this.m_280053_(entityIn, entityIn.m_9236_(), stackIn, xIn, yIn, seedIn);
    }

    private void m_280053_(@Nullable LivingEntity entityIn, @Nullable Level worldIn, ItemStack stackIn, int xIn, int yIn, int seedIn) {
        this.m_280405_(entityIn, worldIn, stackIn, xIn, yIn, seedIn, 0);
    }

    private void m_280405_(@Nullable LivingEntity entityIn, @Nullable Level worldIn, ItemStack stackIn, int xIn, int yIn, int seedIn, int depthIn) {
        ItemRenderer.setRenderItemGui((boolean)true);
        if (!stackIn.m_41619_()) {
            BakedModel bakedmodel = this.f_279544_.m_91291_().m_174264_(stackIn, worldIn, entityIn, seedIn);
            this.f_279612_.m_85836_();
            this.f_279612_.m_252880_((float)(xIn + 8), (float)(yIn + 8), (float)(150 + (bakedmodel.m_7539_() ? depthIn : 0)));
            try {
                boolean flag;
                this.f_279612_.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                this.f_279612_.m_85841_(16.0f, 16.0f, 16.0f);
                boolean bl = flag = !bakedmodel.m_7547_();
                if (flag) {
                    Lighting.m_84930_();
                }
                this.f_279544_.m_91291_().m_115143_(stackIn, ItemDisplayContext.GUI, false, this.f_279612_, (MultiBufferSource)this.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
                this.m_280262_();
                if (flag) {
                    Lighting.m_84931_();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stackIn.m_41720_()));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stackIn.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stackIn.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stackIn.m_41790_()));
                throw new ReportedException(crashreport);
            }
            this.f_279612_.m_85849_();
        }
        ItemRenderer.setRenderItemGui((boolean)false);
    }

    public void m_280370_(Font fontIn, ItemStack stackIn, int xIn, int yIn) {
        this.m_280302_(fontIn, stackIn, xIn, yIn, (String)null);
    }

    public void m_280302_(Font fontIn, ItemStack stackIn, int xIn, int yIn, @Nullable String countStringIn) {
        if (!stackIn.m_41619_()) {
            LocalPlayer localplayer;
            float f2;
            this.f_279612_.m_85836_();
            if (stackIn.m_41613_() != 1 || countStringIn != null) {
                String s = countStringIn == null ? String.valueOf(stackIn.m_41613_()) : countStringIn;
                this.f_279612_.m_252880_(0.0f, 0.0f, 200.0f);
                this.m_280056_(fontIn, s, xIn + 19 - 2 - fontIn.m_92895_(s), yIn + 6 + 3, 0xFFFFFF, true);
            }
            if (stackIn.m_150947_()) {
                int l2 = stackIn.m_150948_();
                int i2 = stackIn.m_150949_();
                if (Config.isCustomColors()) {
                    float dmg = stackIn.m_41773_();
                    float maxDmg = stackIn.m_41776_();
                    float durability = Math.max(0.0f, (maxDmg - dmg) / maxDmg);
                    i2 = CustomColors.getDurabilityColor((float)durability, (int)i2);
                }
                int j2 = xIn + 2;
                int k2 = yIn + 13;
                this.m_285944_(RenderType.m_286086_(), j2, k2, j2 + 13, k2 + 2, -16777216);
                this.m_285944_(RenderType.m_286086_(), j2, k2, j2 + l2, k2 + 1, i2 | 0xFF000000);
            }
            float f3 = f2 = (localplayer = this.f_279544_.f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stackIn.m_41720_(), this.f_279544_.m_91296_());
            if (f2 > 0.0f) {
                int i1 = yIn + Mth.m_14143_((float)(16.0f * (1.0f - f2)));
                int j1 = i1 + Mth.m_14167_((float)(16.0f * f2));
                this.m_285944_(RenderType.m_286086_(), xIn, i1, xIn + 16, j1, Integer.MAX_VALUE);
            }
            this.f_279612_.m_85849_();
            if (Reflector.ItemDecoratorHandler_render.exists()) {
                Object idh = Reflector.call((ReflectorMethod)Reflector.ItemDecoratorHandler_of, (Object[])new Object[]{stackIn});
                Reflector.call((Object)idh, (ReflectorMethod)Reflector.ItemDecoratorHandler_render, (Object[])new Object[]{this, fontIn, stackIn, xIn, yIn});
            }
        }
    }

    public void m_280153_(Font fontIn, ItemStack stackIn, int xIn, int yIn) {
        this.tooltipStack = stackIn;
        this.m_280677_(fontIn, Screen.m_280152_((Minecraft)this.f_279544_, (ItemStack)stackIn), stackIn.m_150921_(), xIn, yIn);
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void renderTooltip(Font font, List<Component> textComponents, Optional<TooltipComponent> tooltipComponent, ItemStack stack, int mouseX, int mouseY) {
        this.tooltipStack = stack;
        this.m_280677_(font, textComponents, tooltipComponent, mouseX, mouseY);
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void m_280677_(Font fontIn, List<Component> listIn, Optional<TooltipComponent> componentIn, int xIn, int yIn) {
        List list = listIn.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).collect(Collectors.toList());
        componentIn.ifPresent(p_280645_1_ -> list.add(1, ClientTooltipComponent.m_169950_((TooltipComponent)p_280645_1_)));
        if (Reflector.ForgeHooksClient_gatherTooltipComponents7.exists()) {
            List listForge = (List)Reflector.ForgeHooksClient_gatherTooltipComponents7.call(new Object[]{this.tooltipStack, listIn, componentIn, xIn, this.m_280182_(), this.m_280206_(), fontIn});
            list.clear();
            list.addAll(listForge);
        }
        this.m_280497_(fontIn, list, xIn, yIn, DefaultTooltipPositioner.f_262752_);
    }

    public void m_280557_(Font fontIn, Component componentIn, int xIn, int yIn) {
        this.m_280245_(fontIn, List.of(componentIn.m_7532_()), xIn, yIn);
    }

    public void m_280666_(Font fontIn, List<Component> componentsIn, int xIn, int yIn) {
        if (Reflector.ForgeHooksClient_gatherTooltipComponents6.exists()) {
            List components = (List)Reflector.ForgeHooksClient_gatherTooltipComponents6.call(new Object[]{this.tooltipStack, componentsIn, xIn, this.m_280182_(), this.m_280206_(), fontIn});
            this.m_280497_(fontIn, components, xIn, yIn, DefaultTooltipPositioner.f_262752_);
        } else {
            this.m_280245_(fontIn, Lists.transform(componentsIn, Component::m_7532_), xIn, yIn);
        }
    }

    public void renderComponentTooltip(Font font, List<? extends FormattedText> tooltips, int mouseX, int mouseY, ItemStack stack) {
        this.tooltipStack = stack;
        List components = (List)Reflector.ForgeHooksClient_gatherTooltipComponents6.call(new Object[]{stack, tooltips, mouseX, this.m_280182_(), this.m_280206_(), font});
        this.m_280497_(font, components, mouseX, mouseY, DefaultTooltipPositioner.f_262752_);
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void m_280245_(Font fontIn, List<? extends FormattedCharSequence> listIn, int xIn, int yIn) {
        this.m_280497_(fontIn, listIn.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), xIn, yIn, DefaultTooltipPositioner.f_262752_);
    }

    public void m_280547_(Font fontIn, List<FormattedCharSequence> listIn, ClientTooltipPositioner positionerIn, int xIn, int yIn) {
        this.m_280497_(fontIn, listIn.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), xIn, yIn, positionerIn);
    }

    private void m_280497_(Font fontIn, List<ClientTooltipComponent> listIn, int xIn, int yIn, ClientTooltipPositioner positionerIn) {
        if (!listIn.isEmpty()) {
            Object preEvent = null;
            if (Reflector.ForgeHooksClient_onRenderTooltipPre.exists() && Reflector.callBoolean((Object)(preEvent = Reflector.ForgeHooksClient_onRenderTooltipPre.call(new Object[]{this.tooltipStack, this, xIn, yIn, this.m_280182_(), this.m_280206_(), listIn, fontIn, positionerIn})), (ReflectorMethod)Reflector.Event_isCanceled, (Object[])new Object[0])) {
                return;
            }
            int i2 = 0;
            int j2 = listIn.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : listIn) {
                int k2;
                if (preEvent != null) {
                    fontIn = (Font)Reflector.call(preEvent, (ReflectorMethod)Reflector.RenderTooltipEvent_getFont, (Object[])new Object[0]);
                }
                if ((k2 = clienttooltipcomponent.m_142069_(fontIn)) > i2) {
                    i2 = k2;
                }
                j2 += clienttooltipcomponent.m_142103_();
            }
            int i22 = i2;
            int j22 = j2;
            if (preEvent != null) {
                xIn = Reflector.callInt(preEvent, (ReflectorMethod)Reflector.RenderTooltipEvent_getX, (Object[])new Object[0]);
                yIn = Reflector.callInt(preEvent, (ReflectorMethod)Reflector.RenderTooltipEvent_getY, (Object[])new Object[0]);
            }
            Vector2ic vector2ic = positionerIn.m_262814_(this.m_280182_(), this.m_280206_(), xIn, yIn, i22, j22);
            int l2 = vector2ic.x();
            int i1 = vector2ic.y();
            this.f_279612_.m_85836_();
            int j1 = 400;
            Font forgeFont = fontIn;
            this.m_286007_(() -> {
                if (Reflector.ForgeHooksClient_onRenderTooltipColor.exists()) {
                    Object colorEvent = Reflector.ForgeHooksClient_onRenderTooltipColor.call(new Object[]{this.tooltipStack, this, l2, i1, forgeFont, listIn});
                    int backStart = Reflector.callInt((Object)colorEvent, (ReflectorMethod)Reflector.RenderTooltipEvent_Color_getBackgroundStart, (Object[])new Object[0]);
                    int backEnd = Reflector.callInt((Object)colorEvent, (ReflectorMethod)Reflector.RenderTooltipEvent_Color_getBackgroundEnd, (Object[])new Object[0]);
                    int borderStart = Reflector.callInt((Object)colorEvent, (ReflectorMethod)Reflector.RenderTooltipEvent_Color_getBorderStart, (Object[])new Object[0]);
                    int borderEnd = Reflector.callInt((Object)colorEvent, (ReflectorMethod)Reflector.RenderTooltipEvent_Color_getBorderEnd, (Object[])new Object[0]);
                    Reflector.TooltipRenderUtil_renderTooltipBackground10.call(new Object[]{this, l2, i1, i22, j22, 400, backStart, backEnd, borderStart, borderEnd});
                } else {
                    TooltipRenderUtil.m_280205_((GuiGraphics)this, (int)l2, (int)i1, (int)i22, (int)j22, (int)400);
                }
            });
            this.f_279612_.m_252880_(0.0f, 0.0f, 400.0f);
            int k1 = i1;
            for (int l1 = 0; l1 < listIn.size(); ++l1) {
                ClientTooltipComponent clienttooltipcomponent1 = listIn.get(l1);
                clienttooltipcomponent1.m_142440_(fontIn, l2, k1, this.f_279612_.m_85850_().m_252922_(), this.f_279627_);
                k1 += clienttooltipcomponent1.m_142103_() + (l1 == 0 ? 2 : 0);
            }
            k1 = i1;
            for (int k2 = 0; k2 < listIn.size(); ++k2) {
                ClientTooltipComponent clienttooltipcomponent2 = listIn.get(k2);
                clienttooltipcomponent2.m_183452_(fontIn, l2, k1, this);
                k1 += clienttooltipcomponent2.m_142103_() + (k2 == 0 ? 2 : 0);
            }
            this.f_279612_.m_85849_();
        }
    }

    public void m_280304_(Font fontIn, @Nullable Style styleIn, int xIn, int yIn) {
        if (styleIn != null && styleIn.m_131186_() != null) {
            HoverEvent hoverevent = styleIn.m_131186_();
            HoverEvent.ItemStackInfo hoverevent$itemstackinfo = (HoverEvent.ItemStackInfo)hoverevent.m_130823_(HoverEvent.Action.f_130832_);
            if (hoverevent$itemstackinfo != null) {
                this.m_280153_(fontIn, hoverevent$itemstackinfo.m_130898_(), xIn, yIn);
            } else {
                HoverEvent.EntityTooltipInfo hoverevent$entitytooltipinfo = (HoverEvent.EntityTooltipInfo)hoverevent.m_130823_(HoverEvent.Action.f_130833_);
                if (hoverevent$entitytooltipinfo != null) {
                    if (this.f_279544_.f_91066_.f_92125_) {
                        this.m_280666_(fontIn, hoverevent$entitytooltipinfo.m_130884_(), xIn, yIn);
                    }
                } else {
                    Component component = (Component)hoverevent.m_130823_(HoverEvent.Action.f_130831_);
                    if (component != null) {
                        this.m_280245_(fontIn, fontIn.m_92923_((FormattedText)component, Math.max(this.m_280182_() / 2, 200)), xIn, yIn);
                    }
                }
            }
        }
    }

    public void getBulkData(RenderType renderType, ByteBuffer buffer) {
        if (renderType == null) {
            return;
        }
        VertexConsumer builder = this.f_279627_.m_6299_(renderType);
        if (builder.getVertexCount() <= 0) {
            return;
        }
        builder.getBulkData(buffer);
    }

    public void putBulkData(RenderType renderType, ByteBuffer buffer) {
        if (renderType == null) {
            return;
        }
        if (buffer.position() >= buffer.limit()) {
            return;
        }
        VertexConsumer builder = this.f_279627_.m_6299_(renderType);
        builder.putBulkData(buffer);
    }
}

