/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.optifine.Config;
import net.optifine.render.MultiTextureData;
import net.optifine.render.MultiTextureRenderer;
import net.optifine.render.VboRange;
import net.optifine.render.VboRegion;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.GpuMemory;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

/*
 * Exception performing whole class analysis ignored.
 */
public class VertexBuffer
implements AutoCloseable {
    private final Usage f_285574_;
    private int f_231217_;
    private int f_166860_;
    private int f_166862_;
    @Nullable
    private VertexFormat f_85917_;
    @Nullable
    private RenderSystem.AutoStorageIndexBuffer f_166865_;
    private VertexFormat.IndexType f_166861_;
    private int f_166863_;
    private VertexFormat.Mode f_166864_;
    private VboRegion vboRegion;
    private VboRange vboRange;
    private MultiTextureData multiTextureData;
    private static ByteBuffer emptyBuffer = MemoryTracker.m_182527_((int)0);

    public VertexBuffer(Usage usageIn) {
        this.f_285574_ = usageIn;
        RenderSystem.assertOnRenderThread();
        this.f_231217_ = GlStateManager._glGenBuffers();
        this.f_166860_ = GlStateManager._glGenBuffers();
        this.f_166862_ = GlStateManager._glGenVertexArrays();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_231221_(BufferBuilder.RenderedBuffer bufferIn) {
        if (!this.m_231230_()) {
            RenderSystem.assertOnRenderThread();
            try {
                GpuMemory.bufferFreed((long)this.getVertexBufferSize());
                GpuMemory.bufferFreed((long)this.getIndexBufferSize());
                BufferBuilder.DrawState bufferbuilder$drawstate = bufferIn.m_231198_();
                this.f_85917_ = this.m_231218_(bufferbuilder$drawstate, bufferIn.m_231196_());
                this.f_166865_ = this.m_231223_(bufferbuilder$drawstate, bufferIn.m_231197_());
                this.f_166863_ = bufferbuilder$drawstate.f_166797_();
                this.f_166861_ = bufferbuilder$drawstate.f_166798_();
                this.f_166864_ = bufferbuilder$drawstate.f_85735_();
                GpuMemory.bufferAllocated((long)this.getVertexBufferSize());
                GpuMemory.bufferAllocated((long)this.getIndexBufferSize());
                BufferBuilder.DrawState drawState = bufferbuilder$drawstate;
                if (this.vboRegion != null) {
                    ByteBuffer data = bufferIn.m_231196_();
                    data.position(0);
                    data.limit(drawState.m_166812_());
                    this.vboRegion.bufferData(data, this.vboRange);
                    data.position(0);
                    data.limit(drawState.m_166813_());
                    return;
                }
                this.multiTextureData = bufferbuilder$drawstate.getMultiTextureData();
            }
            finally {
                bufferIn.m_231200_();
            }
        }
    }

    private VertexFormat m_231218_(BufferBuilder.DrawState drawStateIn, ByteBuffer bufferIn) {
        if (this.vboRegion != null) {
            return drawStateIn.f_85733_();
        }
        boolean flag = false;
        if (!drawStateIn.f_85733_().equals((Object)this.f_85917_)) {
            if (this.f_85917_ != null) {
                this.f_85917_.m_86024_();
            }
            GlStateManager._glBindBuffer((int)34962, (int)this.f_231217_);
            drawStateIn.f_85733_().m_166912_();
            if (Config.isShaders()) {
                ShadersRender.setupArrayPointersVbo();
            }
            flag = true;
        }
        if (!drawStateIn.f_166799_()) {
            if (!flag) {
                GlStateManager._glBindBuffer((int)34962, (int)this.f_231217_);
            }
            RenderSystem.glBufferData((int)34962, (ByteBuffer)bufferIn, (int)this.f_285574_.f_285654_);
        }
        return drawStateIn.f_85733_();
    }

    @Nullable
    private RenderSystem.AutoStorageIndexBuffer m_231223_(BufferBuilder.DrawState drawStateIn, ByteBuffer bufferIn) {
        if (!drawStateIn.f_166800_()) {
            if (this.vboRegion != null) {
                return null;
            }
            GlStateManager._glBindBuffer((int)34963, (int)this.f_166860_);
            RenderSystem.glBufferData((int)34963, (ByteBuffer)bufferIn, (int)this.f_285574_.f_285654_);
            return null;
        }
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)drawStateIn.f_85735_());
        int indexCount = drawStateIn.f_166797_();
        if (this.vboRegion != null && drawStateIn.f_85735_() == VertexFormat.Mode.QUADS) {
            indexCount = 65536;
        }
        if (rendersystem$autostorageindexbuffer != this.f_166865_ || !rendersystem$autostorageindexbuffer.m_221944_(indexCount)) {
            rendersystem$autostorageindexbuffer.m_221946_(indexCount);
        }
        return rendersystem$autostorageindexbuffer;
    }

    public void m_85921_() {
        BufferUploader.m_231208_();
        if (this.f_166862_ >= 0) {
            GlStateManager._glBindVertexArray((int)this.f_166862_);
        }
    }

    public static void m_85931_() {
        BufferUploader.m_231208_();
        GlStateManager._glBindVertexArray((int)0);
    }

    public void m_166882_() {
        if (this.vboRegion != null) {
            this.vboRegion.drawArrays(VertexFormat.Mode.QUADS, this.vboRange);
        } else if (this.multiTextureData != null) {
            MultiTextureRenderer.draw((VertexFormat.Mode)this.f_166864_, (int)this.m_231231_().f_166923_, (MultiTextureData)this.multiTextureData);
        } else {
            RenderSystem.drawElements((int)this.f_166864_.f_166946_, (int)this.f_166863_, (int)this.m_231231_().f_166923_);
        }
    }

    private VertexFormat.IndexType m_231231_() {
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = this.f_166865_;
        return rendersystem$autostorageindexbuffer != null ? rendersystem$autostorageindexbuffer.m_157483_() : this.f_166861_;
    }

    public void m_253207_(Matrix4f matrixIn, Matrix4f projectionIn, ShaderInstance shaderIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.m_166876_(new Matrix4f((Matrix4fc)matrixIn), new Matrix4f((Matrix4fc)projectionIn), shaderIn));
        } else {
            this.m_166876_(matrixIn, projectionIn, shaderIn);
        }
    }

    private void m_166876_(Matrix4f matrixIn, Matrix4f projectionIn, ShaderInstance shaderIn) {
        boolean isShaderArrays;
        for (int i2 = 0; i2 < 12; ++i2) {
            int j2 = RenderSystem.getShaderTexture((int)i2);
            shaderIn.setSampler(i2, (Object)j2);
        }
        if (shaderIn.f_173308_ != null) {
            shaderIn.f_173308_.m_5679_(matrixIn);
        }
        if (shaderIn.f_173309_ != null) {
            shaderIn.f_173309_.m_5679_(projectionIn);
        }
        if (shaderIn.f_200956_ != null) {
            shaderIn.f_200956_.m_200759_(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shaderIn.f_173312_ != null) {
            shaderIn.f_173312_.m_5941_(RenderSystem.getShaderColor());
        }
        if (shaderIn.f_267422_ != null) {
            shaderIn.f_267422_.m_5985_(RenderSystem.getShaderGlintAlpha());
        }
        if (shaderIn.f_173315_ != null) {
            shaderIn.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
        }
        if (shaderIn.f_173316_ != null) {
            shaderIn.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (shaderIn.f_173317_ != null) {
            shaderIn.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
        }
        if (shaderIn.f_202432_ != null) {
            shaderIn.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (shaderIn.f_173310_ != null) {
            shaderIn.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
        }
        if (shaderIn.f_173319_ != null) {
            shaderIn.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
        }
        if (shaderIn.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shaderIn.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        if (shaderIn.f_173318_ != null && (this.f_166864_ == VertexFormat.Mode.LINES || this.f_166864_ == VertexFormat.Mode.LINE_STRIP)) {
            shaderIn.f_173318_.m_5985_(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights((ShaderInstance)shaderIn);
        shaderIn.m_173363_();
        boolean isShaders = Config.isShaders() && Shaders.isRenderingWorld;
        boolean bl = isShaderArrays = isShaders && SVertexBuilder.preDrawArrays((VertexFormat)this.f_85917_);
        if (isShaders) {
            Shaders.setModelViewMatrix((Matrix4f)matrixIn);
            Shaders.setProjectionMatrix((Matrix4f)projectionIn);
            Shaders.setTextureMatrix((Matrix4f)RenderSystem.getTextureMatrix());
            Shaders.setColorModulator((float[])RenderSystem.getShaderColor());
        }
        this.m_166882_();
        if (isShaderArrays) {
            SVertexBuilder.postDrawArrays();
        }
        shaderIn.m_173362_();
    }

    @Override
    public void close() {
        if (this.f_231217_ >= 0) {
            RenderSystem.glDeleteBuffers((int)this.f_231217_);
            this.f_231217_ = -1;
            GpuMemory.bufferFreed((long)this.getVertexBufferSize());
        }
        if (this.f_166860_ >= 0) {
            RenderSystem.glDeleteBuffers((int)this.f_166860_);
            this.f_166860_ = -1;
            GpuMemory.bufferFreed((long)this.getIndexBufferSize());
        }
        if (this.f_166862_ >= 0) {
            RenderSystem.glDeleteVertexArrays((int)this.f_166862_);
            this.f_166862_ = -1;
        }
        this.f_166863_ = 0;
    }

    public VertexFormat m_166892_() {
        return this.f_85917_;
    }

    public boolean m_231230_() {
        if (this.vboRegion != null) {
            return false;
        }
        return this.f_166862_ == -1;
    }

    public void setVboRegion(VboRegion vboRegion) {
        if (vboRegion == null) {
            return;
        }
        this.close();
        this.vboRegion = vboRegion;
        this.vboRange = new VboRange();
    }

    public VboRegion getVboRegion() {
        return this.vboRegion;
    }

    public boolean isEmpty() {
        return this.f_166863_ <= 0;
    }

    public void clearData() {
        if (this.f_166863_ <= 0) {
            return;
        }
        if (this.vboRegion != null) {
            this.vboRegion.bufferData(emptyBuffer, this.vboRange);
            this.f_166863_ = 0;
            return;
        }
        this.m_85921_();
        if (this.f_231217_ >= 0) {
            GlStateManager._glBindBuffer((int)34962, (int)this.f_231217_);
            GlStateManager._glBufferData((int)34962, (long)0L, (int)this.f_285574_.f_285654_);
            GpuMemory.bufferFreed((long)this.getVertexBufferSize());
        }
        if (this.f_166860_ >= 0 && this.f_166865_ == null) {
            GlStateManager._glBindBuffer((int)34963, (int)this.f_166860_);
            GlStateManager._glBufferData((int)34963, (long)0L, (int)this.f_285574_.f_285654_);
            GpuMemory.bufferFreed((long)this.getIndexBufferSize());
        }
        VertexBuffer.m_85931_();
        this.f_166863_ = 0;
    }

    public int getIndexCount() {
        return this.f_166863_;
    }

    private int getVertexBufferSize() {
        if (this.f_85917_ == null) {
            return 0;
        }
        return this.f_166863_ * this.f_85917_.m_86020_();
    }

    private int getIndexBufferSize() {
        if (this.f_166865_ != null) {
            return 0;
        }
        if (this.f_166861_ == null) {
            return 0;
        }
        return this.f_166863_ * this.f_166861_.f_166924_;
    }
}

