/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.DebugMemoryUntracker;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlDebug;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.util.ArrayUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class GlDebug {
    private static final Logger f_84028_ = LogUtils.getLogger();
    private static final int f_166220_ = 10;
    private static final Queue<LogEntry> f_166221_ = EvictingQueue.create((int)10);
    @Nullable
    private static volatile LogEntry f_166222_;
    private static final List<Integer> f_84032_;
    private static final List<Integer> f_84033_;
    private static boolean f_166223_;
    private static int[] ignoredErrors;

    private static int[] makeIgnoredErrors() {
        String prop = System.getProperty("gl.ignore.errors");
        if (prop == null) {
            return new int[0];
        }
        String[] parts = Config.tokenize((String)prop, (String)",");
        int[] ids = new int[]{};
        for (int i2 = 0; i2 < parts.length; ++i2) {
            int id;
            String part = parts[i2].trim();
            int n2 = id = part.startsWith("0x") ? Config.parseHexInt((String)part, (int)-1) : Config.parseInt((String)part, (int)-1);
            if (id < 0) {
                Config.warn((String)("Invalid error id: " + part));
                continue;
            }
            Config.log((String)("Ignore OpenGL error: " + id));
            ids = ArrayUtils.addIntToArray((int[])ids, (int)id);
        }
        return ids;
    }

    private static String m_84036_(int valueIn) {
        return "Unknown (0x" + Integer.toHexString(valueIn).toUpperCase() + ")";
    }

    public static String m_84055_(int sourceIn) {
        switch (sourceIn) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return GlDebug.m_84036_((int)sourceIn);
    }

    public static String m_84057_(int typeIn) {
        switch (typeIn) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return GlDebug.m_84036_((int)typeIn);
    }

    public static String m_84059_(int severityIn) {
        switch (severityIn) {
            case 33387: {
                return "NOTIFICATION";
            }
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return GlDebug.m_84036_((int)severityIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void m_84038_(int source, int type, int id, int severity, int messageLength, long message, long param) {
        if (type == 33385 || type == 33386) {
            return;
        }
        if (ArrayUtils.contains((int[])ignoredErrors, (int)id)) {
            return;
        }
        if (Config.isShaders() && source == 33352) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && mc.m_91268_() != null && mc.m_91268_().isClosed()) {
            return;
        }
        if (!GlErrors.isEnabled((int)id)) {
            return;
        }
        String sourceStr = GlDebug.m_84055_((int)source);
        String typeStr = GlDebug.m_84057_((int)type);
        String severityStr = GlDebug.m_84059_((int)severity);
        String messageStr = GLDebugMessageCallback.getMessage((int)messageLength, (long)message);
        messageStr = StrUtils.trim((String)messageStr, (String)" \n\r\t");
        String log = String.format("OpenGL %s %s: %s (%s)", sourceStr, typeStr, id, messageStr);
        Exception exc = new Exception("Stack trace");
        StackTraceElement[] stes = exc.getStackTrace();
        StackTraceElement[] stes2 = stes.length > 2 ? Arrays.copyOfRange(stes, 2, stes.length) : stes;
        exc.setStackTrace(stes2);
        if (type == 33356) {
            f_84028_.error(log, (Throwable)exc);
        } else {
            f_84028_.info(log, (Throwable)exc);
        }
        if (Config.isShowGlErrors() && TimedEvent.isActive((String)"ShowGlErrorDebug", (long)10000L) && mc.f_91073_ != null) {
            String errorText = Config.getGlErrorString((int)id);
            if (id == 0 || Config.equals((Object)errorText, (Object)"Unknown")) {
                errorText = messageStr;
            }
            String messageChat = I18n.m_118938_((String)"of.message.openglError", (Object[])new Object[]{id, errorText});
            mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)messageChat));
        }
        String s = GLDebugMessageCallback.getMessage((int)messageLength, (long)message);
        Queue queue = f_166221_;
        synchronized (queue) {
            LogEntry gldebug$logentry = f_166222_;
            if (gldebug$logentry != null && gldebug$logentry.m_166239_(source, type, id, severity, s)) {
                ++gldebug$logentry.f_166232_;
            } else {
                gldebug$logentry = new LogEntry(source, type, id, severity, s);
                f_166221_.add(gldebug$logentry);
                f_166222_ = gldebug$logentry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> m_166225_() {
        Queue queue = f_166221_;
        synchronized (queue) {
            ArrayList list = Lists.newArrayListWithCapacity((int)f_166221_.size());
            for (LogEntry gldebug$logentry : f_166221_) {
                list.add(gldebug$logentry + " x " + gldebug$logentry.f_166232_);
            }
            return list;
        }
    }

    public static boolean m_166226_() {
        return f_166223_;
    }

    public static void m_84049_(int debugVerbosity, boolean synchronous) {
        RenderSystem.assertInInitPhase();
        if (debugVerbosity > 0) {
            GLCapabilities glcapabilities = GL.getCapabilities();
            if (glcapabilities.GL_KHR_debug) {
                f_166223_ = true;
                GL11.glEnable((int)37600);
                if (synchronous) {
                    GL11.glEnable((int)33346);
                }
                for (int i2 = 0; i2 < f_84032_.size(); ++i2) {
                    boolean flag = i2 < debugVerbosity;
                    KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)((Integer)f_84032_.get(i2)), (int[])null, (boolean)flag);
                }
                KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.make((Object)GLDebugMessageCallback.create(GlDebug::m_84038_), DebugMemoryUntracker::m_84003_)), (long)0L);
            } else if (glcapabilities.GL_ARB_debug_output) {
                f_166223_ = true;
                if (synchronous) {
                    GL11.glEnable((int)33346);
                }
                for (int j2 = 0; j2 < f_84033_.size(); ++j2) {
                    boolean flag1 = j2 < debugVerbosity;
                    ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)((Integer)f_84033_.get(j2)), (int[])null, (boolean)flag1);
                }
                ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLX.make((Object)GLDebugMessageARBCallback.create(GlDebug::m_84038_), DebugMemoryUntracker::m_84003_)), (long)0L);
            }
        }
    }

    static {
        f_84032_ = ImmutableList.of((Object)37190, (Object)37191, (Object)37192, (Object)33387);
        f_84033_ = ImmutableList.of((Object)37190, (Object)37191, (Object)37192);
        ignoredErrors = GlDebug.makeIgnoredErrors();
    }
}

