/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.pipeline;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.nio.IntBuffer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.optifine.reflect.ReflectorForge;
import net.optifine.render.GLConst;
import org.joml.Matrix4f;

public abstract class RenderTarget {
    private static final int f_166194_ = 0;
    private static final int f_166195_ = 1;
    private static final int f_166196_ = 2;
    private static final int f_166197_ = 3;
    public int f_83915_;
    public int f_83916_;
    public int f_83917_;
    public int f_83918_;
    public final boolean f_83919_;
    public int f_83920_;
    protected int f_83923_;
    protected int f_83924_;
    private final float[] f_83921_ = (float[])Util.m_137537_(() -> new float[]{1.0f, 1.0f, 1.0f, 0.0f});
    public int f_83922_;
    private boolean stencilEnabled = false;

    public RenderTarget(boolean useDepthIn) {
        this.f_83919_ = useDepthIn;
        this.f_83920_ = -1;
        this.f_83923_ = -1;
        this.f_83924_ = -1;
    }

    public void m_83941_(int widthIn, int heightIn, boolean onMacIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.m_83964_(widthIn, heightIn, onMacIn));
        } else {
            this.m_83964_(widthIn, heightIn, onMacIn);
        }
    }

    private void m_83964_(int widthIn, int heightIn, boolean onMacIn) {
        if (!GLX.isUsingFBOs()) {
            this.f_83917_ = widthIn;
            this.f_83918_ = heightIn;
            return;
        }
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._enableDepthTest();
        if (this.f_83920_ >= 0) {
            this.m_83930_();
        }
        this.m_83950_(widthIn, heightIn, onMacIn);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    public void m_83930_() {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertOnRenderThreadOrInit();
        this.m_83963_();
        this.m_83970_();
        if (this.f_83924_ > -1) {
            TextureUtil.releaseTextureId((int)this.f_83924_);
            this.f_83924_ = -1;
        }
        if (this.f_83923_ > -1) {
            TextureUtil.releaseTextureId((int)this.f_83923_);
            this.f_83923_ = -1;
        }
        if (this.f_83920_ > -1) {
            GlStateManager._glBindFramebuffer((int)36160, (int)0);
            GlStateManager._glDeleteFramebuffers((int)this.f_83920_);
            this.f_83920_ = -1;
        }
    }

    public void m_83945_(RenderTarget framebufferIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBindFramebuffer((int)36008, (int)framebufferIn.f_83920_);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.f_83920_);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)framebufferIn.f_83915_, (int)framebufferIn.f_83916_, (int)0, (int)0, (int)this.f_83915_, (int)this.f_83916_, (int)256, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    public void m_83950_(int widthIn, int heightIn, boolean onMacIn) {
        RenderSystem.assertOnRenderThreadOrInit();
        int i2 = RenderSystem.maxSupportedTextureSize();
        if (widthIn > 0 && widthIn <= i2 && heightIn > 0 && heightIn <= i2) {
            this.f_83917_ = widthIn;
            this.f_83918_ = heightIn;
            this.f_83915_ = widthIn;
            this.f_83916_ = heightIn;
            if (!GLX.isUsingFBOs()) {
                this.m_83954_(onMacIn);
                return;
            }
            this.f_83920_ = GlStateManager.glGenFramebuffers();
            this.f_83923_ = TextureUtil.generateTextureId();
            if (this.f_83919_) {
                this.f_83924_ = TextureUtil.generateTextureId();
                GlStateManager._bindTexture((int)this.f_83924_);
                GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
                GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                GlStateManager._texParameter((int)3553, (int)34892, (int)0);
                GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
                GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
                if (this.stencilEnabled) {
                    GlStateManager._texImage2D((int)3553, (int)0, (int)36013, (int)this.f_83915_, (int)this.f_83916_, (int)0, (int)34041, (int)36269, null);
                } else {
                    GlStateManager._texImage2D((int)3553, (int)0, (int)6402, (int)this.f_83915_, (int)this.f_83916_, (int)0, (int)6402, (int)5126, (IntBuffer)null);
                }
            }
            this.m_83936_(9728);
            GlStateManager._bindTexture((int)this.f_83923_);
            GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
            GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
            GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.f_83915_, (int)this.f_83916_, (int)0, (int)6408, (int)5121, (IntBuffer)null);
            GlStateManager._glBindFramebuffer((int)36160, (int)this.f_83920_);
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.f_83923_, (int)0);
            if (this.f_83919_) {
                if (this.stencilEnabled) {
                    if (ReflectorForge.getForgeUseCombinedDepthStencilAttachment()) {
                        GlStateManager._glFramebufferTexture2D((int)GLConst.GL_FRAMEBUFFER, (int)33306, (int)3553, (int)this.f_83924_, (int)0);
                    } else {
                        GlStateManager._glFramebufferTexture2D((int)GLConst.GL_FRAMEBUFFER, (int)36096, (int)3553, (int)this.f_83924_, (int)0);
                        GlStateManager._glFramebufferTexture2D((int)GLConst.GL_FRAMEBUFFER, (int)36128, (int)3553, (int)this.f_83924_, (int)0);
                    }
                } else {
                    GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.f_83924_, (int)0);
                }
            }
        } else {
            throw new IllegalArgumentException("Window " + widthIn + "x" + heightIn + " size out of bounds (max. size: " + i2 + ")");
        }
        this.m_83949_();
        this.m_83954_(onMacIn);
        this.m_83963_();
    }

    public void m_83936_(int framebufferFilterIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertOnRenderThreadOrInit();
        this.f_83922_ = framebufferFilterIn;
        GlStateManager._bindTexture((int)this.f_83923_);
        GlStateManager._texParameter((int)3553, (int)10241, (int)framebufferFilterIn);
        GlStateManager._texParameter((int)3553, (int)10240, (int)framebufferFilterIn);
        GlStateManager._bindTexture((int)0);
    }

    public void m_83949_() {
        RenderSystem.assertOnRenderThreadOrInit();
        int i2 = GlStateManager.glCheckFramebufferStatus((int)36160);
        if (i2 != 36053) {
            if (i2 == 36054) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i2 == 36055) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i2 == 36059) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i2 == 36060) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            if (i2 == 36061) {
                throw new RuntimeException("GL_FRAMEBUFFER_UNSUPPORTED");
            }
            if (i2 == 1285) {
                throw new RuntimeException("GL_OUT_OF_MEMORY");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i2);
        }
    }

    public void m_83956_() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._bindTexture((int)this.f_83923_);
    }

    public void m_83963_() {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._bindTexture((int)0);
    }

    public void m_83947_(boolean setViewportIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.m_83961_(setViewportIn));
        } else {
            this.m_83961_(setViewportIn);
        }
    }

    private void m_83961_(boolean setViewportIn) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBindFramebuffer((int)36160, (int)this.f_83920_);
        if (setViewportIn) {
            GlStateManager._viewport((int)0, (int)0, (int)this.f_83917_, (int)this.f_83918_);
        }
    }

    public void m_83970_() {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> GlStateManager._glBindFramebuffer((int)36160, (int)0));
        } else {
            GlStateManager._glBindFramebuffer((int)36160, (int)0);
        }
    }

    public void m_83931_(float red, float green, float blue, float alpha) {
        this.f_83921_[0] = red;
        this.f_83921_[1] = green;
        this.f_83921_[2] = blue;
        this.f_83921_[3] = alpha;
    }

    public void m_83938_(int width, int height) {
        this.m_83957_(width, height, true);
    }

    public void m_83957_(int width, int height, boolean noBlend) {
        RenderSystem.assertOnGameThreadOrInit();
        if (!RenderSystem.isInInitPhase()) {
            RenderSystem.recordRenderCall(() -> this.m_83971_(width, height, noBlend));
        } else {
            this.m_83971_(width, height, noBlend);
        }
    }

    private void m_83971_(int width, int height, boolean noBlend) {
        if (!GLX.isUsingFBOs()) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._viewport((int)0, (int)0, (int)width, (int)height);
        if (noBlend) {
            GlStateManager._disableBlend();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ShaderInstance shaderinstance = minecraft.f_91063_.f_172635_;
        shaderinstance.m_173350_("DiffuseSampler", (Object)this.f_83923_);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        if (shaderinstance.f_173308_ != null) {
            shaderinstance.f_173308_.m_5679_(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        }
        if (shaderinstance.f_173309_ != null) {
            shaderinstance.f_173309_.m_5679_(matrix4f);
        }
        shaderinstance.m_173363_();
        float f2 = width;
        float f1 = height;
        float f22 = (float)this.f_83917_ / (float)this.f_83915_;
        float f3 = (float)this.f_83918_ / (float)this.f_83916_;
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)f1, 0.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferbuilder.m_5483_((double)f2, (double)f1, 0.0).m_7421_(f22, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferbuilder.m_5483_((double)f2, 0.0, 0.0).m_7421_(f22, f3).m_6122_(255, 255, 255, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, f3).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        shaderinstance.m_173362_();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public void m_83954_(boolean onMac) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.m_83947_(true);
        GlStateManager._clearColor((float)this.f_83921_[0], (float)this.f_83921_[1], (float)this.f_83921_[2], (float)this.f_83921_[3]);
        int i2 = 16384;
        if (this.f_83919_) {
            GlStateManager._clearDepth((double)1.0);
            i2 |= 0x100;
        }
        GlStateManager._clear((int)i2, (boolean)onMac);
        this.m_83970_();
    }

    public int m_83975_() {
        return this.f_83923_;
    }

    public int m_83980_() {
        return this.f_83924_;
    }

    public void enableStencil() {
        if (this.stencilEnabled) {
            return;
        }
        this.stencilEnabled = true;
        this.m_83941_(this.f_83917_, this.f_83918_, Minecraft.f_91002_);
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }
}

