/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world.gen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraftforge.common.Tags;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;

public class FeatureVegetation
extends Feature<ProbabilityFeatureConfiguration> {
    public FeatureVegetation(Codec<ProbabilityFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ProbabilityFeatureConfiguration> context) {
        RandomSource rand = context.m_159774_().m_213780_();
        WorldGenLevel world = context.m_159774_();
        BlockPos genPos = world.m_5452_(Heightmap.Types.OCEAN_FLOOR, context.m_159777_());
        if (((List)ConfigFeatureControl.dimensionFeatureBlacklist.get()).contains(world.m_6018_().m_46472_().m_135782_().toString())) {
            return false;
        }
        boolean flag = false;
        int x = 8;
        int z = 8;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)genPos).m_122184_(x, 0, z);
        Pair<Block, Integer> flora = FloraTypes.getFloraForPos(world, genPos);
        if (flora != null) {
            Block block = (Block)flora.getFirst();
            int size = (Integer)flora.getSecond();
            for (int i = 0; i < size; ++i) {
                blockpos$mutableblockpos.m_122184_(rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(2) - rand.m_188503_(2), rand.m_188503_(4) - rand.m_188503_(4));
                if (!world.m_8055_(blockpos$mutableblockpos.m_7495_()).m_204336_(ModTags.ModBlockTags.ALOE_PLANTABLE_ON) || world.m_8055_((BlockPos)blockpos$mutableblockpos).m_60783_((BlockGetter)world, (BlockPos)blockpos$mutableblockpos, Direction.UP) || !world.m_6425_((BlockPos)blockpos$mutableblockpos).m_76178_() || block == null) continue;
                world.m_7731_((BlockPos)blockpos$mutableblockpos, block.m_49966_(), 2);
                world.m_46865_((BlockPos)blockpos$mutableblockpos).m_8113_(blockpos$mutableblockpos.m_7495_());
                if (block instanceof IPostGenUpdate) {
                    ((IPostGenUpdate)block).updatePostGen((LevelAccessor)world, (BlockPos)blockpos$mutableblockpos);
                }
                flag = true;
            }
        }
        return flag;
    }

    public static enum FloraTypes {
        TEMPERATE_BUSH((Block)ModBlock.BUSH_TEMPERATE.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 24, new TagKey[]{BiomeTags.f_207611_, Tags.Biomes.IS_SWAMP, BiomeTags.f_207606_, BiomeTags.f_207609_, Tags.Biomes.IS_PLAINS}),
        CREOSOTE_BUSH((Block)ModBlock.BUSH_CREOSOTE.get(), 2, (Boolean)ConfigFeatureControl.addFlora.get(), false, 4, new TagKey[]{BiomeTags.f_207607_, Tags.Biomes.IS_DESERT}),
        ELEPHANT_EAR((Block)ModBlock.ELEPHANT_EAR.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 24, new TagKey[]{BiomeTags.f_207610_}),
        HEMLOCK((Block)ModBlock.HEMLOCK.get(), 1, (Boolean)ConfigFeatureControl.addFlora.get(), false, 12, new TagKey[]{BiomeTags.f_207611_}),
        TITAN_ARUM((Block)ModBlock.TITAN_ARUM.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 1, new TagKey[]{BiomeTags.f_207610_}),
        ZIMBABWE_ALOE((Block)ModBlock.ZIMBABWE_ALOE.get(), 4, (Boolean)ConfigFeatureControl.addFlora.get(), false, 1, new TagKey[]{BiomeTags.f_207607_}),
        FLOWER_YARROW((Block)ModBlock.YARROW.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 18, new TagKey[]{BiomeTags.f_207611_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207606_}),
        GRASS_JUNEGRASS((Block)ModBlock.JUNEGRASS.get(), 8, (Boolean)ConfigFeatureControl.addFlora.get(), false, 18, new TagKey[]{Tags.Biomes.IS_PLAINS}),
        CANOLA((Block)ModBlock.CANOLA.get(), 6, (Boolean)ConfigFeatureControl.addFlora.get(), false, 12, new TagKey[]{Tags.Biomes.IS_PLAINS});

        public Block type;
        public int rarity;
        public boolean enabled;
        public boolean spawnsInWater;
        public int size;
        public TagKey<Biome>[] spawnBiomes;

        private FloraTypes(Block type, int rolls, boolean add, boolean spawnsInWater, int size, TagKey<Biome>[] biomes) {
            this.type = type;
            this.rarity = rolls;
            this.enabled = add;
            this.spawnsInWater = spawnsInWater;
            this.spawnBiomes = biomes;
            this.size = size;
        }

        public static Pair<Block, Integer> getFloraForPos(WorldGenLevel world, BlockPos pos) {
            Holder biome = world.m_204166_(pos);
            ArrayList<FloraTypes> types = new ArrayList<FloraTypes>();
            for (FloraTypes type : FloraTypes.values()) {
                if (!type.enabled || !type.spawnsInWater && world.m_8055_(pos).m_60734_() == Blocks.f_49990_) continue;
                for (TagKey<Biome> biomeTypes : type.spawnBiomes) {
                    if (!biome.m_203656_(biomeTypes)) continue;
                    for (int i = 0; i < type.rarity; ++i) {
                        types.add(type);
                    }
                }
            }
            if (!types.isEmpty()) {
                int i = new Random().nextInt(types.size());
                return new Pair((Object)((FloraTypes)((Object)types.get((int)i))).type, (Object)((FloraTypes)((Object)types.get((int)i))).size);
            }
            return null;
        }
    }
}

