/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.UntamedWilds;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.EntityUtils;

public class FaunaSpawn {
    private static boolean canCreatureTypeSpawnAtLocation(SpawnPlacements.Type placeType, LevelReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        if (placeType == SpawnPlacements.Type.NO_RESTRICTIONS) {
            if (((Boolean)ConfigGamerules.preventMobsOnWater.get()).booleanValue()) {
                BlockPos pos2 = worldIn.m_5452_(Heightmap.Types.OCEAN_FLOOR, pos);
                return worldIn.m_6425_(pos2).m_76178_();
            }
            return true;
        }
        if (entityTypeIn != null && worldIn.m_6857_().m_61937_(pos)) {
            return FaunaSpawn.canSpawnAtBody(placeType, worldIn, pos, entityTypeIn);
        }
        return false;
    }

    private static boolean canSpawnAtBody(SpawnPlacements.Type placeType, LevelReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        BlockState blockstate = worldIn.m_8055_(pos);
        FluidState fluidstate = worldIn.m_6425_(pos);
        BlockPos pos_below = pos.m_7495_();
        switch (placeType) {
            case IN_WATER: {
                return fluidstate.m_205070_(FluidTags.f_13131_);
            }
            case IN_LAVA: {
                return fluidstate.m_205070_(FluidTags.f_13132_);
            }
        }
        BlockState blockstate1 = worldIn.m_8055_(pos_below);
        if (!blockstate1.isValidSpawn(worldIn, pos_below, placeType, entityTypeIn)) {
            return false;
        }
        return FaunaSpawn.isSpawnableSpace(worldIn, pos, blockstate, fluidstate, entityTypeIn);
    }

    private static boolean isSpawnableSpace(LevelReader worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn, EntityType<?> entityTypeIn) {
        if (state.m_60838_((BlockGetter)worldIn, pos) || state.m_60803_() || !fluidStateIn.m_76178_() || state.m_204336_(BlockTags.f_13054_)) {
            return false;
        }
        return !entityTypeIn.m_20630_(state);
    }

    public static boolean performWorldGenSpawning(EntityType<?> entityType, SpawnPlacements.Type spawnType, @Nullable Heightmap.Types heightMap, ServerLevelAccessor worldIn, BlockPos pos, RandomSource random, int groupSize) {
        if (((List)ConfigMobControl.dimensionBlacklist.get()).contains(worldIn.m_6018_().m_46472_().m_135782_().toString())) {
            return false;
        }
        if (entityType != null && !worldIn.m_5776_()) {
            int i = pos.m_123341_() + random.m_188503_(16);
            int j = pos.m_123343_() + random.m_188503_(16);
            if (heightMap != null) {
                pos.m_7918_(i, 0, j);
                pos = worldIn.m_5452_(heightMap, pos);
            }
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            int k = 1;
            int species = -1;
            block2: for (int packSize = 0; packSize < k; ++packSize) {
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                if (packSize != 0) {
                    x += random.m_188503_(6);
                    z += random.m_188503_(6);
                }
                for (int attempt = 0; attempt < 4; ++attempt) {
                    Mob mobEntity;
                    Entity entity;
                    double d1;
                    if (attempt != 0) {
                        if (attempt == 1) {
                            y += ((Integer)ConfigMobControl.treeSpawnBias.get()).intValue();
                        }
                        x += random.m_188503_(2);
                        z += random.m_188503_(2);
                    }
                    blockPos.m_122178_(x, y, z);
                    if (!entityType.m_20654_() || !FaunaSpawn.canCreatureTypeSpawnAtLocation(spawnType, (LevelReader)worldIn, (BlockPos)blockPos, entityType)) continue;
                    float f = entityType.m_20678_();
                    double d0 = Mth.m_14008_((double)x, (double)((double)blockPos.m_123341_() + (double)f), (double)((double)blockPos.m_123341_() + 16.0 - (double)f));
                    if (!worldIn.m_45772_(entityType.m_20585_(d0, (double)y, d1 = Mth.m_14008_((double)z, (double)((double)blockPos.m_123343_() + (double)f), (double)((double)blockPos.m_123343_() + 16.0 - (double)f)))) || !SpawnPlacements.m_217074_(entityType, (ServerLevelAccessor)worldIn, (MobSpawnType)MobSpawnType.CHUNK_GENERATION, (BlockPos)blockPos, (RandomSource)worldIn.m_213780_())) continue;
                    try {
                        entity = entityType.m_20615_((Level)worldIn.m_6018_());
                    }
                    catch (Exception exception) {
                        UntamedWilds.LOGGER.warn("Failed to create mob", (Throwable)exception);
                        continue;
                    }
                    assert (entity != null);
                    entity.m_7678_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), random.m_188501_() * 360.0f, 0.0f);
                    if (!(entity instanceof Mob) || !(mobEntity = (Mob)entity).m_5545_((LevelAccessor)worldIn, MobSpawnType.CHUNK_GENERATION) || !worldIn.m_45786_(entity)) continue;
                    if (mobEntity instanceof ComplexMob && mobEntity.m_6084_()) {
                        if (mobEntity instanceof ISpecies) {
                            if (species == -1) {
                                Holder optional = worldIn.m_204166_((BlockPos)blockPos);
                                species = ((ISpecies)mobEntity).setSpeciesByBiome((Holder<Biome>)optional, MobSpawnType.CHUNK_GENERATION);
                            }
                            ((ComplexMob)mobEntity).setVariant(species);
                        }
                        if (species == 99 || !ComplexMob.ENTITY_DATA_HASH.containsKey(entityType)) {
                            mobEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                            return false;
                        }
                    }
                    k = EntityUtils.getPackSize(entityType, species);
                    ForgeEventFactory.onFinalizeSpawn((Mob)mobEntity, (ServerLevelAccessor)worldIn, (DifficultyInstance)worldIn.m_6436_(mobEntity.m_20183_()), (MobSpawnType)MobSpawnType.DISPENSER, null, null);
                    worldIn.m_47205_((Entity)mobEntity);
                    continue block2;
                }
            }
            return true;
        }
        return false;
    }
}

