/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.amphibian;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.INestingMob;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.AmphibiousTransition;
import untamedwilds.entity.ai.LayEggsOnNestGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.control.look.SmartSwimmerLookControl;
import untamedwilds.entity.ai.control.movement.SmartSwimmingMoveControl;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class EntityNewt
extends ComplexMobAmphibious
implements ISpecies,
INewSkins,
INestingMob {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(EntityNewt.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int swimProgress;
    public float offset;

    public EntityNewt(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SmartSwimmingMoveControl((Mob)this, 40, 5, 0.25f, 0.3f, true);
        this.f_21365_ = new SmartSwimmerLookControl(this, 20);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.7).m_22268_(Attributes.f_22277_, 8.0).m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 0.7));
        this.f_21345_.m_25352_(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, (float)this.m_21133_(Attributes.f_22277_), 1.0, 1.3, input -> EntityNewt.getEcoLevel(input) > EntityNewt.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new AmphibiousTransition(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LayEggsOnNestGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public float m_5610_(BlockPos p_149140_, LevelReader p_149141_) {
        return 0.0f;
    }

    private boolean isAquatic() {
        return EntityNewt.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "isAquatic") == 1;
    }

    @Override
    public boolean wantsToBeOnLand() {
        return !this.isAquatic();
    }

    @Override
    public boolean wantsToBeInWater() {
        return this.isAquatic();
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.003, 0.0));
            }
            if (this.m_9236_().m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
        } else {
            if ((double)Math.abs(this.m_146908_() - this.f_19859_) > 0.005) {
                this.offset = Mth.m_14189_((float)0.05f, (float)this.offset, (float)(this.m_146908_() - this.f_19859_));
            }
            if (this.m_20069_() && !this.m_20096_() && this.swimProgress < 20) {
                ++this.swimProgress;
            } else if ((!this.m_20069_() || this.m_20096_()) && this.swimProgress > 0) {
                --this.swimProgress;
            }
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.m_9236_().m_45976_(EntityNewt.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            return list.size() >= 1;
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_newt", this.getOffspring());
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && itemstack.m_41720_().equals(Items.f_42447_) && this.m_6084_()) {
            EntityUtils.mutateEntityIntoItem((LivingEntity)this, player, hand, "bucket_newt", itemstack);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        SoundEvent soundevent = SoundEvents.f_12488_;
        this.m_5496_(soundevent, 0.15f, 1.0f);
    }

    @Override
    public float getModelScale() {
        return 0.8f;
    }

    @Override
    public boolean wantsToLayEggs() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setEggStatus(boolean status) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)status);
    }

    @Override
    public Block getNestType() {
        return (Block)ModBlock.NEST_AMPHIBIAN.get();
    }

    @Override
    public boolean isValidNestBlock(BlockPos pos) {
        return this.m_9236_().m_46801_(pos) && this.m_9236_().m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.VALID_REPTILE_NEST) && this.getNestType().m_49966_().m_60710_((LevelReader)this.m_9236_(), pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("has_egg", this.wantsToLayEggs());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEggStatus(compound.m_128471_("has_egg"));
    }
}

