/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.AABB;
import untamedwilds.entity.ComplexMob;

public class GuardPositionTarget<T extends LivingEntity>
extends TargetGoal {
    protected BlockPos guardPos;
    protected final Class<T> targetClass;
    protected final Sorter sorter;
    protected Predicate<? super T> targetEntitySelector;
    protected int tryTicks;
    private int maxStayTicks;
    private boolean reachedTarget;

    public GuardPositionTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, Predicate<LivingEntity> targetSelector) {
        super((Mob)creature, checkSight, true);
        this.targetClass = classTarget;
        this.sorter = new Sorter((Entity)creature);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.JUMP));
        this.targetEntitySelector = entity -> this.isValidTarget((LivingEntity)entity, targetSelector);
    }

    protected boolean isValidTarget(LivingEntity entity, @Nullable Predicate<LivingEntity> predicate) {
        TamableAnimal tamable;
        if (entity instanceof Creeper || entity.equals((Object)this.f_26135_) || predicate != null && !predicate.test(entity)) {
            return false;
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_()) {
            Mob mob = this.f_26135_;
            if (mob instanceof TamableAnimal) {
                TamableAnimal tamed = (TamableAnimal)mob;
                if (tamable.m_269323_() != null && tamable.m_269323_().equals((Object)tamed.m_269323_())) {
                    return false;
                }
            }
            if (this.f_26135_.m_5647_() != null && this.f_26135_.m_5647_().m_83536_(tamable.m_5647_())) {
                return false;
            }
        }
        return this.m_26150_(entity, TargetingConditions.m_148352_().m_26883_(this.m_7623_()));
    }

    public boolean m_8036_() {
        List list;
        if (this.f_26135_.m_6162_() || this.f_26135_.m_21223_() < this.f_26135_.m_21233_() / 3.0f) {
            return false;
        }
        Mob mob = this.f_26135_;
        if (mob instanceof ComplexMob) {
            ComplexMob cmob = (ComplexMob)mob;
            if (!cmob.m_21824_() || cmob.getCommandInt() != 3) {
                return false;
            }
            if (!cmob.isSitting()) {
                cmob.setSitting(true);
            }
        }
        if (this.guardPos == null) {
            this.guardPos = this.f_26135_.m_20183_();
        }
        if (!(list = this.f_26135_.m_9236_().m_6443_(this.targetClass, this.getTargettableArea(this.m_7623_()), this.targetEntitySelector)).isEmpty()) {
            list.sort(this.sorter);
            this.f_26137_ = (LivingEntity)list.get(0);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!super.m_8045_()) {
            if (this.reachedTarget) {
                Mob mob = this.f_26135_;
                if (mob instanceof ComplexMob) {
                    ComplexMob cmob = (ComplexMob)mob;
                    cmob.m_21573_().m_26573_();
                    cmob.setSitting(true);
                }
                return false;
            }
            return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200;
        }
        return true;
    }

    AABB getTargettableArea(double targetDistance) {
        return this.f_26135_.m_20191_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    public void m_8056_() {
        if (!this.f_26135_.m_21573_().m_26571_()) {
            this.f_26135_.m_21573_().m_26573_();
        }
        this.f_26135_.m_6710_(this.f_26137_);
        this.tryTicks = 0;
        this.maxStayTicks = this.f_26135_.m_217043_().m_188503_(this.f_26135_.m_217043_().m_188503_(1200) + 1200) + 1200;
        this.reachedTarget = false;
        super.m_8056_();
    }

    public double acceptedDistance() {
        return 2.0;
    }

    public boolean m_183429_() {
        return true;
    }

    private boolean reaquireTarget() {
        List list = this.f_26135_.m_9236_().m_6443_(this.targetClass, this.getTargettableArea(this.m_7623_()), this.targetEntitySelector);
        if (!list.isEmpty()) {
            list.sort(this.sorter);
            this.f_26137_ = (LivingEntity)list.get(0);
            return true;
        }
        return false;
    }

    public void m_8037_() {
        if (this.f_26135_.m_5448_() == null || this.f_26135_.m_5448_().m_21224_()) {
            if (!this.reaquireTarget()) {
                BlockPos blockpos = this.guardPos.m_7494_();
                ((ServerLevel)this.f_26135_.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123768_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.0);
                if (!blockpos.m_203195_((Position)this.f_26135_.m_20182_(), this.acceptedDistance())) {
                    ++this.tryTicks;
                    if (this.shouldRecalculatePath()) {
                        this.f_26135_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, 1.0);
                    }
                } else {
                    this.reachedTarget = true;
                    --this.tryTicks;
                }
            }
        } else {
            super.m_8037_();
        }
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        private Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.m_20280_(entity_1);
            if (dist_1 < (dist_2 = this.entity.m_20280_(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

