/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.mammal.EntityBison;
import untamedwilds.entity.mammal.EntityRhino;
import untamedwilds.util.EntityUtils;

public class MeleeAttackCharger
extends Goal {
    private final int executionChance;
    private final float speed;
    private final ComplexMobTerrestrial taskOwner;
    private double chargeX;
    private double chargeY;
    private double chargeZ;
    private int charge;

    public MeleeAttackCharger(ComplexMobTerrestrial entityIn, float speedIn, int chance) {
        this.taskOwner = entityIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.charge = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity chargeTarget = this.taskOwner.m_5448_();
        if (this.taskOwner.m_6162_() || chargeTarget == null || !this.taskOwner.m_20096_() || this.taskOwner.m_217043_().m_188503_(this.executionChance) != 0) {
            return false;
        }
        double distance = this.taskOwner.m_20270_((Entity)chargeTarget);
        if (distance < 2.0 || distance > 24.0 || !this.taskOwner.m_20096_()) {
            return false;
        }
        Vec3 chargePos = EntityUtils.getOvershootPath((Entity)this.taskOwner, (Entity)chargeTarget, 10.0);
        boolean canSeeTargetFromDest = this.taskOwner.m_21574_().m_148306_((Entity)chargeTarget);
        if (canSeeTargetFromDest) {
            this.chargeX = chargePos.f_82479_;
            this.chargeY = chargePos.f_82480_;
            this.chargeZ = chargePos.f_82481_;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.charge = 50;
        if (this.taskOwner instanceof EntityBison) {
            this.taskOwner.setAnimation(EntityBison.ATTACK_THREATEN);
        }
        if (this.taskOwner instanceof EntityRhino) {
            this.taskOwner.setAnimation(EntityRhino.ATTACK_THREATEN);
        }
    }

    public boolean m_8045_() {
        return this.charge > 0 || !this.taskOwner.m_21573_().m_26571_();
    }

    public void m_8037_() {
        this.taskOwner.m_21563_().m_24946_(this.chargeX, this.chargeY - 1.0, this.chargeZ);
        if (this.charge > 0) {
            if (--this.charge == 0) {
                this.taskOwner.m_21573_().m_26519_(this.chargeX, this.chargeY, this.chargeZ, (double)(this.speed * 1.2f));
            } else {
                this.taskOwner.m_6858_(true);
            }
        } else {
            AABB offset_box = this.taskOwner.m_20191_().m_82386_(Math.cos(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2);
            List entitiesHit = this.taskOwner.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.taskOwner, offset_box);
            for (LivingEntity entityHit : entitiesHit) {
                if (entityHit instanceof EntityRhino || entityHit.equals((Object)this.taskOwner) || !this.taskOwner.m_142582_((Entity)entityHit)) continue;
                this.taskOwner.m_7327_((Entity)entityHit);
            }
        }
    }

    public void m_8041_() {
        this.charge = 0;
        this.taskOwner.m_6858_(false);
    }
}

