/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.biome.Biome;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.util.SpeciesDataHolder;

public interface ISpecies {
    default public int setSpeciesByBiome(Holder<Biome> biome, MobSpawnType reason) {
        if (((Boolean)ConfigGamerules.randomSpecies.get()).booleanValue() || ISpecies.isArtificialMobSpawnType(reason)) {
            return ((Mob)this).m_217043_().m_188503_(ComplexMob.getEntityData(((Mob)this).m_6095_()).getSpeciesData().size());
        }
        ArrayList<Integer> validTypes = new ArrayList<Integer>();
        for (SpeciesDataHolder speciesDatum : ComplexMob.getEntityData(((Mob)this).m_6095_()).getSpeciesData()) {
            for (List<SpeciesDataHolder.BiomeTestHolder> testList : speciesDatum.getBiomeCategories()) {
                ArrayList<Boolean> results = new ArrayList<Boolean>();
                for (SpeciesDataHolder.BiomeTestHolder test : testList) {
                    if (!test.isValidBiome(biome, (Biome)biome.m_203334_())) break;
                    results.add(true);
                }
                if (results.size() != testList.size()) continue;
                for (int i = 0; i < speciesDatum.getRarity(); ++i) {
                    validTypes.add(speciesDatum.getVariant());
                }
            }
        }
        if (validTypes.isEmpty()) {
            return 99;
        }
        return (Integer)validTypes.get(new Random().nextInt(validTypes.size()));
    }

    default public String getRawSpeciesName(int i) {
        return ComplexMob.getEntityData(((ComplexMob)((Object)this)).m_6095_()).getSpeciesData().get(i).getName().toLowerCase();
    }

    default public String getSpeciesName(int i) {
        return Component.m_237115_((String)("entity.untamedwilds." + ((ComplexMob)((Object)this)).m_6095_().m_204041_().m_205785_().m_135782_().m_135815_() + "_" + this.getRawSpeciesName(i))).getString();
    }

    default public String getSpeciesName() {
        return this instanceof ComplexMob ? this.getSpeciesName(((ComplexMob)((Object)this)).getVariant()) : "";
    }

    public static boolean isArtificialMobSpawnType(MobSpawnType reason) {
        return reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.BUCKET || reason == MobSpawnType.MOB_SUMMONED || reason == MobSpawnType.COMMAND || reason == MobSpawnType.SPAWNER || reason == MobSpawnType.DISPENSER || reason == MobSpawnType.BREEDING;
    }
}

