/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EggBlockEntity
extends BlockEntity {
    private EntityType<?> entityType = (EntityType)ModEntity.SPITTER.get();
    private int variant = 0;
    private boolean canSpawn = true;

    public EggBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlock.TILE_ENTITY_EGG.get(), pos, state);
    }

    public void releaseOrCreateMob(ServerLevel worldIn) {
        Entity spawn;
        BlockPos blockpos;
        if (this.getCanSpawn() && this.getEntityType() != null && this.getVariant() >= 0 && (double)worldIn.m_213780_().m_188501_() < 0.1 && worldIn.m_45914_((double)(blockpos = this.m_58899_()).m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, (double)((Integer)ConfigMobControl.critterSpawnRange.get()).intValue()) && this.getEntityType() != null && (spawn = this.getEntityType().m_20615_((Level)worldIn)) != null) {
            spawn.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, Mth.m_14177_((float)(worldIn.f_46441_.m_188501_() * 360.0f)), 0.0f);
            if (spawn instanceof Mob) {
                Mob mobSpawn = (Mob)spawn;
                ForgeEventFactory.onFinalizeSpawn((Mob)mobSpawn, (ServerLevelAccessor)worldIn, (DifficultyInstance)worldIn.m_6436_(blockpos), (MobSpawnType)MobSpawnType.BREEDING, null, null);
            }
            if (spawn instanceof ComplexMob) {
                ComplexMob entitySpawn = (ComplexMob)spawn;
                entitySpawn.setVariant(EntityUtils.getClampedNumberOfSpecies(this.variant, this.entityType));
                entitySpawn.m_146762_(ComplexMob.getEntityData(this.entityType).getGrowingTime(this.variant) * (Integer)ConfigGamerules.cycleLength.get() * -2);
                entitySpawn.m_6863_(true);
                entitySpawn.setGender(worldIn.m_213780_().m_188503_(2));
                entitySpawn.setRandomMobSize();
                entitySpawn.chooseSkinForSpecies(entitySpawn, true);
                if (entitySpawn instanceof INeedsPostUpdate) {
                    ((INeedsPostUpdate)((Object)entitySpawn)).updateAttributes();
                }
            }
            this.spawnParticles((Level)worldIn, spawn.m_20185_(), spawn.m_20186_(), spawn.m_20189_(), new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50578_.m_49966_()));
            worldIn.m_46961_(this.m_58899_(), false);
            worldIn.m_47205_(spawn);
            this.setCanSpawn(false);
            this.m_6596_();
        }
    }

    public void setCanSpawn(boolean canSpawn) {
        this.canSpawn = canSpawn;
    }

    public boolean getCanSpawn() {
        return this.canSpawn;
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    public int getVariant() {
        return this.variant;
    }

    public void setEntityType(EntityType<?> type) {
        this.entityType = type;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    private <T extends ParticleOptions> void spawnParticles(Level worldIn, double x, double y, double z, T particle) {
        RandomSource random = worldIn.m_213780_();
        float d3 = random.m_188501_() * 0.02f;
        float d1 = random.m_188501_() * 0.02f;
        float d2 = random.m_188501_() * 0.02f;
        ((ServerLevel)worldIn).m_8767_(particle, x, y, z, 15, (double)d3, (double)d1, (double)d2, (double)0.12f);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setCanSpawn(compound.m_128471_("CanSpawn"));
        if (compound.m_128441_("entityType")) {
            this.setEntityType(EntityType.m_20632_((String)compound.m_128461_("entityType")).orElse(null));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("CanSpawn", this.getCanSpawn());
        compound.m_128405_("Variant", this.getVariant());
        if (this.getEntityType() != null) {
            compound.m_128359_("entityType", EntityUtils.getRegistryName(this.getEntityType()));
        }
    }
}

