/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.processors.BoxCuttingProcessor;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;

public final class BossRoom
extends TwilightTemplateStructurePiece {
    static final int SIDE_LENGTH = 44;
    static final int HEIGHT = 46;

    public BossRoom(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.TOWER_BOSS_ROOM.get(), compoundTag, ctx, BossRoom.readSettings(compoundTag).m_74383_((StructureProcessor)BoxCuttingProcessor.fromNBT(compoundTag.m_128437_("cutouts", 10))));
    }

    public BossRoom(StructureTemplateManager structureManager, Rotation rotation, BoxCuttingProcessor sideTowerStarts, BlockPos startPosition) {
        this(structureManager, TwilightForestMod.prefix("lich_tower/boss_room"), BossRoom.makeSettings(rotation).m_74383_((StructureProcessor)sideTowerStarts), startPosition);
    }

    private BossRoom(StructureTemplateManager structureManager, ResourceLocation templateLocation, StructurePlaceSettings placeSettings, BlockPos startPosition) {
        super((StructurePieceType)TFStructurePieceTypes.TOWER_BOSS_ROOM.get(), 0, structureManager, templateLocation, placeSettings, startPosition);
    }

    protected void m_213704_(String label, BlockPos pos, ServerLevelAccessor levelAccessor, RandomSource random, BoundingBox boundingBox) {
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.m_183620_(ctx, structureTag);
        BoxCuttingProcessor cuttingProcessor = null;
        for (StructureProcessor processor : this.f_73657_.m_74411_()) {
            BoxCuttingProcessor first;
            if (!(processor instanceof BoxCuttingProcessor)) continue;
            cuttingProcessor = first = (BoxCuttingProcessor)processor;
            break;
        }
        if (cuttingProcessor == null) {
            return;
        }
        ArrayList<BoundingBox> filtering = new ArrayList<BoundingBox>(cuttingProcessor.cutouts);
        filtering.removeIf(bb -> bb.m_162399_() < this.f_73658_.m_123342_() || bb.m_162396_() > this.f_73658_.m_123342_() + 46);
        ListTag boxTagList = new ListTag();
        for (BoundingBox box : filtering) {
            boxTagList.add((Object)BoundingBoxUtils.boundingBoxToNBT(box));
        }
        structureTag.m_128365_("cutouts", (Tag)boxTagList);
    }
}

