/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFMenuTypes;
import twilightforest.init.TFRecipes;
import twilightforest.inventory.UncraftingContainer;
import twilightforest.inventory.UncraftingInputContainer;
import twilightforest.inventory.slot.AssemblySlot;
import twilightforest.inventory.slot.UncraftingResultSlot;
import twilightforest.inventory.slot.UncraftingSlot;
import twilightforest.item.recipe.UncraftingRecipe;
import twilightforest.util.TFItemStackUtils;

public class UncraftingMenu
extends AbstractContainerMenu {
    private static final String TAG_MARKER = "TwilightForestMarker";
    private final UncraftingContainer uncraftingMatrix = new UncraftingContainer(this);
    public final CraftingContainer assemblyMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final CraftingContainer combineMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    public final Container tinkerInput = new UncraftingInputContainer(this);
    private final ResultContainer tinkerResult = new ResultContainer();
    private final ContainerLevelAccess positionData;
    private final Level level;
    private final Player player;
    public int unrecipeInCycle = 0;
    public int ingredientsInCycle = 0;
    public int recipeInCycle = 0;
    @Nullable
    public Recipe<?> storedGhostRecipe = null;

    public static UncraftingMenu fromNetwork(int id, Inventory inventory) {
        return new UncraftingMenu(id, inventory, inventory.f_35978_.m_9236_(), ContainerLevelAccess.f_39287_);
    }

    public UncraftingMenu(int id, Inventory inventory, Level level, ContainerLevelAccess positionData) {
        super((MenuType)TFMenuTypes.UNCRAFTING.get(), id);
        int invY;
        int invX;
        this.positionData = positionData;
        this.level = level;
        this.player = inventory.f_35978_;
        this.m_38897_(new Slot(this.tinkerInput, 0, 13, 35));
        this.m_38897_((Slot)new UncraftingResultSlot(inventory.f_35978_, this.tinkerInput, this.uncraftingMatrix, (Container)this.assemblyMatrix, (Container)this.tinkerResult, 0, 147, 35));
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.m_38897_(new UncraftingSlot(inventory.f_35978_, this.tinkerInput, this.uncraftingMatrix, (Container)this.assemblyMatrix, invY + invX * 3, 300000 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.m_38897_(new AssemblySlot((Container)this.assemblyMatrix, invY + invX * 3, 62 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 9; ++invY) {
                this.m_38897_(new Slot((Container)inventory, invY + invX * 9 + 9, 8 + invY * 18, 84 + invX * 18));
            }
        }
        for (invX = 0; invX < 9; ++invX) {
            this.m_38897_(new Slot((Container)inventory, invX, 8 + invX * 18, 142));
        }
        this.m_6199_((Container)this.assemblyMatrix);
    }

    public void m_6199_(Container inventory) {
        if (inventory == this.tinkerInput) {
            this.uncraftingMatrix.m_6211_();
            ItemStack inputStack = this.tinkerInput.m_8020_(0);
            Recipe<?>[] recipes = UncraftingMenu.getRecipesFor(inputStack, this.level);
            int size = recipes.length;
            if (size > 0 && !inputStack.m_204117_(ItemTagGenerator.BANNED_UNCRAFTABLES)) {
                int n;
                int i;
                Recipe<?> recipe = recipes[Math.floorMod(this.unrecipeInCycle, size)];
                this.storedGhostRecipe = recipe;
                ItemStack[] recipeItems = this.getIngredients(recipe);
                if (recipe instanceof IShapedRecipe) {
                    IShapedRecipe rec = (IShapedRecipe)recipe;
                    int recipeWidth = rec.getRecipeWidth();
                    int recipeHeight = rec.getRecipeHeight();
                    for (int invY = 0; invY < recipeHeight; ++invY) {
                        for (int invX = 0; invX < recipeWidth; ++invX) {
                            int index = invX + invY * recipeWidth;
                            if (index >= recipeItems.length) continue;
                            ItemStack ingredient = UncraftingMenu.normalizeIngredient(recipeItems[index].m_41777_());
                            this.uncraftingMatrix.m_6836_(invX + invY * 3, ingredient);
                        }
                    }
                } else {
                    for (i = 0; i < this.uncraftingMatrix.m_6643_(); ++i) {
                        if (i >= recipeItems.length) continue;
                        ItemStack ingredient = UncraftingMenu.normalizeIngredient(recipeItems[i].m_41777_());
                        this.uncraftingMatrix.m_6836_(i, ingredient);
                    }
                }
                if (inputStack.m_41768_()) {
                    int damagedParts = this.countDamagedParts(inputStack);
                    for (i = 0; i < 9 && damagedParts > 0; ++i) {
                        ItemStack stack = this.uncraftingMatrix.m_8020_(i);
                        if (!UncraftingMenu.isDamageableComponent(stack)) continue;
                        UncraftingMenu.markStack(stack);
                        --damagedParts;
                    }
                }
                for (int i2 = 0; i2 < 9; ++i2) {
                    ItemStack ingredient = this.uncraftingMatrix.m_8020_(i2);
                    if (!UncraftingMenu.isIngredientProblematic(ingredient)) continue;
                    UncraftingMenu.markStack(ingredient);
                }
                if (recipe instanceof UncraftingRecipe) {
                    UncraftingRecipe uncraftingRecipe = (UncraftingRecipe)recipe;
                    n = uncraftingRecipe.count();
                } else {
                    n = recipe.m_8043_(this.level.m_9598_()).m_41613_();
                }
                this.uncraftingMatrix.numberOfInputItems = n;
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                this.storedGhostRecipe = null;
                this.uncraftingMatrix.numberOfInputItems = 0;
                this.uncraftingMatrix.uncraftingCost = 0;
            }
        }
        if (inventory == this.assemblyMatrix || inventory == this.tinkerInput) {
            if (this.tinkerInput.m_7983_()) {
                this.chooseRecipe(this.assemblyMatrix);
            } else {
                this.tinkerResult.m_6836_(0, ItemStack.f_41583_);
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
            }
            this.uncraftingMatrix.recraftingCost = 0;
        }
        if (inventory != this.combineMatrix && !this.uncraftingMatrix.m_7983_() && !this.assemblyMatrix.m_7983_()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack assembly = this.assemblyMatrix.m_8020_(i);
                ItemStack uncrafting = this.uncraftingMatrix.m_8020_(i);
                if (!assembly.m_41619_()) {
                    this.combineMatrix.m_6836_(i, assembly);
                    continue;
                }
                if (!uncrafting.m_41619_() && !UncraftingMenu.isMarked(uncrafting)) {
                    this.combineMatrix.m_6836_(i, uncrafting);
                    continue;
                }
                this.combineMatrix.m_6836_(i, ItemStack.f_41583_);
            }
            this.chooseRecipe(this.combineMatrix);
            ItemStack input = this.tinkerInput.m_8020_(0);
            ItemStack result = this.tinkerResult.m_8020_(0);
            if (!result.m_41619_() && UncraftingMenu.isValidMatchForInput(input, result)) {
                CompoundTag inputTags = null;
                if (input.m_41783_() != null) {
                    inputTags = input.m_41783_().m_6426_();
                }
                Map resultInnateEnchantments = EnchantmentHelper.m_44831_((ItemStack)result);
                Map inputEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
                inputEnchantments.keySet().removeIf(enchantment -> enchantment == null || !enchantment.m_6081_(result));
                if (inputTags != null) {
                    inputTags.m_128473_("ench");
                    inputTags.m_128473_("Damage");
                    result.m_41751_(inputTags);
                    EnchantmentHelper.m_44865_((Map)inputEnchantments, (ItemStack)result);
                }
                for (Map.Entry entry : resultInnateEnchantments.entrySet()) {
                    Enchantment ench = (Enchantment)entry.getKey();
                    int level = (Integer)entry.getValue();
                    if (!EnchantmentHelper.m_44859_(EnchantmentHelper.m_44831_((ItemStack)result).keySet(), (Enchantment)ench) || EnchantmentHelper.getTagEnchantmentLevel((Enchantment)ench, (ItemStack)result) >= level) continue;
                    result.m_41663_(ench, level);
                }
                this.tinkerResult.m_6836_(0, result);
                this.uncraftingMatrix.uncraftingCost = 0;
                this.uncraftingMatrix.recraftingCost = this.calculateRecraftingCost();
            }
        }
    }

    public static void markStack(ItemStack stack) {
        stack.m_41700_(TAG_MARKER, (Tag)ByteTag.m_128266_((byte)1));
    }

    public static boolean isMarked(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        return stackTag != null && stackTag.m_128471_(TAG_MARKER);
    }

    public static void unmarkStack(ItemStack stack) {
        TFItemStackUtils.clearInfoTag(stack, TAG_MARKER);
    }

    private static boolean isIngredientProblematic(ItemStack ingredient) {
        return !ingredient.m_41619_() && ingredient.m_41720_().hasCraftingRemainingItem(ingredient) || ingredient.m_150930_(Items.f_42127_);
    }

    private static ItemStack normalizeIngredient(ItemStack ingredient) {
        if (ingredient.m_41613_() > 1) {
            ingredient.m_41764_(1);
        }
        return ingredient;
    }

    private static Recipe<?>[] getRecipesFor(ItemStack inputStack, Level world) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        if (!inputStack.m_41619_()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!UncraftingMenu.isRecipeSupported(recipe) || recipe.m_142505_() || !recipe.m_8004_(3, 3) || recipe.m_7527_().isEmpty() || !UncraftingMenu.matches(inputStack, recipe.m_8043_(world.m_9598_())) || ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get()).booleanValue() != ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get()).contains(recipe.m_6423_().toString()) || ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()).booleanValue() != ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get()).contains(recipe.m_6423_().m_135827_())) continue;
                recipes.add(recipe);
            }
            for (UncraftingRecipe uncraftingRecipe : world.m_7465_().m_44013_((RecipeType)TFRecipes.UNCRAFTING_RECIPE.get())) {
                if (!uncraftingRecipe.isItemStackAnIngredient(inputStack)) continue;
                recipes.add(uncraftingRecipe);
            }
        }
        return recipes.toArray(new Recipe[0]);
    }

    private static boolean isRecipeSupported(Recipe<?> recipe) {
        return (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.allowShapelessUncrafting.get() != false ? recipe instanceof CraftingRecipe : recipe instanceof ShapedRecipe;
    }

    private static boolean matches(ItemStack input, ItemStack output) {
        return input.m_150930_(output.m_41720_()) && input.m_41613_() >= output.m_41613_();
    }

    private static CraftingRecipe[] getRecipesFor(CraftingContainer matrix, Level world) {
        return world.m_7465_().m_44056_(RecipeType.f_44107_, (Container)matrix, world).toArray(new CraftingRecipe[0]);
    }

    private void chooseRecipe(CraftingContainer inventory) {
        CraftingRecipe[] recipes = UncraftingMenu.getRecipesFor(inventory, this.level);
        if (recipes.length == 0) {
            this.tinkerResult.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        CraftingRecipe recipe = recipes[Math.floorMod(this.recipeInCycle, recipes.length)];
        if (recipe != null && (recipe.m_5598_() || !this.level.m_46469_().m_46207_(GameRules.f_46151_) || ((ServerPlayer)this.player).m_8952_().m_12709_((Recipe)recipe))) {
            this.tinkerResult.m_6029_((Recipe)recipe);
            this.tinkerResult.m_6836_(0, recipe.m_5874_((Container)inventory, this.level.m_9598_()));
        } else {
            this.tinkerResult.m_6836_(0, ItemStack.f_41583_);
        }
    }

    private static boolean isValidMatchForInput(ItemStack inputStack, ItemStack resultStack) {
        if (inputStack.m_204117_(ItemTags.f_271360_) && resultStack.m_204117_(ItemTags.f_271360_)) {
            return true;
        }
        if (inputStack.m_204117_(ItemTags.f_271207_) && resultStack.m_204117_(ItemTags.f_271207_)) {
            return true;
        }
        if (inputStack.m_204117_(ItemTags.f_271138_) && resultStack.m_204117_(ItemTags.f_271138_)) {
            return true;
        }
        if (inputStack.m_204117_(ItemTags.f_271298_) && resultStack.m_204117_(ItemTags.f_271298_)) {
            return true;
        }
        if (inputStack.m_204117_(ItemTags.f_271388_) && resultStack.m_204117_(ItemTags.f_271388_)) {
            return true;
        }
        if (inputStack.m_204117_(Tags.Items.TOOLS_BOWS) && resultStack.m_204117_(Tags.Items.TOOLS_BOWS)) {
            return true;
        }
        if (inputStack.m_204117_(Tags.Items.TOOLS_CROSSBOWS) && resultStack.m_204117_(Tags.Items.TOOLS_CROSSBOWS)) {
            return true;
        }
        if (inputStack.m_204117_(Tags.Items.TOOLS_FISHING_RODS) && resultStack.m_204117_(Tags.Items.TOOLS_FISHING_RODS)) {
            return true;
        }
        if (inputStack.m_204117_(Tags.Items.ARMORS) && resultStack.m_204117_(Tags.Items.ARMORS)) {
            return inputStack.getEquipmentSlot() == resultStack.getEquipmentSlot();
        }
        return false;
    }

    public int getUncraftingCost() {
        return this.uncraftingMatrix.uncraftingCost;
    }

    public int getRecraftingCost() {
        return this.uncraftingMatrix.recraftingCost;
    }

    private int calculateUncraftingCost() {
        if ((!((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get()).booleanValue() || this.storedGhostRecipe instanceof UncraftingRecipe) && this.assemblyMatrix.m_7983_()) {
            int n;
            Recipe<?> recipe = this.storedGhostRecipe;
            if (recipe instanceof UncraftingRecipe) {
                UncraftingRecipe recipe2 = (UncraftingRecipe)recipe;
                n = recipe2.cost();
            } else {
                n = (int)Math.round((double)UncraftingMenu.countDamageableParts(this.uncraftingMatrix) * (Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier.get());
            }
            return n;
        }
        return 0;
    }

    private int calculateRecraftingCost() {
        ItemStack input = this.tinkerInput.m_8020_(0);
        ItemStack output = this.tinkerResult.m_8020_(0);
        if (input.m_41619_() || output.m_41619_()) {
            return 0;
        }
        int cost = 0;
        if (!ItemStack.m_41656_((ItemStack)input, (ItemStack)output)) {
            cost += this.assemblyMatrix.m_280657_().stream().filter(stack -> !stack.m_41619_()).toList().size();
        }
        int enchantCost = UncraftingMenu.countTotalEnchantmentCost(input);
        cost += enchantCost;
        int damagedCost = (1 + this.countDamagedParts(input)) * EnchantmentHelper.m_44831_((ItemStack)output).size();
        cost += damagedCost;
        cost = Math.max(1, cost);
        return (int)Math.round((double)cost * (Double)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.repairingXpCostMultiplier.get());
    }

    private static int countTotalEnchantmentCost(ItemStack stack) {
        int count = 0;
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (ench == null || level <= 0) continue;
            count += UncraftingMenu.getWeightModifier(ench) * level;
            ++count;
        }
        return count;
    }

    private static int getWeightModifier(Enchantment ench) {
        return switch (ench.m_44699_().m_44716_()) {
            case 1 -> 8;
            case 2 -> 4;
            case 3, 4, 5 -> 2;
            default -> 1;
        };
    }

    public void m_150399_(int slotNum, int mouseButton, ClickType clickType, Player player) {
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.assemblyMatrix && player.f_36096_.m_142621_().m_41619_() && !((Slot)this.f_38839_.get(slotNum)).m_6657_() && this.assemblyMatrix.m_7983_() && (clickType != ClickType.SWAP || player.m_150109_().m_8020_(mouseButton).m_41619_())) {
            slotNum -= 9;
        }
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.tinkerResult && this.calculateRecraftingCost() > player.f_36078_ && !player.m_150110_().f_35937_) {
            return;
        }
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.uncraftingMatrix) {
            if (((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingOnly.get()).booleanValue() && !(this.storedGhostRecipe instanceof UncraftingRecipe)) {
                return;
            }
            if (this.calculateUncraftingCost() > player.f_36078_ && !player.m_150110_().f_35937_) {
                return;
            }
            ItemStack stackInSlot = ((Slot)this.f_38839_.get(slotNum)).m_7993_();
            if (stackInSlot.m_41619_() || UncraftingMenu.isMarked(stackInSlot)) {
                return;
            }
        }
        super.m_150399_(slotNum, mouseButton, clickType, player);
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.tinkerInput) {
            this.m_6199_(this.tinkerInput);
        }
    }

    private static boolean isDamageableComponent(ItemStack stack) {
        return !stack.m_41619_() && !stack.m_204117_(ItemTagGenerator.UNCRAFTING_IGNORES_COST);
    }

    private static int countDamageableParts(Container matrix) {
        int count = matrix.m_6643_();
        for (int i = 0; i < matrix.m_6643_(); ++i) {
            if (!UncraftingMenu.isIngredientProblematic(matrix.m_8020_(i)) && !UncraftingMenu.isMarked(matrix.m_8020_(i)) && UncraftingMenu.isDamageableComponent(matrix.m_8020_(i))) continue;
            --count;
        }
        return count;
    }

    private int countDamagedParts(ItemStack input) {
        int totalMax4 = Math.max(4, UncraftingMenu.countDamageableParts(this.uncraftingMatrix));
        float damage = (float)input.m_41773_() / (float)input.m_41776_();
        return (int)Math.ceil((float)totalMax4 * damage);
    }

    public ItemStack m_7648_(Player player, int slotNum) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotNum);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotNum == 0) {
                if (!this.m_38903_(itemstack1, 20, 56, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotNum == 1) {
                this.positionData.m_39292_((p_39378_, p_39379_) -> itemstack1.m_41720_().m_7836_(itemstack1, p_39378_, player));
                if (!this.m_38903_(itemstack1, 20, 56, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotNum >= 20 && slotNum < 56) {
                if (!this.m_38903_(itemstack1, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (slot.f_40218_ == this.assemblyMatrix) {
                if (!this.m_38903_(itemstack1, 20, 56, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38903_(itemstack1, 20, 56, false)) {
                slot.m_142406_(player, itemstack1);
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            if (slotNum == 1) {
                player.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.positionData.m_39292_((world, pos) -> {
            this.m_150411_(player, (Container)this.assemblyMatrix);
            this.m_150411_(player, this.tinkerInput);
        });
    }

    private ItemStack[] getIngredients(Recipe<?> recipe) {
        ItemStack[] stacks = new ItemStack[recipe.m_7527_().size()];
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            ItemStack[] matchingStacks = (ItemStack[])Arrays.stream(((Ingredient)recipe.m_7527_().get(i)).m_43908_()).filter(s -> !s.m_204117_(ItemTagGenerator.BANNED_UNCRAFTING_INGREDIENTS)).toArray(ItemStack[]::new);
            stacks[i] = matchingStacks.length > 0 ? matchingStacks[Math.floorMod(this.ingredientsInCycle, matchingStacks.length)] : ItemStack.f_41583_;
        }
        return stacks;
    }

    public boolean m_6875_(Player player) {
        return (Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableEntireTable.get() == false && UncraftingMenu.m_38889_((ContainerLevelAccess)this.positionData, (Player)player, (Block)((Block)TFBlocks.UNCRAFTING_TABLE.get()));
    }
}

