/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.ai.goal.RiderSpearAttackGoal;
import twilightforest.entity.monster.UpperGoblinKnight;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class LowerGoblinKnight
extends Monster {
    private static final EntityDataAccessor<Boolean> ARMOR = SynchedEntityData.m_135353_(LowerGoblinKnight.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AttributeModifier ARMOR_MODIFIER = new AttributeModifier("Armor boost", 17.0, AttributeModifier.Operation.ADDITION);

    public LowerGoblinKnight(EntityType<? extends LowerGoblinKnight> type, Level world) {
        super(type, world);
        this.setHasArmor(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RiderSpearAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            public boolean m_8036_() {
                Object e;
                if (this.f_25540_.m_20160_() && (e = this.f_25540_.m_20197_().get(0)) instanceof UpperGoblinKnight) {
                    UpperGoblinKnight knight = (UpperGoblinKnight)((Object)e);
                    if (knight.heavySpearTimer > 0) {
                        return false;
                    }
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ARMOR, (Object)false);
    }

    public boolean hasArmor() {
        return (Boolean)this.m_20088_().m_135370_(ARMOR);
    }

    private void setHasArmor(boolean flag) {
        this.m_20088_().m_135381_(ARMOR, (Object)flag);
        if (!this.m_9236_().m_5776_()) {
            if (flag) {
                if (!Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22109_(ARMOR_MODIFIER)) {
                    Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(ARMOR_MODIFIER);
                }
            } else {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22130_(ARMOR_MODIFIER);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasArmor", this.hasArmor());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasArmor(compound.m_128471_("hasArmor"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(accessor, difficulty, reason, data, tag);
        UpperGoblinKnight upper = new UpperGoblinKnight((EntityType<? extends UpperGoblinKnight>)((EntityType)TFEntities.UPPER_GOBLIN_KNIGHT.get()), this.m_9236_());
        upper.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
        upper.m_6518_(accessor, difficulty, MobSpawnType.NATURAL, data, tag);
        upper.m_20329_((Entity)this);
        return data;
    }

    public double m_6048_() {
        return 1.0;
    }

    public boolean m_7327_(Entity entity) {
        Object e;
        if (this.m_20160_() && (e = this.m_20197_().get(0)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            return living.m_7327_(entity);
        }
        return super.m_7327_(entity);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_20160_() ? (SoundEvent)TFSounds.GOBLIN_KNIGHT_MUFFLED_AMBIENT.get() : (SoundEvent)TFSounds.GOBLIN_KNIGHT_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_20160_() ? (SoundEvent)TFSounds.GOBLIN_KNIGHT_MUFFLED_DEATH.get() : (SoundEvent)TFSounds.GOBLIN_KNIGHT_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return this.m_20160_() ? (SoundEvent)TFSounds.GOBLIN_KNIGHT_MUFFLED_HURT.get() : (SoundEvent)TFSounds.GOBLIN_KNIGHT_HURT.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = null;
        if (source.m_7639_() != null) {
            attacker = source.m_7639_();
        }
        if (source.m_7639_() != null) {
            attacker = source.m_7639_();
        }
        if (attacker != null) {
            Object e;
            double dx = this.m_20185_() - attacker.m_20185_();
            double dz = this.m_20189_() - attacker.m_20189_();
            float angle = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float difference = Mth.m_14154_((float)((this.f_20883_ - angle) % 360.0f));
            UpperGoblinKnight upper = null;
            if (this.m_20160_() && (e = this.m_20197_().get(0)) instanceof UpperGoblinKnight) {
                UpperGoblinKnight goblin;
                upper = goblin = (UpperGoblinKnight)((Object)e);
            }
            if (upper != null && upper.hasShield() && difference > 150.0f && difference < 230.0f && upper.takeHitOnShield(source, amount)) {
                return false;
            }
            if (this.hasArmor() && (difference > 300.0f || difference < 60.0f)) {
                this.breakArmor();
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_19956_(Entity entity, Entity.MoveFunction callback) {
        super.m_19956_(entity, callback);
        if (entity instanceof UpperGoblinKnight) {
            UpperGoblinKnight goblin = (UpperGoblinKnight)entity;
            goblin.m_5618_(this.m_146908_());
            goblin.m_5616_(this.m_146908_());
            goblin.m_146922_(this.m_146908_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 5) {
            ItemStack broken = new ItemStack((ItemLike)Items.f_42469_);
            this.m_21278_(broken);
            this.m_21278_(broken);
            this.m_21278_(broken);
        } else {
            super.m_7822_(id);
        }
    }

    private void breakArmor() {
        this.m_9236_().m_7605_((Entity)this, (byte)5);
        this.setHasArmor(false);
    }
}

