/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.init.TFSounds;

public class CarminiteGhastling
extends CarminiteGhastguard {
    private boolean isMinion = false;

    public CarminiteGhastling(EntityType<? extends CarminiteGhastling> type, Level world) {
        super(type, world);
        this.wanderFactor = 4.0f;
        if (this.isMinion() && this.m_21051_(Attributes.f_22276_) != null) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(6.0);
            this.m_21153_(this.m_21233_());
        }
    }

    @Override
    public int m_5792_() {
        return 16;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CarminiteGhastguard.registerAttributes().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.5f;
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_DEATH.get();
    }

    @Override
    public SoundEvent getFireSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_SHOOT.get();
    }

    @Override
    public SoundEvent getWarnSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_WARN.get();
    }

    @Override
    public boolean shouldAttack(LivingEntity living) {
        ItemStack helmet = living.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_() && helmet.m_150930_(Items.f_42046_)) {
            return false;
        }
        if (living.m_20270_((Entity)this) <= 3.5f) {
            return living.m_142582_((Entity)this);
        }
        Vec3 vec3d = living.m_20252_(1.0f).m_82541_();
        Vec3 vec3d1 = new Vec3(this.m_20185_() - living.m_20185_(), this.m_20191_().f_82289_ + (double)this.m_20192_() - (living.m_20186_() + (double)living.m_20192_()), this.m_20189_() - living.m_20189_());
        double d0 = vec3d1.m_82553_();
        double d1 = vec3d.m_82526_(vec3d1 = vec3d1.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && living.m_142582_((Entity)this);
    }

    public static boolean canSpawnHere(EntityType<CarminiteGhastling> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && (reason == MobSpawnType.MOB_SUMMONED || Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random)) && CarminiteGhastling.m_217057_(entity, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public void makeBossMinion() {
        this.wanderFactor = 0.005f;
        this.isMinion = true;
        this.m_21051_(Attributes.f_22276_).m_22100_(6.0);
        this.m_21153_(this.m_21233_());
    }

    public boolean isMinion() {
        return this.isMinion;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("isMinion", this.isMinion);
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128471_("isMinion")) {
            this.makeBossMinion();
        }
    }

    public boolean m_6090_() {
        return true;
    }
}

