/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.boss.Naga;
import twilightforest.entity.boss.NagaSegment;

public class NagaModel<T extends Entity>
extends ListModel<T> {
    public final ModelPart head;
    public final ModelPart body;
    @Nullable
    private T entity;

    public NagaModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        partRoot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -12.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -12.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head, (Object)this.body);
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float scale) {
        T t = this.entity;
        if (t instanceof Naga) {
            Naga naga = (Naga)t;
            this.head.m_104306_(stack, builder, light, overlay, red, green - naga.stunlessRedOverlayProgress, blue - naga.stunlessRedOverlayProgress, scale * 2.0f);
        } else if (this.entity instanceof NagaSegment) {
            this.body.m_104306_(stack, builder, light, overlay, red, green, blue, scale * 2.0f);
        } else {
            this.head.m_104306_(stack, builder, light, overlay, red, green, blue, scale * 2.0f);
        }
        this.entity = null;
    }

    public void m_6973_(T entity, float v, float v1, float v2, float v3, float v4) {
        this.entity = entity;
    }
}

