/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.GiantBlock;
import twilightforest.block.MiniatureStructureBlock;
import twilightforest.block.entity.GrowingBeanstalkBlockEntity;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.EffectRenders;
import twilightforest.client.TFShaders;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.model.block.doors.CastleDoorModelLoader;
import twilightforest.client.model.block.forcefield.ForceFieldModelLoader;
import twilightforest.client.model.block.giantblock.GiantBlockModelLoader;
import twilightforest.client.model.block.leaves.BakedLeavesModel;
import twilightforest.client.model.block.patch.PatchModelLoader;
import twilightforest.client.renderer.TFSkyRenderer;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.compat.curios.CuriosCompat;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.events.HostileMountEvents;
import twilightforest.init.TFItems;
import twilightforest.item.EnderBowItem;
import twilightforest.item.GiantPickItem;
import twilightforest.item.IceBowItem;
import twilightforest.item.SeekerBowItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TripleBowItem;
import twilightforest.item.TrophyItem;
import twilightforest.world.registration.TFGenerationSettings;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT})
public class TFClientEvents {
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;
    private static float intensity = 0.0f;
    private static int aurora = 0;
    private static int lastAurora = 0;
    private static final MutableComponent WIP_TEXT_0 = Component.m_237115_((String)"misc.twilightforest.wip0").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final MutableComponent WIP_TEXT_1 = Component.m_237115_((String)"misc.twilightforest.wip1").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final MutableComponent NYI_TEXT = Component.m_237115_((String)"misc.twilightforest.nyi").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    private static final VoxelShape GIANT_BLOCK = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0);

    @SubscribeEvent
    public static void preOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id() == VanillaGuiOverlay.MOUNT_HEALTH.id() && HostileMountEvents.isRidingUnfriendly((LivingEntity)Minecraft.m_91087_().f_91074_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderLevelStageEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            EntityRenderer renderer;
            if (!((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue()) {
                return;
            }
            Options settings = Minecraft.m_91087_().f_91066_;
            if (settings.m_92176_() != CameraType.FIRST_PERSON || settings.f_92062_) {
                return;
            }
            Entity entity = Minecraft.m_91087_().m_91288_();
            if (entity instanceof LivingEntity && (renderer = Minecraft.m_91087_().m_91290_().m_114382_(entity)) instanceof LivingEntityRenderer) {
                for (EffectRenders effect : EffectRenders.VALUES) {
                    if (!effect.shouldRender((LivingEntity)entity, true)) continue;
                    effect.render((LivingEntity)entity, (EntityModel<? extends LivingEntity>)((LivingEntityRenderer)renderer).m_7200_(), 0.0, 0.0, 0.0, event.getPartialTick(), true);
                }
            }
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && (aurora > 0 || lastAurora > 0) && TFShaders.AURORA != null) {
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            double scale = 2048.0f * (Minecraft.m_91087_().f_91063_.m_109152_() / 32.0f);
            Vec3 pos = event.getCamera().m_90583_();
            double y = 256.0 - pos.m_7098_();
            buffer.m_5483_(-scale, y, scale).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_5483_(-scale, y, -scale).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_5483_(scale, y, -scale).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_5483_(scale, y, scale).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(Mth.m_14179_((float)event.getPartialTick(), (float)lastAurora, (float)aurora) / 60.0f * 0.5f));
            TFShaders.AURORA.invokeThenEndTesselator(Minecraft.m_91087_().f_91073_ == null ? 0 : Mth.m_14040_((int)((int)Minecraft.m_91087_().f_91073_.m_7062_().f_47863_)), (float)pos.m_7096_(), (float)pos.m_7098_(), (float)pos.m_7094_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && TFGenerationSettings.DIMENSION_KEY.equals((Object)minecraft.f_91073_.m_46472_()) && minecraft.f_91065_ != null) {
                minecraft.f_91065_.f_92980_ = 0.0f;
            }
            if (minecraft.f_91074_ != null && HostileMountEvents.isRidingUnfriendly((LivingEntity)minecraft.f_91074_) && minecraft.f_91065_ != null) {
                minecraft.f_91065_.m_93063_((Component)Component.m_237119_(), false);
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        float partial = mc.m_91296_();
        if (!mc.m_91104_()) {
            ++time;
            rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
            sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
            rotationTicker = (float)rotationTickerI + partial;
            sineTicker += partial;
            lastAurora = aurora++;
            if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91075_ != null && !TFConfig.getValidAuroraBiomes(Minecraft.m_91087_().f_91073_.m_9598_()).isEmpty()) {
                RegistryAccess access = Minecraft.m_91087_().f_91073_.m_9598_();
                Holder biome = Minecraft.m_91087_().f_91073_.m_204166_(Minecraft.m_91087_().f_91075_.m_20183_());
                if (!TFConfig.getValidAuroraBiomes(access).contains(access.m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)biome.m_203334_())))) {
                    --aurora;
                }
                aurora = Mth.m_14045_((int)aurora, (int)0, (int)60);
            } else {
                aurora = 0;
            }
        }
        if (!mc.m_91104_()) {
            BugModelAnimationHelper.animate();
            DimensionSpecialEffects info = DimensionSpecialEffectsManager.getForType((ResourceLocation)TwilightForestMod.prefix("renderer"));
            if (mc.f_91073_ != null && info instanceof TwilightForestRenderInfo) {
                TFWeatherRenderer.tick();
            }
            if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && mc.f_91073_ != null && mc.f_91074_ != null) {
                HashSet<ChunkPos> chunksInRange = new HashSet<ChunkPos>();
                for (int x = -16; x <= 16; x += 16) {
                    for (int z = -16; z <= 16; z += 16) {
                        chunksInRange.add(new ChunkPos((int)(mc.f_91074_.m_20185_() + (double)x) >> 4, (int)(mc.f_91074_.m_20189_() + (double)z) >> 4));
                    }
                }
                for (ChunkPos pos : chunksInRange) {
                    List<BlockEntity> beanstalksInChunk;
                    if (mc.f_91073_.m_6522_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62326_, false) == null || (beanstalksInChunk = mc.f_91073_.m_6325_(pos.f_45578_, pos.f_45579_).m_62954_().values().stream().filter(blockEntity -> {
                        GrowingBeanstalkBlockEntity beanstalkBlock;
                        return blockEntity instanceof GrowingBeanstalkBlockEntity && (beanstalkBlock = (GrowingBeanstalkBlockEntity)((Object)blockEntity)).isBeanstalkRumbling();
                    }).toList()).isEmpty()) continue;
                    BlockEntity beanstalk = beanstalksInChunk.get(0);
                    LocalPlayer player = mc.f_91074_;
                    intensity = (float)(1.0 - mc.f_91074_.m_20238_(Vec3.m_82512_((Vec3i)beanstalk.m_58899_())) / Math.pow(16.0, 2.0));
                    if (!(intensity > 0.0f)) continue;
                    player.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_() + (player.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity, player.m_146909_() + (player.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity);
                    intensity = 0.0f;
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public static void camera(ViewportEvent.ComputeCameraAngles event) {
        if (((Boolean)TFConfig.CLIENT_CONFIG.firstPersonEffects.get()).booleanValue() && !Minecraft.m_91087_().m_91104_() && intensity > 0.0f && Minecraft.m_91087_().f_91074_ != null) {
            event.setYaw((float)Mth.m_14139_((double)event.getPartialTick(), (double)event.getYaw(), (double)(event.getYaw() + (Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
            event.setPitch((float)Mth.m_14139_((double)event.getPartialTick(), (double)event.getPitch(), (double)(event.getPitch() + (Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
            event.setRoll((float)Mth.m_14139_((double)event.getPartialTick(), (double)event.getRoll(), (double)(event.getRoll() + (Minecraft.m_91087_().f_91074_.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
            intensity = 0.0f;
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        ItemStack item = event.getItemStack();
        if (!item.m_204117_(ItemTagGenerator.WIP) && !item.m_204117_(ItemTagGenerator.NYI)) {
            return;
        }
        if (item.m_204117_(ItemTagGenerator.WIP)) {
            event.getToolTip().add(WIP_TEXT_0);
            event.getToolTip().add(WIP_TEXT_1);
        } else {
            event.getToolTip().add(NYI_TEXT);
        }
    }

    @SubscribeEvent
    public static void FOVUpdate(ComputeFovModifierEvent event) {
        Item useItem;
        Player player = event.getPlayer();
        if (player.m_6117_() && ((useItem = player.m_21211_().m_41720_()) instanceof TripleBowItem || useItem instanceof EnderBowItem || useItem instanceof IceBowItem || useItem instanceof SeekerBowItem)) {
            float f = (float)player.m_21252_() / 20.0f;
            f = f > 1.0f ? 1.0f : f * f;
            event.setNewFovModifier(event.getFovModifier() * (1.0f - f * 0.15f));
        }
    }

    @SubscribeEvent
    public static void unrenderHeadWithTrophies(RenderLivingEvent<?, ?> event) {
        EntityModel entityModel;
        boolean visible;
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.HEAD);
        boolean bl = visible = !(stack.m_41720_() instanceof TrophyItem) && !(stack.m_41720_() instanceof SkullCandleItem) && !TFClientEvents.areCuriosEquipped(event.getEntity());
        if (!visible && (entityModel = event.getRenderer().m_7200_()) instanceof HeadedModel) {
            HeadedModel headedModel = (HeadedModel)entityModel;
            headedModel.m_5585_().f_104207_ = false;
            EntityModel entityModel2 = event.getRenderer().m_7200_();
            if (entityModel2 instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)entityModel2;
                humanoidModel.f_102809_.f_104207_ = false;
            }
        }
    }

    private static boolean areCuriosEquipped(LivingEntity entity) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.isTrophyCurioEquipped(entity) || CuriosCompat.isSkullCurioEquipped(entity);
        }
        return false;
    }

    @SubscribeEvent
    public static void translateBookAuthor(ItemTooltipEvent event) {
        CompoundTag tag;
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() instanceof WrittenBookItem && stack.m_41782_() && (tag = stack.m_41784_()).m_128441_("twilightforest:book")) {
            List components = event.getToolTip();
            for (Component component : components) {
                if (!component.toString().contains("book.byAuthor")) continue;
                components.set(components.indexOf(component), Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{Component.m_237115_((String)"twilightforest.book.author")}).m_130948_(component.m_7383_()));
            }
        }
    }

    @SubscribeEvent
    public static void onRenderBlockHighlightEvent(RenderHighlightEvent.Block event) {
        BlockItem blockItem;
        Item item;
        BlockPos pos = event.getTarget().m_82425_();
        BlockState state = event.getCamera().m_90592_().m_9236_().m_8055_(pos);
        if (state.m_60734_() instanceof MiniatureStructureBlock) {
            event.setCanceled(true);
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (player.m_21205_().m_41720_() instanceof GiantPickItem || (item = player.m_21205_().m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof GiantBlock)) {
            event.setCanceled(true);
            if (!state.m_60795_() && player.m_9236_().m_6857_().m_61937_(pos)) {
                BlockPos offsetPos = new BlockPos(pos.m_123341_() & 0xFFFFFFFC, pos.m_123342_() & 0xFFFFFFFC, pos.m_123343_() & 0xFFFFFFFC);
                TFClientEvents.renderGiantHitOutline(event.getPoseStack(), event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), event.getCamera().m_90583_(), offsetPos);
            }
        }
    }

    private static void renderGiantHitOutline(PoseStack poseStack, VertexConsumer consumer, Vec3 cam, BlockPos pos) {
        PoseStack.Pose last = poseStack.m_85850_();
        float posX = (float)pos.m_123341_() - (float)cam.m_7096_();
        float posY = (float)pos.m_123342_() - (float)cam.m_7098_();
        float posZ = (float)pos.m_123343_() - (float)cam.m_7094_();
        GIANT_BLOCK.m_83224_((x, y, z, x1, y1, z1) -> {
            float xSize = (float)(x1 - x);
            float ySize = (float)(y1 - y);
            float zSize = (float)(z1 - z);
            float sqrt = Mth.m_14116_((float)(xSize * xSize + ySize * ySize + zSize * zSize));
            consumer.m_252986_(last.m_252922_(), (float)(x + (double)posX), (float)(y + (double)posY), (float)(z + (double)posZ)).m_85950_(0.0f, 0.0f, 0.0f, 0.45f).m_252939_(last.m_252943_(), xSize /= sqrt, ySize /= sqrt, zSize /= sqrt).m_5752_();
            consumer.m_252986_(last.m_252922_(), (float)(x1 + (double)posX), (float)(y1 + (double)posY), (float)(z1 + (double)posZ)).m_85950_(0.0f, 0.0f, 0.0f, 0.45f).m_252939_(last.m_252943_(), xSize, ySize, zSize).m_5752_();
        });
    }

    @Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register("patch", (IGeometryLoader)PatchModelLoader.INSTANCE);
            event.register("giant_block", (IGeometryLoader)GiantBlockModelLoader.INSTANCE);
            event.register("force_field", (IGeometryLoader)ForceFieldModelLoader.INSTANCE);
            event.register("castle_door", (IGeometryLoader)CastleDoorModelLoader.INSTANCE);
        }

        @SubscribeEvent
        public static void modelBake(ModelEvent.ModifyBakingResult event) {
            TFItems.addItemModelProperties();
            List<Map.Entry> models = event.getModels().entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals("twilightforest") && ((ResourceLocation)entry.getKey()).m_135815_().contains("leaves") && !((ResourceLocation)entry.getKey()).m_135815_().contains("dark")).toList();
            models.forEach(entry -> event.getModels().put((ResourceLocation)entry.getKey(), new BakedLeavesModel((BakedModel)entry.getValue())));
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            event.register((ResourceLocation)ShieldLayer.LOC);
            event.register((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy"), "inventory"));
            event.register((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_minor"), "inventory"));
            event.register((ResourceLocation)new ModelResourceLocation(TwilightForestMod.prefix("trophy_quest"), "inventory"));
            event.register(TwilightForestMod.prefix("block/casket_obsidian"));
            event.register(TwilightForestMod.prefix("block/casket_stone"));
            event.register(TwilightForestMod.prefix("block/casket_basalt"));
        }

        @SubscribeEvent
        public static void registerDimEffects(RegisterDimensionSpecialEffectsEvent event) {
            new TFSkyRenderer();
            new TFWeatherRenderer();
            event.register(TwilightForestMod.prefix("renderer"), (DimensionSpecialEffects)new TwilightForestRenderInfo(128.0f, false, DimensionSpecialEffects.SkyType.NONE, false, false));
        }
    }
}

