/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render.entity.shadows;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EntityRenderDispatcher.class})
public class EntityRenderDispatcherMixin {
    @Unique
    private static final int SHADOW_COLOR = ColorABGR.pack(1.0f, 1.0f, 1.0f);

    @Overwrite
    private static void m_277056_(PoseStack.Pose entry, VertexConsumer vertices, ChunkAccess chunk, LevelReader world, BlockPos pos, double x, double y, double z, float radius, float opacity) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60838_((BlockGetter)world, blockPos)) {
            return;
        }
        int light = world.m_46803_(pos);
        if (light <= 3) {
            return;
        }
        VoxelShape voxelShape = blockState.m_60808_((BlockGetter)world, blockPos);
        if (voxelShape.m_83281_()) {
            return;
        }
        float brightness = LightTexture.m_234316_((DimensionType)world.m_6042_(), (int)light);
        float alpha = (float)(((double)opacity - (y - (double)pos.m_123342_()) / 2.0) * 0.5 * (double)brightness);
        if (alpha >= 0.0f) {
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            AABB box = voxelShape.m_83215_();
            float minX = (float)((double)pos.m_123341_() + box.f_82288_ - x);
            float maxX = (float)((double)pos.m_123341_() + box.f_82291_ - x);
            float minY = (float)((double)pos.m_123342_() + box.f_82289_ - y);
            float minZ = (float)((double)pos.m_123343_() + box.f_82290_ - z);
            float maxZ = (float)((double)pos.m_123343_() + box.f_82293_ - z);
            EntityRenderDispatcherMixin.renderShadowPart(entry, vertices, radius, alpha, minX, maxX, minY, minZ, maxZ);
        }
    }

    @Unique
    private static void renderShadowPart(PoseStack.Pose matrices, VertexConsumer vertices, float radius, float alpha, float minX, float maxX, float minY, float minZ, float maxZ) {
        float size = 0.5f * (1.0f / radius);
        float u1 = -minX * size + 0.5f;
        float u2 = -maxX * size + 0.5f;
        float v1 = -minZ * size + 0.5f;
        float v2 = -maxZ * size + 0.5f;
        Matrix3f matNormal = matrices.m_252943_();
        Matrix4f matPosition = matrices.m_252922_();
        int color = ColorABGR.withAlpha(SHADOW_COLOR, alpha);
        int normal = MatrixHelper.transformNormal(matNormal, 0.0f, 1.0f, 0.0f);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(144);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr, matPosition, minX, minY, minZ, u1, v1, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, minX, minY, maxZ, u1, v2, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, maxZ, u2, v2, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, minZ, u2, v1, color, normal);
            ptr += 36L;
            VertexBufferWriter.of(vertices).push(stack, buffer, 4, ModelVertex.FORMAT);
        }
    }

    @Unique
    private static void writeShadowVertex(long ptr, Matrix4f matPosition, float x, float y, float z, float u, float v, int color, int normal) {
        float xt = MatrixHelper.transformPositionX(matPosition, x, y, z);
        float yt = MatrixHelper.transformPositionY(matPosition, x, y, z);
        float zt = MatrixHelper.transformPositionZ(matPosition, x, y, z);
        ModelVertex.write(ptr, xt, yt, zt, color, u, v, 0xF000F0, OverlayTexture.f_118083_, normal);
    }
}

