/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.data;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferSegment;
import me.jellysquid.mods.sodium.client.gl.util.VertexRange;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.data.SectionRenderDataUnsafe;

public class SectionRenderDataStorage {
    private final GlBufferSegment[] allocations = new GlBufferSegment[256];
    private final long pMeshDataArray = SectionRenderDataUnsafe.allocateHeap(256);

    public void setMeshes(int localSectionIndex, GlBufferSegment allocation, VertexRange[] ranges) {
        if (this.allocations[localSectionIndex] != null) {
            this.allocations[localSectionIndex].delete();
            this.allocations[localSectionIndex] = null;
        }
        this.allocations[localSectionIndex] = allocation;
        long pMeshData = this.getDataPointer(localSectionIndex);
        int sliceMask = 0;
        int vertexOffset = allocation.getOffset();
        for (int facingIndex = 0; facingIndex < ModelQuadFacing.COUNT; ++facingIndex) {
            VertexRange vertexRange = ranges[facingIndex];
            int vertexCount = vertexRange != null ? vertexRange.vertexCount() : 0;
            SectionRenderDataUnsafe.setVertexOffset(pMeshData, facingIndex, vertexOffset);
            SectionRenderDataUnsafe.setElementCount(pMeshData, facingIndex, (vertexCount >> 2) * 6);
            if (vertexCount > 0) {
                sliceMask |= 1 << facingIndex;
            }
            vertexOffset += vertexCount;
        }
        SectionRenderDataUnsafe.setSliceMask(pMeshData, sliceMask);
    }

    public void removeMeshes(int localSectionIndex) {
        if (this.allocations[localSectionIndex] == null) {
            return;
        }
        this.allocations[localSectionIndex].delete();
        this.allocations[localSectionIndex] = null;
        SectionRenderDataUnsafe.clear(this.getDataPointer(localSectionIndex));
    }

    public void onBufferResized() {
        for (int sectionIndex = 0; sectionIndex < 256; ++sectionIndex) {
            this.updateMeshes(sectionIndex);
        }
    }

    private void updateMeshes(int sectionIndex) {
        GlBufferSegment allocation = this.allocations[sectionIndex];
        if (allocation == null) {
            return;
        }
        int offset = allocation.getOffset();
        long data = this.getDataPointer(sectionIndex);
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            SectionRenderDataUnsafe.setVertexOffset(data, facing, offset);
            int count = SectionRenderDataUnsafe.getElementCount(data, facing);
            offset += count / 6 * 4;
        }
    }

    public long getDataPointer(int sectionIndex) {
        return SectionRenderDataUnsafe.heapPointer(this.pMeshDataArray, sectionIndex);
    }

    public void delete() {
        for (GlBufferSegment allocation : this.allocations) {
            if (allocation == null) continue;
            allocation.delete();
        }
        Arrays.fill(this.allocations, null);
        SectionRenderDataUnsafe.freeHeap(this.pMeshDataArray);
    }
}

