/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import mekanism.common.config.value.CachedValue;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.ToolsTags;
import mekanism.tools.common.material.IPaxelMaterial;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.material.VanillaPaxelMaterialCreator;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekanismPaxel
extends DiggerItem
implements IHasRepairType,
IAttributeRefresher {
    private static final ToolAction PAXEL_DIG = ToolAction.get((String)"paxel_dig");
    private final IPaxelMaterial material;
    private final AttributeCache attributeCache;

    public ItemMekanismPaxel(MaterialCreator material, Item.Properties properties) {
        super(material.getPaxelDamage(), material.getPaxelAtkSpeed(), (Tier)material, ToolsTags.Blocks.MINEABLE_WITH_PAXEL, properties);
        this.material = material;
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.attackDamage, material.paxelDamage, material.paxelAtkSpeed});
    }

    public ItemMekanismPaxel(VanillaPaxelMaterialCreator material, Item.Properties properties) {
        super(material.getPaxelDamage(), material.getPaxelAtkSpeed(), (Tier)material.getVanillaTier(), ToolsTags.Blocks.MINEABLE_WITH_PAXEL, properties);
        this.material = material;
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.paxelDamage, material.paxelAtkSpeed});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    public float m_41008_() {
        return this.material.getPaxelDamage() + this.m_43314_().m_6631_();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return action == PAXEL_DIG || ToolActions.DEFAULT_AXE_ACTIONS.contains(action) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(action) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(action);
    }

    public float m_8102_(@NotNull ItemStack stack, @NotNull BlockState state) {
        return super.m_8102_(stack, state) == 1.0f ? 1.0f : this.material.getPaxelEfficiency();
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockstate = world.m_8055_(blockpos);
        BlockState resultToSet = this.useAsAxe(blockstate, context);
        if (resultToSet == null) {
            if (context.m_43719_() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState foundResult = blockstate.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
            if (foundResult != null && world.m_46859_(blockpos.m_7494_())) {
                world.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                resultToSet = foundResult;
            } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                if (!world.f_46443_) {
                    world.m_5898_(null, 1009, blockpos, 0);
                }
                CampfireBlock.m_152749_((Entity)player, (LevelAccessor)world, (BlockPos)blockpos, (BlockState)blockstate);
                resultToSet = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
            }
            if (resultToSet == null) {
                return InteractionResult.PASS;
            }
        }
        if (!world.f_46443_) {
            ItemStack stack = context.m_43722_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockpos, stack);
            }
            world.m_7731_(blockpos, resultToSet, 11);
            if (player != null) {
                stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(context.m_43724_()));
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Nullable
    private BlockState useAsAxe(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState resultToSet = state.getToolModifiedState(context, ToolActions.AXE_STRIP, false);
        if (resultToSet != null) {
            world.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        resultToSet = state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false);
        if (resultToSet != null) {
            world.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3005, blockpos, 0);
            return resultToSet;
        }
        resultToSet = state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false);
        if (resultToSet != null) {
            world.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3004, blockpos, 0);
            return resultToSet;
        }
        return null;
    }

    public int m_6473_() {
        return this.material.getPaxelEnchantability();
    }

    @Override
    @NotNull
    public Ingredient getRepairMaterial() {
        return this.m_43314_().m_6282_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getPaxelMaxUses();
    }

    public boolean m_41465_() {
        return this.material.getPaxelMaxUses() > 0;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? (Multimap)this.attributeCache.get() : ImmutableMultimap.of();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.m_41008_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.material.getPaxelAtkSpeed(), AttributeModifier.Operation.ADDITION));
    }
}

