/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.ItemRobit;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ItemRecipeData
implements RecipeUpgradeData<ItemRecipeData> {
    private final List<IInventorySlot> slots;

    ItemRecipeData(ListTag slots) {
        this(ItemRecipeData.readContents(slots));
    }

    ItemRecipeData(List<IInventorySlot> slots) {
        this.slots = slots;
    }

    @Override
    @Nullable
    public ItemRecipeData merge(ItemRecipeData other) {
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots);
        allSlots.addAll(other.slots);
        return new ItemRecipeData(allSlots);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.slots.isEmpty()) {
            return true;
        }
        Item item = stack.m_41720_();
        boolean isBin = item instanceof ItemBlockBin;
        Optional capability = stack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        ArrayList<IInventorySlot> stackSlots = new ArrayList<IInventorySlot>();
        if (capability.isPresent()) {
            IItemHandler itemHandler = (IItemHandler)capability.get();
            int i = 0;
            int slots = itemHandler.getSlots();
            while (i < slots) {
                int slot = i++;
                stackSlots.add(new DummyInventorySlot(itemHandler.getSlotLimit(slot), itemStack -> itemHandler.isItemValid(slot, itemStack), isBin));
            }
        } else if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            TileEntityMekanism tile = this.getTileFromBlock(blockItem.m_40614_());
            if (tile == null || !tile.persistInventory()) {
                return false;
            }
            int i = 0;
            int slots = tile.getSlots();
            while (i < slots) {
                int slot = i++;
                stackSlots.add(new DummyInventorySlot(tile.getSlotLimit(slot), itemStack -> tile.isItemValid(slot, (ItemStack)itemStack), isBin));
            }
        } else if (item instanceof ItemRobit) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                for (int slotX = 0; slotX < 9; ++slotX) {
                    stackSlots.add(new DummyInventorySlot(64, BasicInventorySlot.alwaysTrue, false));
                }
            }
            stackSlots.add(new DummyInventorySlot(64, itemStack -> {
                if (EnergyCompatUtils.hasStrictEnergyHandler(itemStack)) {
                    return true;
                }
                ItemStackToEnergyRecipe foundRecipe = (ItemStackToEnergyRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.ENERGY_CONVERSION.getInputCache()).findTypeBasedRecipe(null, itemStack);
                return foundRecipe != null && !foundRecipe.getOutput((ItemStack)itemStack).isZero();
            }, false));
            stackSlots.add(new DummyInventorySlot(64, itemStack -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SMELTING.getInputCache()).containsInput(null, itemStack), false));
            stackSlots.add(new DummyInventorySlot(64, BasicInventorySlot.alwaysTrue, false));
        } else {
            if (item instanceof IItemSustainedInventory) {
                IItemSustainedInventory sustainedInventory = (IItemSustainedInventory)item;
                for (IInventorySlot slot : this.slots) {
                    if (slot.isEmpty()) continue;
                    sustainedInventory.setSustainedInventory(DataHandlerUtils.writeContainers(this.slots), stack);
                    return true;
                }
                return true;
            }
            return false;
        }
        return ItemRecipeData.applyToStack(this.slots, stackSlots, toWrite -> ((IItemSustainedInventory)stack.m_41720_()).setSustainedInventory((ListTag)toWrite, stack));
    }

    static boolean applyToStack(List<IInventorySlot> dataSlots, final List<IInventorySlot> stackSlots, Consumer<ListTag> stackWriter) {
        if (stackSlots.isEmpty()) {
            return true;
        }
        IMekanismInventory outputHandler = new IMekanismInventory(){

            @Override
            @NotNull
            public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
                return stackSlots;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IInventorySlot slot : dataSlots) {
            if (slot.isEmpty()) continue;
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)outputHandler, (ItemStack)slot.getStack(), (boolean)false).m_41619_()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            stackWriter.accept(DataHandlerUtils.writeContainers(stackSlots));
        }
        return true;
    }

    public static List<IInventorySlot> readContents(@Nullable ListTag contents) {
        if (contents == null || contents.isEmpty()) {
            return Collections.emptyList();
        }
        int count = DataHandlerUtils.getMaxId(contents, "Slot");
        ArrayList<IInventorySlot> slots = new ArrayList<IInventorySlot>(count);
        for (int i = 0; i < count; ++i) {
            slots.add(new DummyInventorySlot());
        }
        DataHandlerUtils.readContainers(slots, contents);
        return slots;
    }

    private static class DummyInventorySlot
    extends BasicInventorySlot {
        private DummyInventorySlot() {
            this(Integer.MAX_VALUE, alwaysTrue, true);
        }

        private DummyInventorySlot(int capacity, Predicate<@NotNull ItemStack> validator, boolean isBin) {
            super(capacity, alwaysTrueBi, alwaysTrueBi, validator, null, 0, 0);
            if (isBin) {
                this.obeyStackLimit = false;
            }
        }
    }
}

