/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.chemical.ChemicalToChemicalRecipe;
import mekanism.api.recipes.chemical.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IItemStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.impl.SmeltingIRecipe;
import mekanism.common.recipe.lookup.cache.ChemicalCrystallizerInputRecipeCache;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.cache.RotaryInputRecipeCache;
import mekanism.common.registration.impl.RecipeTypeDeferredRegister;
import mekanism.common.registration.impl.RecipeTypeRegistryObject;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekanismRecipeType<RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache>
implements RecipeType<RECIPE>,
IMekanismRecipeTypeProvider<RECIPE, INPUT_CACHE> {
    public static final RecipeTypeDeferredRegister RECIPE_TYPES = new RecipeTypeDeferredRegister("mekanism");
    public static final RecipeTypeRegistryObject<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> CRUSHING = MekanismRecipeType.register("crushing", recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final RecipeTypeRegistryObject<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> ENRICHING = MekanismRecipeType.register("enriching", recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final RecipeTypeRegistryObject<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> SMELTING = MekanismRecipeType.register("smelting", recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final RecipeTypeRegistryObject<ChemicalInfuserRecipe, InputRecipeCache.EitherSideChemical<Gas, GasStack, ChemicalInfuserRecipe>> CHEMICAL_INFUSING = MekanismRecipeType.register("chemical_infusing", InputRecipeCache.EitherSideChemical::new);
    public static final RecipeTypeRegistryObject<CombinerRecipe, InputRecipeCache.DoubleItem<CombinerRecipe>> COMBINING = MekanismRecipeType.register("combining", recipeType -> new InputRecipeCache.DoubleItem<CombinerRecipe>((MekanismRecipeType<CombinerRecipe, ?>)recipeType, CombinerRecipe::getMainInput, CombinerRecipe::getExtraInput));
    public static final RecipeTypeRegistryObject<ElectrolysisRecipe, InputRecipeCache.SingleFluid<ElectrolysisRecipe>> SEPARATING = MekanismRecipeType.register("separating", recipeType -> new InputRecipeCache.SingleFluid<ElectrolysisRecipe>((MekanismRecipeType<ElectrolysisRecipe, ?>)recipeType, ElectrolysisRecipe::getInput));
    public static final RecipeTypeRegistryObject<FluidSlurryToSlurryRecipe, InputRecipeCache.FluidChemical<Slurry, SlurryStack, FluidSlurryToSlurryRecipe>> WASHING = MekanismRecipeType.register("washing", recipeType -> new InputRecipeCache.FluidChemical((MekanismRecipeType<FluidSlurryToSlurryRecipe, ?>)recipeType, FluidChemicalToChemicalRecipe::getFluidInput, FluidChemicalToChemicalRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<FluidToFluidRecipe, InputRecipeCache.SingleFluid<FluidToFluidRecipe>> EVAPORATING = MekanismRecipeType.register("evaporating", recipeType -> new InputRecipeCache.SingleFluid<FluidToFluidRecipe>((MekanismRecipeType<FluidToFluidRecipe, ?>)recipeType, FluidToFluidRecipe::getInput));
    public static final RecipeTypeRegistryObject<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> ACTIVATING = MekanismRecipeType.register("activating", recipeType -> new InputRecipeCache.SingleChemical((MekanismRecipeType<GasToGasRecipe, ?>)recipeType, ChemicalToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> CENTRIFUGING = MekanismRecipeType.register("centrifuging", recipeType -> new InputRecipeCache.SingleChemical((MekanismRecipeType<GasToGasRecipe, ?>)recipeType, ChemicalToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<ChemicalCrystallizerRecipe, ChemicalCrystallizerInputRecipeCache> CRYSTALLIZING = MekanismRecipeType.register("crystallizing", ChemicalCrystallizerInputRecipeCache::new);
    public static final RecipeTypeRegistryObject<ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDissolutionRecipe>> DISSOLUTION = MekanismRecipeType.register("dissolution", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ChemicalDissolutionRecipe, ?>)recipeType, ChemicalDissolutionRecipe::getItemInput, ChemicalDissolutionRecipe::getGasInput));
    public static final RecipeTypeRegistryObject<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> COMPRESSING = MekanismRecipeType.register("compressing", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> PURIFYING = MekanismRecipeType.register("purifying", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> INJECTING = MekanismRecipeType.register("injecting", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<NucleosynthesizingRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, NucleosynthesizingRecipe>> NUCLEOSYNTHESIZING = MekanismRecipeType.register("nucleosynthesizing", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<NucleosynthesizingRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<ItemStackToEnergyRecipe, InputRecipeCache.SingleItem<ItemStackToEnergyRecipe>> ENERGY_CONVERSION = MekanismRecipeType.register("energy_conversion", recipeType -> new InputRecipeCache.SingleItem<ItemStackToEnergyRecipe>((MekanismRecipeType<ItemStackToEnergyRecipe, ?>)recipeType, ItemStackToEnergyRecipe::getInput));
    public static final RecipeTypeRegistryObject<ItemStackToGasRecipe, InputRecipeCache.SingleItem<ItemStackToGasRecipe>> GAS_CONVERSION = MekanismRecipeType.register("gas_conversion", recipeType -> new InputRecipeCache.SingleItem<ItemStackToGasRecipe>((MekanismRecipeType<ItemStackToGasRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<ItemStackToGasRecipe, InputRecipeCache.SingleItem<ItemStackToGasRecipe>> OXIDIZING = MekanismRecipeType.register("oxidizing", recipeType -> new InputRecipeCache.SingleItem<ItemStackToGasRecipe>((MekanismRecipeType<ItemStackToGasRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<ItemStackToInfuseTypeRecipe, InputRecipeCache.SingleItem<ItemStackToInfuseTypeRecipe>> INFUSION_CONVERSION = MekanismRecipeType.register("infusion_conversion", recipeType -> new InputRecipeCache.SingleItem<ItemStackToInfuseTypeRecipe>((MekanismRecipeType<ItemStackToInfuseTypeRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<ItemStackToPigmentRecipe, InputRecipeCache.SingleItem<ItemStackToPigmentRecipe>> PIGMENT_EXTRACTING = MekanismRecipeType.register("pigment_extracting", recipeType -> new InputRecipeCache.SingleItem<ItemStackToPigmentRecipe>((MekanismRecipeType<ItemStackToPigmentRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<PigmentMixingRecipe, InputRecipeCache.EitherSideChemical<Pigment, PigmentStack, PigmentMixingRecipe>> PIGMENT_MIXING = MekanismRecipeType.register("pigment_mixing", InputRecipeCache.EitherSideChemical::new);
    public static final RecipeTypeRegistryObject<MetallurgicInfuserRecipe, InputRecipeCache.ItemChemical<InfuseType, InfusionStack, MetallurgicInfuserRecipe>> METALLURGIC_INFUSING = MekanismRecipeType.register("metallurgic_infusing", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<MetallurgicInfuserRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<PaintingRecipe, InputRecipeCache.ItemChemical<Pigment, PigmentStack, PaintingRecipe>> PAINTING = MekanismRecipeType.register("painting", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<PaintingRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<PressurizedReactionRecipe, InputRecipeCache.ItemFluidChemical<Gas, GasStack, PressurizedReactionRecipe>> REACTION = MekanismRecipeType.register("reaction", recipeType -> new InputRecipeCache.ItemFluidChemical((MekanismRecipeType<PressurizedReactionRecipe, ?>)recipeType, PressurizedReactionRecipe::getInputSolid, PressurizedReactionRecipe::getInputFluid, PressurizedReactionRecipe::getInputGas));
    public static final RecipeTypeRegistryObject<RotaryRecipe, RotaryInputRecipeCache> ROTARY = MekanismRecipeType.register("rotary", RotaryInputRecipeCache::new);
    public static final RecipeTypeRegistryObject<SawmillRecipe, InputRecipeCache.SingleItem<SawmillRecipe>> SAWING = MekanismRecipeType.register("sawing", recipeType -> new InputRecipeCache.SingleItem<SawmillRecipe>((MekanismRecipeType<SawmillRecipe, ?>)recipeType, SawmillRecipe::getInput));
    private List<RECIPE> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;
    private final INPUT_CACHE inputCache;

    private static <RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache> RecipeTypeRegistryObject<RECIPE, INPUT_CACHE> register(String name, Function<MekanismRecipeType<RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        return RECIPE_TYPES.register(name, () -> new MekanismRecipeType(name, inputCacheCreator));
    }

    public static void clearCache() {
        for (IMekanismRecipeTypeProvider<?, ?> recipeTypeProvider : RECIPE_TYPES.getAllRecipeTypes()) {
            recipeTypeProvider.getRecipeType().clearCaches();
        }
    }

    private MekanismRecipeType(String name, Function<MekanismRecipeType<RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        this.registryName = Mekanism.rl(name);
        this.inputCache = (IInputRecipeCache)inputCacheCreator.apply(this);
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public MekanismRecipeType<RECIPE, INPUT_CACHE> getRecipeType() {
        return this;
    }

    private void clearCaches() {
        this.cachedRecipes = Collections.emptyList();
        this.inputCache.clear();
    }

    @Override
    public INPUT_CACHE getInputCache() {
        return this.inputCache;
    }

    @Override
    @NotNull
    public List<RECIPE> getRecipes(@Nullable Level world) {
        if (world == null && (world = FMLEnvironment.dist.isClient() ? MekanismClient.tryGetClientWorld() : ServerLifecycleHooks.getCurrentServer().m_129783_()) == null) {
            return Collections.emptyList();
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.m_7465_();
            ArrayList<SmeltingIRecipe> recipes = recipeManager.m_44013_((RecipeType)this);
            if (this == SMELTING.get()) {
                recipes = new ArrayList<SmeltingIRecipe>(recipes);
                for (SmeltingRecipe smeltingRecipe : recipeManager.m_44013_(RecipeType.f_44108_)) {
                    NonNullList ingredients;
                    ItemStack recipeOutput = smeltingRecipe.m_8043_(world.m_9598_());
                    if (smeltingRecipe.m_5598_() || smeltingRecipe.m_142505_() || recipeOutput.m_41619_() || (ingredients = smeltingRecipe.m_7527_()).isEmpty()) continue;
                    IItemStackIngredientCreator ingredientCreator = IngredientCreatorAccess.item();
                    ItemStackIngredient input = ingredientCreator.from(ingredients.stream().map(ingredientCreator::from));
                    recipes.add(new SmeltingIRecipe(smeltingRecipe.m_6423_(), input, recipeOutput));
                }
            }
            this.cachedRecipes = recipes.stream().filter(recipe -> !recipe.m_142505_()).toList();
        }
        return this.cachedRecipes;
    }

    public static <C extends Container, RECIPE_TYPE extends Recipe<C>> Optional<RECIPE_TYPE> getRecipeFor(RecipeType<RECIPE_TYPE> recipeType, C inventory, Level level) {
        return level.m_7465_().m_44015_(recipeType, inventory, level).filter(recipe -> recipe.m_5598_() || !recipe.m_142505_());
    }

    public static Optional<? extends Recipe<?>> byKey(Level level, ResourceLocation id) {
        return level.m_7465_().m_44043_(id).filter(recipe -> recipe.m_5598_() || !recipe.m_142505_());
    }
}

