/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mekanism.api.Coord4D;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.content.transporter.SorterModIDFilter;
import mekanism.common.content.transporter.SorterTagFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.Convertable;
import mekanism.common.integration.computer.MethodHelpData;
import mekanism.common.integration.computer.SpecialConverters;
import mekanism.common.integration.computer.TableType;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.util.RegistryUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseComputerHelper {
    public static final Lazy<Map<Class<?>, TableType>> BUILTIN_TABLES = Lazy.of(BaseComputerHelper::getBuiltInTables);

    @NotNull
    private <T> T requireNonNull(int param, @Nullable T value) throws ComputerException {
        if (value == null) {
            throw new ComputerException("Invalid parameter at index " + param);
        }
        return value;
    }

    @NotNull
    public <T extends Enum<T>> T getEnum(int param, Class<T> enumClazz) throws ComputerException {
        return (T)((Enum)this.requireNonNull(param, SpecialConverters.sanitizeStringToEnum(enumClazz, this.getString(param))));
    }

    public abstract boolean getBoolean(int var1) throws ComputerException;

    public abstract byte getByte(int var1) throws ComputerException;

    public abstract short getShort(int var1) throws ComputerException;

    public abstract int getInt(int var1) throws ComputerException;

    public abstract long getLong(int var1) throws ComputerException;

    public abstract char getChar(int var1) throws ComputerException;

    public abstract float getFloat(int var1) throws ComputerException;

    public abstract double getDouble(int var1) throws ComputerException;

    public FloatingLong getFloatingLong(int param) throws ComputerException {
        double finiteDouble = this.getDouble(param);
        if (finiteDouble < 0.0) {
            return FloatingLong.ZERO;
        }
        return FloatingLong.createConst(finiteDouble);
    }

    @NotNull
    public abstract String getString(int var1) throws ComputerException;

    @NotNull
    public abstract Map<?, ?> getMap(int var1) throws ComputerException;

    @Nullable
    public <FILTER extends IFilter<FILTER>> FILTER getFilter(int param, Class<FILTER> expectedType) throws ComputerException {
        return SpecialConverters.convertMapToFilter(expectedType, this.getMap(param));
    }

    @NotNull
    public ResourceLocation getResourceLocation(int param) throws ComputerException {
        return this.requireNonNull(param, ResourceLocation.m_135820_((String)this.getString(param)));
    }

    public Item getItem(int param) throws ComputerException {
        ResourceLocation itemName = this.getResourceLocation(param);
        return BaseComputerHelper.getItemFromResourceLocation(itemName);
    }

    @NotNull
    private static Item getItemFromResourceLocation(ResourceLocation itemName) {
        if (itemName == null) {
            return Items.f_41852_;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
        if (item != null) {
            return item;
        }
        return Items.f_41852_;
    }

    public ItemStack getItemStack(int param) throws ComputerException {
        Map<?, ?> map = this.getMap(param);
        try {
            Item item = BaseComputerHelper.getItemFromResourceLocation(ResourceLocation.m_135820_((String)((String)map.get("name"))));
            int count = SpecialConverters.getIntFromRaw(map.get("count"));
            String nbt = (String)map.get("nbt");
            return new ItemStack((ItemLike)item, count, nbt != null ? NbtUtils.m_178024_((String)nbt) : null);
        }
        catch (ClassCastException ex) {
            throw new ComputerException("Invalid ItemStack at index " + param);
        }
        catch (CommandSyntaxException e) {
            throw new ComputerException("Invalid NBT data");
        }
    }

    public Object voidResult() {
        return null;
    }

    public Object convert(@Nullable FloatingLong result) {
        if (result == null) {
            return 0;
        }
        if (result.getDecimal() == 0 && result.getValue() >= 0L) {
            return result.longValue();
        }
        return result.doubleValue();
    }

    public Object convert(int i) {
        return i;
    }

    public Object convert(long i) {
        return i;
    }

    public Object convert(double d) {
        return d;
    }

    public Object convert(String s) {
        return s;
    }

    public Object convert(boolean b) {
        return b;
    }

    public <T> Object convert(@Nullable Collection<T> list, @NotNull Function<T, Object> converter) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> converted = new ArrayList<Object>(list.size());
        for (T el : list) {
            converted.add(converter.apply(el));
        }
        return converted;
    }

    public Object convert(@Nullable ResourceLocation rl) {
        return rl != null ? rl.toString() : null;
    }

    public Object convert(@Nullable UUID uuid) {
        return uuid != null ? uuid.toString() : null;
    }

    public Object convert(@Nullable ChemicalStack<?> stack) {
        if (stack == null) {
            return null;
        }
        HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
        wrapped.put("name", this.convert(stack.getTypeRegistryName()));
        wrapped.put("amount", stack.getAmount());
        return wrapped;
    }

    public Object convert(@Nullable FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return SpecialConverters.wrapStack(RegistryUtils.getName(stack.getFluid()), "amount", stack.getAmount(), stack.getTag());
    }

    public Object convert(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return SpecialConverters.wrapStack(RegistryUtils.getName(stack.m_41720_()), "count", stack.m_41613_(), stack.m_41783_());
    }

    public Object convert(@Nullable BlockState state) {
        if (state == null) {
            return null;
        }
        HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
        ResourceLocation name = RegistryUtils.getName(state.m_60734_());
        if (name != null) {
            wrapped.put("block", this.convert(name));
        }
        HashMap stateData = new HashMap();
        for (Map.Entry entry : state.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            Object value = entry.getValue();
            if (!(property instanceof IntegerProperty) && !(property instanceof BooleanProperty)) {
                value = Util.m_137453_((Property)property, value);
            }
            stateData.put(property.m_61708_(), value);
        }
        if (!stateData.isEmpty()) {
            wrapped.put("state", stateData);
        }
        return wrapped;
    }

    public Object convert(@Nullable Vec3i pos) {
        if (pos == null) {
            return null;
        }
        HashMap<String, Integer> wrapped = new HashMap<String, Integer>(3);
        wrapped.put("x", pos.m_123341_());
        wrapped.put("y", pos.m_123342_());
        wrapped.put("z", pos.m_123343_());
        return wrapped;
    }

    public Object convert(@Nullable Coord4D coord) {
        if (coord == null) {
            return null;
        }
        HashMap<String, Object> wrapped = new HashMap<String, Object>(4);
        wrapped.put("x", coord.getX());
        wrapped.put("y", coord.getY());
        wrapped.put("z", coord.getZ());
        wrapped.put("dimension", this.convert(coord.dimension.m_135782_()));
        return wrapped;
    }

    public Object convert(@Nullable Frequency frequency) {
        if (frequency == null) {
            return null;
        }
        Frequency.FrequencyIdentity identity = frequency.getIdentity();
        HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
        wrapped.put("key", identity.key().toString());
        wrapped.put("public", identity.isPublic());
        return wrapped;
    }

    public Object convert(@Nullable Enum<?> res) {
        return res != null ? res.name() : null;
    }

    protected Map<String, Object> convertFilterCommon(IFilter<?> result) {
        HashMap<String, Object> wrapped = new HashMap<String, Object>();
        wrapped.put("type", this.convert(result.getFilterType()));
        wrapped.put("enabled", result.isEnabled());
        if (result instanceof IItemStackFilter) {
            CompoundTag tag;
            IItemStackFilter itemFilter = (IItemStackFilter)result;
            ItemStack stack = itemFilter.getItemStack();
            wrapped.put("item", this.convert(stack.m_41720_()));
            if (!stack.m_41619_() && (tag = stack.m_41783_()) != null && !tag.m_128456_()) {
                wrapped.put("itemNBT", SpecialConverters.wrapNBT(tag));
            }
        } else if (result instanceof IModIDFilter) {
            IModIDFilter modIDFilter = (IModIDFilter)result;
            wrapped.put("modId", modIDFilter.getModID());
        } else if (result instanceof ITagFilter) {
            ITagFilter tagFilter = (ITagFilter)result;
            wrapped.put("tag", tagFilter.getTagName());
        }
        return wrapped;
    }

    public Object convert(@Nullable MinerFilter<?> minerFilter) {
        if (minerFilter == null) {
            return null;
        }
        Map<String, Object> wrapped = this.convertFilterCommon(minerFilter);
        wrapped.put("requiresReplacement", minerFilter.requiresReplacement);
        wrapped.put("replaceTarget", this.convert(minerFilter.replaceTarget));
        return wrapped;
    }

    public Object convert(@Nullable SorterFilter<?> sorterFilter) {
        if (sorterFilter == null) {
            return null;
        }
        Map<String, Object> wrapped = this.convertFilterCommon(sorterFilter);
        wrapped.put("allowDefault", sorterFilter.allowDefault);
        wrapped.put("color", this.convert(sorterFilter.color));
        wrapped.put("size", sorterFilter.sizeMode);
        wrapped.put("min", sorterFilter.min);
        wrapped.put("max", sorterFilter.max);
        if (sorterFilter instanceof SorterItemStackFilter) {
            SorterItemStackFilter filter = (SorterItemStackFilter)sorterFilter;
            wrapped.put("fuzzy", filter.fuzzyMode);
        }
        return wrapped;
    }

    public Object convert(@Nullable QIOFilter<?> qioFilter) {
        if (qioFilter == null) {
            return null;
        }
        Map<String, Object> wrapped = this.convertFilterCommon(qioFilter);
        if (qioFilter instanceof QIOItemStackFilter) {
            QIOItemStackFilter filter = (QIOItemStackFilter)qioFilter;
            wrapped.put("fuzzy", filter.fuzzyMode);
        }
        return wrapped;
    }

    public Object convert(@Nullable OredictionificatorFilter<?, ?, ?> filter) {
        if (filter == null) {
            return null;
        }
        Map<String, Object> wrapped = this.convertFilterCommon(filter);
        wrapped.put("target", filter.getFilterText());
        if (filter instanceof OredictionificatorItemFilter) {
            OredictionificatorItemFilter itemFilter = (OredictionificatorItemFilter)filter;
            wrapped.put("selected", this.convert(itemFilter.getResultElement()));
        }
        return wrapped;
    }

    public <KEY, VALUE> Object convert(@NotNull Map<KEY, VALUE> res, Function<KEY, Object> keyConverter, @NotNull Function<VALUE, Object> valueConverter) {
        return res.entrySet().stream().collect(Collectors.toMap(entry -> keyConverter.apply(entry.getKey()), entry -> valueConverter.apply(entry.getValue()), (a, b) -> b));
    }

    public Object convert(@Nullable Item item) {
        if (item == null) {
            return null;
        }
        return this.convert(RegistryUtils.getName(item));
    }

    public Object convert(@Nullable Convertable<?> convertable) {
        if (convertable == null) {
            return null;
        }
        return convertable.convert(this);
    }

    public Object convert(@Nullable MethodHelpData methodHelpData) {
        if (methodHelpData == null) {
            return null;
        }
        HashMap<String, Object> helpData = new HashMap<String, Object>();
        helpData.put("name", methodHelpData.methodName());
        if (methodHelpData.params() != null) {
            helpData.put("params", methodHelpData.params().stream().map(p -> {
                HashMap<String, Object> arg = new HashMap<String, Object>();
                arg.put("name", p.name());
                arg.put("type", p.type());
                if (p.values() != null) {
                    arg.put("values", p.values());
                }
                return arg;
            }).toList());
        }
        HashMap<String, Object> returns = new HashMap<String, Object>();
        returns.put("type", methodHelpData.returns().type());
        if (methodHelpData.returns().values() != null) {
            returns.put("values", methodHelpData.returns().values());
        }
        helpData.put("returns", returns);
        if (methodHelpData.description() != null) {
            helpData.put("description", methodHelpData.description());
        }
        return helpData;
    }

    public static Class<?> convertType(Class<?> clazz) {
        if (clazz == UUID.class || clazz == ResourceLocation.class || clazz == Item.class || Enum.class.isAssignableFrom(clazz)) {
            return String.class;
        }
        if (clazz == Frequency.class || clazz == Coord4D.class || clazz == Vec3i.class || clazz == FluidStack.class || clazz == ItemStack.class || clazz == BlockState.class) {
            return Map.class;
        }
        if (ChemicalStack.class.isAssignableFrom(clazz) || IFilter.class.isAssignableFrom(clazz)) {
            return Map.class;
        }
        if (clazz == Convertable.class) {
            return Map.class;
        }
        return clazz;
    }

    private static Map<Class<?>, TableType> getBuiltInTables() {
        HashMap types = new HashMap();
        TableType.builder(Coord4D.class, "An xyz position with a dimension component").addField("x", Integer.TYPE, "The x component", new Class[0]).addField("y", Integer.TYPE, "The y component", new Class[0]).addField("z", Integer.TYPE, "The z component", new Class[0]).addField("dimension", ResourceLocation.class, "The dimension component", new Class[0]).build(types);
        TableType.builder(BlockPos.class, "An xyz position").addField("x", Integer.TYPE, "The x component", new Class[0]).addField("y", Integer.TYPE, "The y component", new Class[0]).addField("z", Integer.TYPE, "The z component", new Class[0]).build(types);
        TableType.builder(ItemStack.class, "A stack of Item(s)").addField("name", Item.class, "The Item's registered name", new Class[0]).addField("count", Integer.TYPE, "The count of items in the stack", new Class[0]).addField("nbt", String.class, "Any NBT of the item, in Command JSON format", new Class[0]).build(types);
        TableType.builder(FluidStack.class, "An amount of fluid").addField("name", ResourceLocation.class, "The Fluid's registered name, e.g. minecraft:water", new Class[0]).addField("amount", Integer.TYPE, "The amount in mB", new Class[0]).addField("nbt", String.class, "Any NBT of the fluid, in Command JSON format", new Class[0]).build(types);
        TableType.builder(ChemicalStack.class, "An amount of Gas/Fluid/Slurry/Pigment").addField("name", Item.class, "The Chemical's registered name", new Class[0]).addField("amount", Integer.TYPE, "The amount in mB", new Class[0]).build(types);
        TableType.builder(BlockState.class, "A Block State").addField("block", String.class, "The Block's registered name, e.g. minecraft:sand", new Class[0]).addField("state", Map.class, "Any state parameters will be in Table format under this key. Not present if there are none", new Class[0]).build(types);
        TableType.builder(Frequency.class, "A frequency's identity").addField("key", String.class, "Usually the name of the frequency entered in the GUI", new Class[0]).addField("public", Boolean.TYPE, "Whether the Frequency is public or not", new Class[0]).build(types);
        TableType.builder(IFilter.class, "Common Filter properties. Use the API Global to make constructing these a little easier.\nFilters are a combination of these base properties, an ItemStack or Mod Id or Tag component, and a device specific type.\nThe exception to that is an Oredictionificator filter, which does not have an item/mod/tag component.").addField("type", FilterType.class, "The type of filter in this structure", new Class[0]).addField("enabled", Boolean.TYPE, "Whether the filter is enabled when added to a device", new Class[0]).build(types);
        TableType.builder(MinerFilter.class, "A Digital Miner filter").extendedFrom(IFilter.class).addField("requiresReplacement", Boolean.TYPE, "Whether the filter requires a replacement to be done before it will allow mining", new Class[0]).addField("replaceTarget", Item.class, "The name of the item block that will be used to replace a mined block", new Class[0]).build(types);
        TableType.builder(OredictionificatorItemFilter.class, "An Oredictionificator filter").extendedFrom(IFilter.class).addField("target", String.class, "The target tag to match (input)", new Class[0]).addField("selected", Item.class, "The selected output item's registered name. Optional for adding a filter", new Class[0]).build(types);
        TableType.builder(SorterFilter.class, "A Logistical Sorter filter").extendedFrom(IFilter.class).addField("allowDefault", Boolean.TYPE, "Allows the filtered item to travel to the default color destination", new Class[0]).addField("color", EnumColor.class, "The color configured, nil if none", new Class[0]).addField("size", Boolean.TYPE, "If Size Mode is enabled", new Class[0]).addField("min", Integer.TYPE, "In Size Mode, the minimum to send", new Class[0]).addField("max", Integer.TYPE, "In Size Mode, the maximum to send", new Class[0]).build(types);
        TableType.builder(QIOFilter.class, "A Quantum Item Orchestration filter").extendedFrom(IFilter.class).build(types);
        BaseComputerHelper.buildFilterVariants(types, SorterFilter.class, SorterItemStackFilter.class, SorterModIDFilter.class, SorterTagFilter.class, "Logistical Sorter", true);
        BaseComputerHelper.buildFilterVariants(types, MinerFilter.class, MinerItemStackFilter.class, MinerModIDFilter.class, MinerTagFilter.class, "Digital Miner", false);
        BaseComputerHelper.buildFilterVariants(types, QIOFilter.class, QIOItemStackFilter.class, QIOModIDFilter.class, QIOTagFilter.class, "QIO", true);
        return types;
    }

    private static <BASE> void buildFilterVariants(Map<Class<?>, TableType> types, Class<BASE> deviceFilterType, Class<? extends BASE> itemStackFilterClass, Class<? extends BASE> modIDFilterClass, Class<? extends BASE> tagFilterClass, String deviceName, boolean hasFuzzyItem) {
        TableType.Builder itemstackBuilder = TableType.builder(itemStackFilterClass, deviceName + " filter with ItemStack filter properties").extendedFrom(deviceFilterType).addField("item", Item.class, "The filtered item's registered name", new Class[0]).addField("itemNBT", String.class, "The NBT data of the filtered item, optional", new Class[0]);
        if (hasFuzzyItem) {
            itemstackBuilder.addField("fuzzy", Boolean.TYPE, "Whether Fuzzy mode is enabled (checks only the item name/type)", new Class[0]);
        }
        itemstackBuilder.build(types);
        TableType.builder(modIDFilterClass, deviceName + " filter with Mod Id filter properties").extendedFrom(deviceFilterType).addField("modId", String.class, "The mod id to filter. e.g. mekansim", new Class[0]).build(types);
        TableType.builder(tagFilterClass, deviceName + " filter with Tag filter properties").extendedFrom(deviceFilterType).addField("tag", String.class, "The tag to filter. e.g. forge:ores", new Class[0]).build(types);
    }
}

