/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.tab.GuiConfigTypeTab;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.to_server.PacketConfigurationUpdate;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class GuiSideConfiguration<TILE extends TileEntityMekanism>
extends GuiWindow {
    private final List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();
    private final Map<RelativeSide, SideDataButton> sideConfigButtons = new EnumMap<RelativeSide, SideDataButton>(RelativeSide.class);
    private final MekanismButton ejectButton;
    private final TILE tile;
    private TransmissionType currentType;

    public GuiSideConfiguration(IGuiWrapper gui, int x, int y, TILE tile) {
        super(gui, x, y, 156, 135, SelectedWindowData.WindowType.SIDE_CONFIG);
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        List<TransmissionType> transmissions = ((ISideConfiguration)this.tile).getConfig().getTransmissions();
        this.setCurrentType(transmissions.get(0));
        this.addChild(new GuiInnerScreen(gui, this.relativeX + 41, this.relativeY + 25, 74, 12, () -> {
            ConfigInfo config = this.getCurrentConfig();
            if (config == null || !config.canEject()) {
                return Collections.singletonList(MekanismLang.NO_EJECT.translate(new Object[0]));
            }
            return Collections.singletonList(MekanismLang.EJECT.translate(BooleanStateDisplay.OnOff.of(config.isEjecting())));
        }).tooltip(() -> {
            ConfigInfo config = this.getCurrentConfig();
            if (config == null || !config.canEject()) {
                return Collections.singletonList(MekanismLang.CANT_EJECT_TOOLTIP.translate(new Object[0]));
            }
            return Collections.emptyList();
        }));
        for (int i = 0; i < transmissions.size(); ++i) {
            GuiConfigTypeTab tab = new GuiConfigTypeTab(gui, transmissions.get(i), this.relativeX + (i < 4 ? -26 : this.f_93618_), this.relativeY + (2 + 28 * (i % 4)), this, i < 4);
            this.addChild(tab);
            this.configTabs.add(tab);
        }
        this.ejectButton = this.addChild(new MekanismImageButton(gui, this.relativeX + 136, this.relativeY + 6, 14, this.getButtonLocation("auto_eject"), () -> Mekanism.packetHandler().sendToServer(new PacketConfigurationUpdate(PacketConfigurationUpdate.ConfigurationPacket.EJECT, this.tile.m_58899_(), this.currentType)), this.getOnHover(MekanismLang.AUTO_EJECT)));
        this.addChild(new MekanismImageButton(gui, this.relativeX + 136, this.relativeY + 95, 14, this.getButtonLocation("clear_sides"), () -> Mekanism.packetHandler().sendToServer(new PacketConfigurationUpdate(PacketConfigurationUpdate.ConfigurationPacket.CLEAR_ALL, this.tile.m_58899_(), this.currentType)), this.getOnHover(MekanismLang.SIDE_CONFIG_CLEAR)));
        this.addSideDataButton(RelativeSide.BOTTOM, 68, 92);
        this.addSideDataButton(RelativeSide.TOP, 68, 46);
        this.addSideDataButton(RelativeSide.FRONT, 68, 69);
        this.addSideDataButton(RelativeSide.BACK, 45, 92);
        this.addSideDataButton(RelativeSide.LEFT, 45, 69);
        this.addSideDataButton(RelativeSide.RIGHT, 91, 69);
        this.updateTabs();
        ((MekanismContainer)((GuiMekanism)this.gui()).m_6262_()).startTracking(1, ((ISideConfiguration)this.tile).getConfig());
        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_SIDE_CONFIG, (BlockEntity)tile, 1));
    }

    private void addSideDataButton(RelativeSide side, int xPos, int yPos) {
        this.sideConfigButtons.put(side, this.addChild(new SideDataButton(this.gui(), this.relativeX + xPos, this.relativeY + yPos, side, () -> ((ISideConfiguration)this.tile).getConfig().getDataType(this.currentType, side), () -> {
            DataType dataType = ((ISideConfiguration)this.tile).getConfig().getDataType(this.currentType, side);
            return dataType == null ? EnumColor.GRAY : dataType.getColor();
        }, (TileEntityMekanism)this.tile, () -> this.currentType, PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, this.getOnHover(side))));
    }

    @Override
    public void close() {
        super.close();
        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (BlockEntity)this.tile, 1));
        ((MekanismContainer)((GuiMekanism)this.gui()).m_6262_()).stopTracking(1);
    }

    private GuiElement.IHoverable getOnHover(RelativeSide side) {
        return (onHover, guiGraphics, mouseX, mouseY) -> {
            SideDataButton button;
            DataType dataType;
            if (onHover instanceof SideDataButton && (dataType = (button = (SideDataButton)onHover).getDataType()) != null) {
                this.displayTooltips(guiGraphics, mouseX, mouseY, new Component[]{MekanismLang.GENERIC_WITH_TWO_PARENTHESIS.translateColored(dataType.getColor(), dataType, dataType.getColor().getName(), side)});
            }
        };
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    @Nullable
    private ConfigInfo getCurrentConfig() {
        return ((ISideConfiguration)this.tile).getConfig().getConfig(this.currentType);
    }

    public void updateTabs() {
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.f_93624_ = this.currentType != tab.getTransmissionType();
        }
        ConfigInfo config = this.getCurrentConfig();
        if (config == null) {
            this.ejectButton.f_93623_ = false;
            for (SideDataButton sideDataButton : this.sideConfigButtons.values()) {
                sideDataButton.f_93623_ = false;
            }
        } else {
            this.ejectButton.f_93623_ = config.canEject();
            for (Map.Entry entry : this.sideConfigButtons.entrySet()) {
                ((SideDataButton)entry.getValue()).f_93623_ = config.isSideEnabled((RelativeSide)entry.getKey());
            }
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.CONFIG_TYPE.translate(this.currentType), 5.0f);
        this.drawCenteredText(guiGraphics, (Component)MekanismLang.SLOTS.translate(new Object[0]), this.relativeX + 80, this.relativeY + 120, this.subheadingTextColor());
    }

    @Override
    protected int getTitlePadEnd() {
        return super.getTitlePadEnd() + 15;
    }
}

