/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.ftbchunks.FTBChunksProtectionCheck;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentHolder;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.EnergyCounter;
import com.yogpc.qp.machines.InvUtils;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.TraceQuarryWork;
import com.yogpc.qp.machines.advquarry.AdvQuarry;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.AdvQuarryMenu;
import com.yogpc.qp.machines.advquarry.BlockAdvQuarry;
import com.yogpc.qp.machines.advquarry.WorkConfig;
import com.yogpc.qp.machines.module.ContainerQuarryModule;
import com.yogpc.qp.machines.module.FilterModule;
import com.yogpc.qp.machines.module.ModuleInventory;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.machines.module.QuarryModuleProvider;
import com.yogpc.qp.machines.module.ReplacerModule;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.CacheEntry;
import com.yogpc.qp.utils.MapMulti;
import com.yogpc.qp.utils.MapStreamSyntax;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class TileAdvQuarry
extends PowerTile
implements CheckerLog,
ModuleInventory.HasModuleInventory,
MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
ClientSync,
MenuProvider,
PowerConfig.Provider {
    private final ModuleInventory moduleInventory = new ModuleInventory(5, this::updateModule, TileAdvQuarry::moduleFilter, (ModuleInventory.HasModuleInventory)this);
    private Set<QuarryModule> modules = Set.of();
    private boolean isBlockModuleLoaded = false;
    private final MachineStorage storage = new MachineStorage();
    WorkConfig workConfig = new WorkConfig(true, true, false);
    private final QuarryCache cache = new QuarryCache();
    private ItemConverter itemConverter;
    public int digMinY;
    @Nullable
    private Area area = null;
    private List<EnchantmentLevel> enchantments = List.of();
    private AdvQuarryAction action = AdvQuarryAction.Waiting.WAITING;

    public TileAdvQuarry(BlockPos pos, BlockState state) {
        super(Holder.ADV_QUARRY_TYPE, pos, state);
        this.itemConverter = this.createConverter();
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("%sArea:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.area), "%sAction:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.action), "%sRemoveBedrock:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.hasBedrockModule()), "%sDigMinY:%s %d".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.digMinY), this.workConfig.toString().replace("WorkConfig", ChatFormatting.GREEN + "WorkConfig: " + ChatFormatting.RESET), "%sModules:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.modules), "%sCurrentWorkProgress:%s %.2f".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.xzProgress()), this.energyString()).map(Component::m_237113_).toList();
    }

    private double xzProgress() {
        return this.action.getProgress(this);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileAdvQuarry quarry) {
        if (!quarry.isBlockModuleLoaded) {
            quarry.updateModule();
            quarry.isBlockModuleLoaded = true;
        }
        if (quarry.hasEnoughEnergy()) {
            for (int i = 0; i < quarry.getRepeatWorkCount(); ++i) {
                quarry.action.tick(world, pos, state, quarry);
            }
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.area != null) {
            int bottom = this.f_58857_ == null ? 0 : this.f_58857_.m_141937_();
            return new AABB((double)this.area.minX(), (double)bottom, (double)this.area.minZ(), (double)this.area.maxX(), (double)this.area.maxY(), (double)this.area.maxZ());
        }
        return new AABB(this.m_58899_(), this.m_58899_().m_7918_(1, 1, 1));
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        nbt.m_128365_("moduleInventory", (Tag)this.moduleInventory.serializeNBT());
        nbt.m_128365_("storage", (Tag)this.storage.toNbt());
        this.toClientTag(nbt);
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.moduleInventory.deserializeNBT(nbt.m_128469_("moduleInventory"));
        this.storage.readNbt(nbt.m_128469_("storage"));
        this.fromClientTag(nbt);
        this.isBlockModuleLoaded = false;
    }

    @Override
    public CompoundTag toClientTag(CompoundTag nbt) {
        if (this.area != null) {
            nbt.m_128365_("area", (Tag)this.area.toNBT());
        }
        nbt.m_128365_("workConfig", (Tag)this.workConfig.toNbt());
        CompoundTag enchantments = new CompoundTag();
        this.enchantments.forEach(e -> enchantments.m_128405_(Objects.requireNonNull(e.enchantmentID()).toString(), e.level()));
        nbt.m_128365_("enchantments", (Tag)enchantments);
        nbt.m_128405_("digMinY", this.digMinY);
        nbt.m_128365_("action", (Tag)this.action.toNbt());
        return nbt;
    }

    @Override
    public void fromClientTag(CompoundTag nbt) {
        this.area = Area.fromNBT(nbt.m_128469_("area")).orElse(null);
        this.workConfig = new WorkConfig(nbt.m_128469_("workConfig"));
        CompoundTag enchantments = nbt.m_128469_("enchantments");
        this.setEnchantments(enchantments.m_128431_().stream().mapMulti(MapMulti.getEntry(ForgeRegistries.ENCHANTMENTS, arg_0 -> ((CompoundTag)enchantments).m_128451_(arg_0))).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
        this.digMinY = nbt.m_128451_("digMinY");
        this.action = AdvQuarryAction.fromNbt(nbt.m_128469_("action"), this);
    }

    public void setEnchantments(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
        this.cache.enchantments.expire();
        this.setMaxEnergy(this.getPowerConfig().maxEnergy() * (long)(this.efficiencyLevel() + 1));
    }

    void initialSetting() {
        if (this.f_58857_ != null) {
            this.digMinY = this.f_58857_.m_141937_();
        }
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    boolean setArea(Area newArea) {
        if (!newArea.isRangeInLimit((Integer)QuarryPlus.config.common.chunkDestroyerLimit.get(), true)) {
            AdvQuarry.LOGGER.info(AdvQuarry.TILE, "Area is too bigger than limit value in config. Area={}, Limit={}", (Object)newArea, QuarryPlus.config.common.chunkDestroyerLimit.get());
            return false;
        }
        this.area = newArea;
        PacketHandler.sendToClient(new ClientSyncMessage(this), Objects.requireNonNull(this.m_58904_()));
        this.cache.isProtectedByFTB.expire();
        if (this.cache.isProtectedByFTB.getValue(this.m_58904_()).booleanValue()) {
            AdvQuarry.LOGGER.info(AdvQuarry.TILE, "Area contains protected chunks. Quarry has stopped.");
        }
        return true;
    }

    public AdvQuarryAction getAction() {
        return this.action;
    }

    void setAction(AdvQuarryAction action) {
        AdvQuarryAction pre = this.action;
        if (this.action == AdvQuarryAction.Waiting.WAITING && this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockAdvQuarry.WORKING, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.action = action;
        TraceQuarryWork.changeTarget(this, this.m_58899_(), "From %s to %s".formatted(pre, action));
        if (action == AdvQuarryAction.Finished.FINISHED && this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockAdvQuarry.WORKING, (Comparable)Boolean.valueOf(false)), 3);
            this.logUsage();
            TraceQuarryWork.finishWork(this, this.m_58899_(), this.getEnergyStored());
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.f_58857_);
            QuarryPlus.LOGGER.debug("ChunkDestroyer({}) State changed from {} to {}.", (Object)this.m_58899_(), (Object)pre, (Object)action);
        }
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantments;
    }

    public boolean canStartWork() {
        return this.area != null && this.cache.isProtectedByFTB.getValue(this.m_58904_()) == false && this.workConfig.startImmediately();
    }

    public boolean canBreak(Level targetWorld, BlockPos targetPos, BlockState state) {
        boolean unbreakable;
        if (state.m_60795_()) {
            return true;
        }
        boolean bl = unbreakable = state.m_60800_((BlockGetter)targetWorld, targetPos) < 0.0f;
        if (unbreakable) {
            if (this.hasBedrockModule() && state.m_60734_() == Blocks.f_50752_) {
                return !targetWorld.m_46472_().equals((Object)Level.f_46430_);
            }
            return false;
        }
        if (!targetWorld.m_6425_(targetPos).m_76178_()) {
            return true;
        }
        return this.getReplacementState() != state;
    }

    BlockState getReplacementState() {
        return this.cache.replaceState.getValue(this.f_58857_);
    }

    @Override
    public ModuleInventory getModuleInventory() {
        return this.moduleInventory;
    }

    void updateModule() {
        Set blockModules = this.f_58857_ != null ? QuarryModuleProvider.Block.getModulesInWorld(this.f_58857_, this.m_58899_()) : Collections.emptySet();
        List<QuarryModule> itemModules = this.moduleInventory.getModules();
        this.modules = Stream.concat(blockModules.stream(), itemModules.stream()).collect(Collectors.toSet());
        this.itemConverter = this.createConverter();
    }

    static boolean moduleFilter(QuarryModule module) {
        return module != QuarryModule.Constant.PUMP;
    }

    @Override
    public Set<QuarryModule> getLoadedModules() {
        return this.modules;
    }

    ItemConverter createConverter() {
        ItemConverter defaultConverter = ItemConverter.defaultConverter().combined(ItemConverter.advQuarryConverter());
        return this.getFilterModules().map(FilterModule::createConverter).reduce(defaultConverter, ItemConverter::combined);
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    public AdvQuarryMenu createMenu(int id, Inventory p, Player player) {
        return new AdvQuarryMenu(id, player, this.m_58899_());
    }

    public ServerLevel getTargetWorld() {
        return (ServerLevel)this.f_58857_;
    }

    public BreakResult breakOneBlock(BlockPos targetPos, boolean requireEnergy) {
        ServerLevel targetWorld = this.getTargetWorld();
        ItemStack pickaxe = this.getPickaxe();
        FakePlayer fakePlayer = QuarryFakePlayer.get(targetWorld);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, pickaxe);
        BlockState state = targetWorld.m_8055_(targetPos);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((Level)targetWorld, targetPos, state, (Player)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            TraceQuarryWork.blockRemoveFailed(this, this.m_58899_(), targetPos, state, BreakResult.FAIL_EVENT, new Object[0]);
            return BreakResult.FAIL_EVENT;
        }
        if (state.m_60795_() || !this.canBreak((Level)targetWorld, targetPos, state)) {
            TraceQuarryWork.blockRemoveFailed(this, this.m_58899_(), targetPos, state, BreakResult.SKIPPED, new Object[0]);
            return BreakResult.SKIPPED;
        }
        float hardness = state.m_60800_((BlockGetter)targetWorld, targetPos);
        long requiredEnergy = PowerManager.getBreakEnergy(hardness, this);
        if (requireEnergy && !this.useEnergy(requiredEnergy, PowerTile.Reason.BREAK_BLOCK, false)) {
            TraceQuarryWork.blockRemoveFailed(this, this.m_58899_(), targetPos, state, BreakResult.NOT_ENOUGH_ENERGY, Map.of("required", EnergyCounter.formatEnergyInFE(requiredEnergy), "has", EnergyCounter.formatEnergyInFE(this.getEnergy())));
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        List<ItemStack> drops = InvUtils.getBlockDrops(state, targetWorld, targetPos, targetWorld.m_7702_(targetPos), (Entity)fakePlayer, pickaxe);
        TraceQuarryWork.blockRemoveSucceed((PowerTile)this, this.m_58899_(), targetPos, state, drops, breakEvent.getExpToDrop());
        drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
        targetWorld.m_7731_(targetPos, this.getReplacementState(), 3);
        if (breakEvent.getExpToDrop() > 0) {
            this.getExpModule().ifPresent(e -> {
                if (requireEnergy) {
                    this.useEnergy(PowerManager.getExpCollectEnergy(breakEvent.getExpToDrop(), this), PowerTile.Reason.EXP_COLLECT, true);
                }
                e.addExp(breakEvent.getExpToDrop());
            });
        }
        this.m_6596_();
        return BreakResult.SUCCESS;
    }

    BreakResult breakBlocks(int x, int z) {
        ServerLevel targetWorld = this.getTargetWorld();
        ItemStack pickaxe = this.getPickaxe();
        FakePlayer fakePlayer = QuarryFakePlayer.get(targetWorld);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, pickaxe);
        AABB aabb = new AABB((double)(x - 5), (double)(this.digMinY - 5), (double)(z - 5), (double)(x + 5), (double)(this.m_58899_().m_123342_() - 1), (double)(z + 5));
        targetWorld.m_6443_(ItemEntity.class, aabb, Predicate.not(i -> i.m_32055_().m_41619_())).forEach(i -> {
            this.storage.addItem(i.m_32055_());
            i.m_6074_();
        });
        this.getExpModule().ifPresent(e -> targetWorld.m_6443_(ExperienceOrb.class, aabb, EntitySelector.f_20402_).forEach(orb -> {
            e.addExp(orb.m_20801_());
            orb.m_6074_();
        }));
        this.removeEdgeFluid(x, z, targetWorld);
        long requiredEnergy = 0L;
        AtomicInteger exp = new AtomicInteger(0);
        ArrayList<Pair> toBreak = new ArrayList<Pair>();
        ArrayList<Pair> toDrain = new ArrayList<Pair>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, 0, z);
        for (int y = this.m_58899_().m_123342_() - 1; y > this.digMinY; --y) {
            mutableBlockPos.m_142448_(y);
            BlockState state = targetWorld.m_8055_((BlockPos)mutableBlockPos);
            FluidState fluidState = targetWorld.m_6425_((BlockPos)mutableBlockPos);
            if (fluidState.m_76178_()) {
                if (state.m_60795_()) continue;
                if (!this.canBreak((Level)targetWorld, (BlockPos)mutableBlockPos, state)) {
                    if (state.m_60734_() != Blocks.f_50142_) continue;
                    targetWorld.m_7471_((BlockPos)mutableBlockPos, false);
                    continue;
                }
                BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((Level)targetWorld, (BlockPos)mutableBlockPos, state, (Player)fakePlayer);
                MinecraftForge.EVENT_BUS.post((Event)breakEvent);
                if (breakEvent.isCanceled()) {
                    TraceQuarryWork.blockRemoveFailed(this, this.m_58899_(), (BlockPos)mutableBlockPos, state, BreakResult.FAIL_EVENT, new Object[0]);
                    continue;
                }
                exp.getAndAdd(breakEvent.getExpToDrop());
                float hardness = state.m_60800_((BlockGetter)targetWorld, (BlockPos)mutableBlockPos);
                long energy = PowerManager.getBreakEnergy(hardness, this);
                requiredEnergy += energy;
                toBreak.add(Pair.of((Object)mutableBlockPos.m_7949_(), (Object)state));
                continue;
            }
            long energy = PowerManager.getBreakBlockFluidEnergy(this);
            requiredEnergy += energy;
            toDrain.add(Pair.of((Object)mutableBlockPos.m_7949_(), (Object)state));
        }
        if (toBreak.isEmpty() && toDrain.isEmpty()) {
            return BreakResult.SKIPPED;
        }
        this.useEnergy(requiredEnergy, PowerTile.Reason.BREAK_BLOCK, true);
        if (!toDrain.isEmpty()) {
            TraceQuarryWork.progress(this, this.m_58899_(), (BlockPos)((Pair)toDrain.get(0)).getKey(), "Remove %d fluids".formatted(toDrain.size()));
        }
        for (Pair pair : toDrain) {
            BlockState state;
            Block energy = ((BlockState)pair.getRight()).m_60734_();
            if (energy instanceof BucketPickup) {
                BucketPickup fluidBlock = (BucketPickup)energy;
                ItemStack bucketItem = fluidBlock.m_142598_((LevelAccessor)targetWorld, (BlockPos)pair.getLeft(), (BlockState)pair.getRight());
                this.storage.addFluid(bucketItem);
            }
            if (!(state = targetWorld.m_8055_((BlockPos)pair.getLeft())).m_60795_() && this.canBreak((Level)targetWorld, (BlockPos)pair.getLeft(), state)) {
                this.breakOneBlock((BlockPos)pair.getLeft(), false);
            }
            targetWorld.m_7731_((BlockPos)pair.getLeft(), Holder.BLOCK_DUMMY.m_49966_(), 18);
        }
        Map<ItemKey, Long> drops = toBreak.stream().flatMap(p -> InvUtils.getBlockDrops((BlockState)p.getRight(), targetWorld, (BlockPos)p.getLeft(), targetWorld.m_7702_((BlockPos)p.getLeft()), (Entity)fakePlayer, pickaxe).stream()).map(this.itemConverter::mapToKey).map(MapStreamSyntax.values(Long::valueOf)).collect(MapStreamSyntax.entryToMap(Long::sum));
        BlockPos headPos = toBreak.stream().map(Pair::getKey).findFirst().orElse((BlockPos)mutableBlockPos);
        List<BlockState> states = toBreak.stream().map(Pair::getValue).toList();
        TraceQuarryWork.blockRemoveSucceed((PowerTile)this, this.m_58899_(), headPos, states, drops, exp.get());
        this.storage.addAllItems(drops);
        toBreak.stream().map(Pair::getLeft).forEach(p -> targetWorld.m_7731_(p, this.getReplacementState(), 18));
        if (exp.get() > 0) {
            this.getExpModule().ifPresent(e -> {
                this.useEnergy(PowerManager.getExpCollectEnergy(exp.get(), this), PowerTile.Reason.EXP_COLLECT, true);
                e.addExp(exp.get());
            });
        }
        this.m_6596_();
        return BreakResult.SUCCESS;
    }

    void removeEdgeFluid(int x, int z, ServerLevel targetWorld) {
        boolean flagMaxZ;
        assert (this.area != null);
        boolean flagMinX = x - 1 == this.area.minX();
        boolean flagMaxX = x + 1 == this.area.maxX();
        boolean flagMinZ = z - 1 == this.area.minZ();
        boolean bl = flagMaxZ = z + 1 == this.area.maxZ();
        if (flagMinX) {
            this.removeFluidAtXZ(this.area.minX(), z, targetWorld);
        }
        if (flagMaxX) {
            this.removeFluidAtXZ(this.area.maxX(), z, targetWorld);
        }
        if (flagMinZ) {
            this.removeFluidAtXZ(x, this.area.minZ(), targetWorld);
        }
        if (flagMaxZ) {
            this.removeFluidAtXZ(x, this.area.maxZ(), targetWorld);
        }
        if (flagMinX && flagMinZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.minZ(), targetWorld);
        }
        if (flagMinX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.maxZ(), targetWorld);
        }
        if (flagMaxX && flagMinZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.minZ(), targetWorld);
        }
        if (flagMaxX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.maxZ(), targetWorld);
        }
    }

    void removeFluidAtXZ(int x, int z, ServerLevel world) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, 0, z);
        for (int y = this.m_58899_().m_123342_() - 1; y > this.digMinY; --y) {
            pos.m_142448_(y);
            FluidState fluidState = world.m_6425_((BlockPos)pos);
            if (fluidState.m_76178_()) continue;
            BlockState state = world.m_8055_((BlockPos)pos);
            Block block = state.m_60734_();
            if (block instanceof BucketPickup) {
                BucketPickup fluidBlock = (BucketPickup)block;
                this.useEnergy(PowerManager.getBreakBlockFluidEnergy(this), PowerTile.Reason.REMOVE_FLUID, true);
                ItemStack bucketItem = fluidBlock.m_142598_((LevelAccessor)world, (BlockPos)pos, state);
                this.storage.addFluid(bucketItem);
                if (!world.m_8055_((BlockPos)pos).m_60795_() && (!(fluidBlock instanceof LiquidBlock) || fluidState.m_76170_())) continue;
                world.m_7731_((BlockPos)pos, Holder.BLOCK_FRAME.getDammingState(), 3);
                continue;
            }
            if (!(state.m_60734_() instanceof LiquidBlockContainer)) continue;
            float hardness = state.m_60800_((BlockGetter)world, (BlockPos)pos);
            this.useEnergy(PowerManager.getBreakEnergy(hardness, this), PowerTile.Reason.REMOVE_FLUID, true);
            List<ItemStack> drops = InvUtils.getBlockDrops(state, world, (BlockPos)pos, world.m_7702_((BlockPos)pos), null, this.getPickaxe());
            drops.forEach(this.storage::addItem);
            world.m_7731_((BlockPos)pos, Holder.BLOCK_FRAME.getDammingState(), 3);
        }
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    void openModuleGui(ServerPlayer player) {
        ContainerQuarryModule.InteractionObject.openScreen(this, player, this.m_5446_());
    }

    @Override
    public int efficiencyLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).efficiency();
    }

    @Override
    public int unbreakingLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).unbreaking();
    }

    @Override
    public int fortuneLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).fortune();
    }

    @Override
    public int silktouchLevel() {
        return this.cache.enchantments.getValue(this.m_58904_()).silktouch();
    }

    private class QuarryCache {
        final CacheEntry<BlockState> replaceState = CacheEntry.supplierCache(5L, () -> TileAdvQuarry.this.getReplacerModule().map(ReplacerModule::getState).orElse(Blocks.f_50016_.m_49966_()));
        final CacheEntry<Integer> netherTop;
        final CacheEntry<EnchantmentHolder> enchantments;
        final CacheEntry<Boolean> isProtectedByFTB;

        public QuarryCache() {
            this.netherTop = CacheEntry.supplierCache(100L, QuarryPlus.config.common.netherTop);
            this.enchantments = CacheEntry.supplierCache(1000L, () -> EnchantmentHolder.makeHolder(TileAdvQuarry.this));
            this.isProtectedByFTB = CacheEntry.supplierCache(6000L, () -> TileAdvQuarry.this.area != null && FTBChunksProtectionCheck.isAreaProtected(TileAdvQuarry.this.area.shrink(1, 0, 1), (ResourceKey<Level>)TileAdvQuarry.this.getTargetWorld().m_46472_()));
        }
    }
}

