/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.machines.PowerTile;
import java.net.URI;
import java.security.SecureClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.Nullable;

public final class TraceQuarryWork {
    public static final boolean enabled = (Boolean)QuarryPlus.config.common.logAllQuarryWork.get();
    private static final LoggerContext CONTEXT;
    private static final Logger LOGGER;
    private static final Marker MARKER;

    public static void startWork(PowerTile tile, BlockPos pos, int energyInMachine) {
        if (enabled) {
            LOGGER.info(MARKER, "{} Started work with {} FE", (Object)TraceQuarryWork.header(tile, pos), (Object)energyInMachine);
        }
    }

    public static void changeTarget(PowerTile tile, BlockPos pos, String state) {
        if (enabled) {
            LOGGER.debug(MARKER, "{} Target changed in {}", (Object)TraceQuarryWork.header(tile, pos), (Object)state);
        }
    }

    public static void progress(PowerTile tile, BlockPos pos, BlockPos targetPos, String reason) {
        if (enabled) {
            LOGGER.debug(MARKER, "{} ({},{},{}) {}", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)reason);
        }
    }

    public static void canBreakCheck(PowerTile tile, BlockPos pos, BlockPos targetPos, BlockState state, String detail) {
        if (enabled) {
            LOGGER.info(MARKER, "{} ({},{},{}) {} State({})", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)detail, (Object)state);
        }
    }

    public static void blockRemoveFailed(PowerTile tile, BlockPos pos, BlockPos targetPos, BlockState state, BreakResult breakResult, Object ... additional) {
        if (enabled) {
            LOGGER.info(MARKER, "{} ({},{},{}) {} {} {}", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)breakResult, (Object)state, (Object)additional);
        }
    }

    public static void blockRemoveSucceed(PowerTile tile, BlockPos pos, BlockPos targetPos, BlockState state, List<ItemStack> drops, int exp) {
        if (enabled) {
            LOGGER.debug(MARKER, "{} ({},{},{}) SUCCESS {} EXP={} ({})", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), (Object)state, (Object)exp, (Object)drops.stream().map(s -> "%dx %s".formatted(s.m_41613_(), ForgeRegistries.ITEMS.getKey((Object)s.m_41720_()))).collect(Collectors.joining(",")));
        }
    }

    public static void blockRemoveSucceed(PowerTile tile, BlockPos pos, BlockPos targetPos, List<BlockState> state, Map<ItemKey, Long> drops, int exp) {
        if (enabled) {
            Map stateCount = state.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            LOGGER.debug(MARKER, "{} ({},{},{}) SUCCESS {} EXP={} ({})", (Object)TraceQuarryWork.header(tile, pos), (Object)targetPos.m_123341_(), (Object)targetPos.m_123342_(), (Object)targetPos.m_123343_(), stateCount, (Object)exp, (Object)drops.entrySet().stream().map(s -> "%dx %s".formatted(s.getValue(), ((ItemKey)s.getKey()).getId())).collect(Collectors.joining(",")));
        }
    }

    public static void unexpected(PowerTile tile, BlockPos pos, String reason) {
        if (enabled) {
            LOGGER.warn(MARKER, "{} {}", (Object)TraceQuarryWork.header(tile, pos), (Object)reason);
        }
    }

    public static void finishWork(PowerTile tile, BlockPos pos, int energyInMachine) {
        if (enabled) {
            LOGGER.info(MARKER, "{} Finished work with {} FE", (Object)TraceQuarryWork.header(tile, pos), (Object)energyInMachine);
        }
    }

    public static void convertItem(ItemKey before, ItemKey after) {
        if (enabled) {
            LOGGER.debug(MARKER, "Convert {} to {}", (Object)before, (Object)after);
        }
    }

    public static void transferItem(@Nullable BlockEntity from, @Nullable IItemHandler dest, ItemKey itemKey, int count) {
        if (enabled) {
            String header = from != null ? TraceQuarryWork.header(from, from.m_58899_()) : "ItemHandler Extraction";
            LOGGER.debug(MARKER, "{} Transfer {}x {} to {}", (Object)header, (Object)count, (Object)itemKey, (Object)dest);
        }
    }

    public static void transferFluid(@Nullable BlockEntity from, @Nullable IFluidHandler dest, FluidKey fluidKey, int amount) {
        if (enabled) {
            String header = from != null ? TraceQuarryWork.header(from, from.m_58899_()) : "FluidHandler Extraction";
            LOGGER.debug(MARKER, "{} Transfer {}mB of {} to {}", (Object)header, (Object)amount, (Object)fluidKey, (Object)dest);
        }
    }

    public static void noDrops(BlockState state, BlockPos pos, ItemStack tool) {
        if (enabled) {
            LOGGER.debug("{} at ({},{},{}) has no drops with {}", (Object)state, (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_(), (Object)tool);
        }
    }

    private static String header(BlockEntity tile, BlockPos pos) {
        return "[%s(%d,%d,%d)]".formatted(tile.getClass().getSimpleName(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    static {
        if (enabled) {
            class DummyClassLoader
            extends SecureClassLoader {
                DummyClassLoader() {
                }
            }
            CONTEXT = Configurator.initialize((String)"quarryplus-config", (ClassLoader)new DummyClassLoader(), (URI)URI.create(Objects.requireNonNull(TraceQuarryWork.class.getResource("/quarry-log4j2.xml")).toString()));
            LOGGER = CONTEXT.getLogger("TQW");
            MARKER = MarkerManager.getMarker((String)"QUARRY_TRACE");
        } else {
            CONTEXT = null;
            LOGGER = null;
            MARKER = null;
        }
    }
}

