/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.yogpc.qp.ClientConfig;
import com.yogpc.qp.Config;
import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlusClient;
import com.yogpc.qp.ServerConfig;
import com.yogpc.qp.machines.workbench.EnableCondition;
import com.yogpc.qp.machines.workbench.EnchantmentIngredient;
import com.yogpc.qp.machines.workbench.QuarryDebugCondition;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.ConfigCommand;
import java.lang.reflect.Field;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.VisibleForTesting;

@Mod(value="quarryplus")
public class QuarryPlus {
    public static final String Mod_Name = "QuarryPlus";
    public static final String modID = "quarryplus";
    public static final Logger LOGGER = QuarryPlus.getLogger("QuarryPlus");
    public static Config config;
    public static ClientConfig clientConfig;
    public static ServerConfig serverConfig;

    public QuarryPlus() {
        QuarryPlus.registerConfig(false);
        FMLJavaModLoadingContext.get().getModEventBus().register(Register.class);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> QuarryPlusClient::registerClientBus);
        MinecraftForge.EVENT_BUS.register(ConfigCommand.class);
    }

    @VisibleForTesting
    static void registerConfig(boolean inJUnitTest) {
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder client = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        config = new Config(common);
        clientConfig = new ClientConfig(client);
        serverConfig = new ServerConfig(server);
        ForgeConfigSpec build = common.build();
        ForgeConfigSpec clientBuild = client.build();
        ForgeConfigSpec serverBuild = server.build();
        if (inJUnitTest || ForgeGameTestHooks.isGametestServer()) {
            CommentedConfig commentedConfig = CommentedConfig.inMemory();
            build.correct(commentedConfig);
            build.acceptConfig(commentedConfig);
            QuarryPlus.config.common.enableChunkLoader.set((Object)false);
            QuarryPlus.config.common.logAllQuarryWork.set((Object)false);
            CommentedConfig clientConfig = CommentedConfig.inMemory();
            clientBuild.correct(clientConfig);
            clientBuild.acceptConfig(clientConfig);
            CommentedConfig serverConfig = CommentedConfig.inMemory();
            serverBuild.correct(serverConfig);
            serverBuild.acceptConfig(serverConfig);
        } else {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)build);
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientBuild);
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverBuild);
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return QuarryPlus.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        try {
            Field field = Class.forName("net.minecraftforge.fml.ModLoader").getDeclaredField("LOGGER");
            field.setAccessible(true);
            org.apache.logging.log4j.core.Logger loaderLogger = (org.apache.logging.log4j.core.Logger)field.get(null);
            return loaderLogger.getContext().getLogger(name);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can't access to LOGGER in loader.", e);
        }
    }

    public static class Register {
        @SubscribeEvent
        public static void registerAll(RegisterEvent event) {
            event.register(Registries.f_256747_, Register::registerBlocks);
            event.register(Registries.f_256913_, Register::registerItems);
            event.register(Registries.f_256922_, Register::registerTiles);
            event.register(Registries.f_256798_, Register::registerContainers);
            event.register(Registries.f_256764_, Register::registerRecipe);
            event.register(Registries.f_256954_, Register::registerRecipeType);
            event.register(Registries.f_279569_, Register::registerCreativeTab);
            event.register(Registries.f_256982_, Register::registerArgument);
        }

        public static void registerBlocks(RegisterEvent.RegisterHelper<Block> blockRegisterHelper) {
            Holder.blocks().forEach(Holder.NamedEntry.register(blockRegisterHelper));
            blockRegisterHelper.register(Holder.BLOCK_DUMMY.location, (Object)Holder.BLOCK_DUMMY);
            blockRegisterHelper.register(Holder.BLOCK_DUMMY_REPLACER.location, (Object)Holder.BLOCK_DUMMY_REPLACER);
        }

        public static void registerItems(RegisterEvent.RegisterHelper<Item> helper) {
            Holder.items().forEach(Holder.NamedEntry.register(helper));
            helper.register(Holder.BLOCK_DUMMY.location, (Object)Holder.BLOCK_DUMMY.blockItem);
            helper.register(Holder.BLOCK_DUMMY_REPLACER.location, (Object)Holder.BLOCK_DUMMY_REPLACER.blockItem);
        }

        public static void registerTiles(RegisterEvent.RegisterHelper<BlockEntityType<?>> helper) {
            Holder.entityTypes().forEach(Holder.NamedEntry.register(helper));
        }

        public static void registerContainers(RegisterEvent.RegisterHelper<MenuType<?>> helper) {
            Holder.menuTypes().forEach(Holder.NamedEntry.register(helper));
        }

        public static void registerRecipe(RegisterEvent.RegisterHelper<RecipeSerializer<?>> helper) {
            helper.register(WorkbenchRecipe.recipeLocation, (Object)WorkbenchRecipe.SERIALIZER);
            CraftingHelper.register((ResourceLocation)new ResourceLocation(QuarryPlus.modID, "enchantment_ingredient"), (IIngredientSerializer)EnchantmentIngredient.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)new EnableCondition.Serializer());
            CraftingHelper.register((IConditionSerializer)new QuarryDebugCondition.Serializer());
        }

        public static void registerRecipeType(RegisterEvent.RegisterHelper<RecipeType<?>> helper) {
            helper.register(WorkbenchRecipe.recipeLocation, WorkbenchRecipe.RECIPE_TYPE);
        }

        public static void registerArgument(RegisterEvent.RegisterHelper<ArgumentTypeInfo<?, ?>> helper) {
            helper.register(new ResourceLocation(QuarryPlus.modID, "config_argument"), (Object)ArgumentTypeInfos.registerByClass(ConfigCommand.SelectorArgument.class, ConfigCommand.INFO));
        }

        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            PacketHandler.init();
        }

        public static void registerCreativeTab(RegisterEvent.RegisterHelper<CreativeModeTab> helper) {
            helper.register(new ResourceLocation(QuarryPlus.modID, "tab"), (Object)Holder.createTab(CreativeModeTab.builder()));
        }
    }
}

