/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events.forge;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import journeymap.common.LoaderHooks;
import journeymap.common.command.CreateWaypoint;
import journeymap.common.events.ServerEventHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PermissionsChangedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeServerEvents {
    private final ServerEventHandler handler = new ServerEventHandler();

    @SubscribeEvent
    public void onPermissionChangedEvent(PermissionsChangedEvent event) {
        if (event.getEntity() instanceof ServerPlayer && event.getNewLevel() != event.getOldLevel()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = player.f_8924_;
            GameProfile profile = player.m_36316_();
            ServerOpList ops = server.m_6846_().m_11307_();
            if (event.getNewLevel() >= server.m_7022_()) {
                ops.m_11381_((StoredUserEntry)new ServerOpListEntry(profile, server.m_7022_(), ops.m_11351_(profile)));
            } else if (event.getNewLevel() == 0) {
                ops.m_11393_((Object)profile);
            }
            this.handler.sendConfigsToPlayer(player);
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && LoaderHooks.getServer() != null && LoaderHooks.getServer().m_6846_().m_11314_().size() < 1) {
            return;
        }
        ServerLevel world = LoaderHooks.getServer().m_129880_(Level.f_46428_);
        this.handler.onServerTickEvent((Level)world);
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.handler.onEntityJoinWorldEvent(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.handler.onPlayerLoggedInEvent(event.getEntity());
        }
    }

    @SubscribeEvent
    public void registerCommandEvent(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CreateWaypoint.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }
}

