/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceLocationArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> f_106977_ = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType f_106978_ = new DynamicCommandExceptionType(p_107010_ -> Component.m_237110_((String)"advancement.advancementNotFound", (Object[])new Object[]{p_107010_}));
    private static final DynamicCommandExceptionType f_106979_ = new DynamicCommandExceptionType(p_107005_ -> Component.m_237110_((String)"recipe.notFound", (Object[])new Object[]{p_107005_}));
    private static final DynamicCommandExceptionType f_106980_ = new DynamicCommandExceptionType(p_106998_ -> Component.m_237110_((String)"predicate.unknown", (Object[])new Object[]{p_106998_}));
    private static final DynamicCommandExceptionType f_171024_ = new DynamicCommandExceptionType(p_106991_ -> Component.m_237110_((String)"item_modifier.unknown", (Object[])new Object[]{p_106991_}));

    public static ResourceLocationArgument m_106984_() {
        return new ResourceLocationArgument();
    }

    public static Advancement m_106987_(CommandContext<CommandSourceStack> p_106988_, String p_106989_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.m_107011_(p_106988_, p_106989_);
        Advancement advancement = ((CommandSourceStack)p_106988_.getSource()).getAdvancement(resourcelocation);
        if (advancement == null) {
            throw f_106978_.create((Object)resourcelocation);
        }
        return advancement;
    }

    public static Recipe<?> m_106994_(CommandContext<CommandSourceStack> p_106995_, String p_106996_) throws CommandSyntaxException {
        RecipeManager recipemanager = ((CommandSourceStack)p_106995_.getSource()).getRecipeManager();
        ResourceLocation resourcelocation = ResourceLocationArgument.m_107011_(p_106995_, p_106996_);
        return recipemanager.m_44043_(resourcelocation).orElseThrow(() -> f_106979_.create((Object)resourcelocation));
    }

    public static LootItemCondition m_107001_(CommandContext<CommandSourceStack> p_107002_, String p_107003_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.m_107011_(p_107002_, p_107003_);
        LootDataManager lootdatamanager = ((CommandSourceStack)p_107002_.getSource()).m_81377_().m_278653_();
        LootItemCondition lootitemcondition = (LootItemCondition)lootdatamanager.m_278789_(LootDataType.f_278407_, resourcelocation);
        if (lootitemcondition == null) {
            throw f_106980_.create((Object)resourcelocation);
        }
        return lootitemcondition;
    }

    public static LootItemFunction m_171031_(CommandContext<CommandSourceStack> p_171032_, String p_171033_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocationArgument.m_107011_(p_171032_, p_171033_);
        LootDataManager lootdatamanager = ((CommandSourceStack)p_171032_.getSource()).m_81377_().m_278653_();
        LootItemFunction lootitemfunction = (LootItemFunction)lootdatamanager.m_278789_(LootDataType.f_278496_, resourcelocation);
        if (lootitemfunction == null) {
            throw f_171024_.create((Object)resourcelocation);
        }
        return lootitemfunction;
    }

    public static ResourceLocation m_107011_(CommandContext<CommandSourceStack> p_107012_, String p_107013_) {
        return (ResourceLocation)p_107012_.getArgument(p_107013_, ResourceLocation.class);
    }

    public ResourceLocation parse(StringReader p_106986_) throws CommandSyntaxException {
        return ResourceLocation.m_135818_(p_106986_);
    }

    public Collection<String> getExamples() {
        return f_106977_;
    }
}

