/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ServerEntity {
    private static final Logger f_8508_ = LogUtils.getLogger();
    private static final int f_143241_ = 1;
    private final ServerLevel f_8509_;
    private final Entity f_8510_;
    private final int f_8511_;
    private final boolean f_8512_;
    private final Consumer<Packet<?>> f_8513_;
    private final VecDeltaCodec f_214995_ = new VecDeltaCodec();
    private int f_8517_;
    private int f_8518_;
    private int f_8519_;
    private Vec3 f_8520_ = Vec3.f_82478_;
    private int f_8521_;
    private int f_8522_;
    private List<Entity> f_8523_ = Collections.emptyList();
    private boolean f_8524_;
    private boolean f_8525_;
    @Nullable
    private List<SynchedEntityData.DataValue<?>> f_263120_;

    public ServerEntity(ServerLevel p_8528_, Entity p_8529_, int p_8530_, boolean p_8531_, Consumer<Packet<?>> p_8532_) {
        this.f_8509_ = p_8528_;
        this.f_8513_ = p_8532_;
        this.f_8510_ = p_8529_;
        this.f_8511_ = p_8530_;
        this.f_8512_ = p_8531_;
        this.f_214995_.m_238033_(p_8529_.m_213870_());
        this.f_8517_ = Mth.m_14143_(p_8529_.m_146908_() * 256.0f / 360.0f);
        this.f_8518_ = Mth.m_14143_(p_8529_.m_146909_() * 256.0f / 360.0f);
        this.f_8519_ = Mth.m_14143_(p_8529_.m_6080_() * 256.0f / 360.0f);
        this.f_8525_ = p_8529_.m_20096_();
        this.f_263120_ = p_8529_.m_20088_().m_252804_();
    }

    public void m_8533_() {
        Entity entity;
        List<Entity> $$0 = this.f_8510_.m_20197_();
        if (!$$0.equals(this.f_8523_)) {
            this.f_8513_.accept(new ClientboundSetPassengersPacket(this.f_8510_));
            ServerEntity.m_277180_($$0, this.f_8523_).forEach(p_289307_ -> {
                if (p_289307_ instanceof ServerPlayer) {
                    ServerPlayer $$1 = (ServerPlayer)p_289307_;
                    $$1.f_8906_.m_9774_($$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), $$1.m_146908_(), $$1.m_146909_());
                }
            });
            this.f_8523_ = $$0;
        }
        if ((entity = this.f_8510_) instanceof ItemFrame) {
            ItemFrame $$1 = (ItemFrame)entity;
            if (this.f_8521_ % 10 == 0) {
                Integer $$3;
                MapItemSavedData $$4;
                ItemStack $$2 = $$1.m_31822_();
                if ($$2.m_41720_() instanceof MapItem && ($$4 = MapItem.m_151128_($$3 = MapItem.m_151131_($$2), this.f_8509_)) != null) {
                    for (ServerPlayer $$5 : this.f_8509_.m_6907_()) {
                        $$4.m_77918_($$5, $$2);
                        Packet<?> $$6 = $$4.m_164796_($$3, $$5);
                        if ($$6 == null) continue;
                        $$5.f_8906_.m_9829_($$6);
                    }
                }
                this.m_8543_();
            }
        }
        if (this.f_8521_ % this.f_8511_ == 0 || this.f_8510_.f_19812_ || this.f_8510_.m_20088_().m_135352_()) {
            if (this.f_8510_.m_20159_()) {
                boolean $$9;
                int $$7 = Mth.m_14143_(this.f_8510_.m_146908_() * 256.0f / 360.0f);
                int $$8 = Mth.m_14143_(this.f_8510_.m_146909_() * 256.0f / 360.0f);
                boolean bl = $$9 = Math.abs($$7 - this.f_8517_) >= 1 || Math.abs($$8 - this.f_8518_) >= 1;
                if ($$9) {
                    this.f_8513_.accept(new ClientboundMoveEntityPacket.Rot(this.f_8510_.m_19879_(), (byte)$$7, (byte)$$8, this.f_8510_.m_20096_()));
                    this.f_8517_ = $$7;
                    this.f_8518_ = $$8;
                }
                this.f_214995_.m_238033_(this.f_8510_.m_213870_());
                this.m_8543_();
                this.f_8524_ = true;
            } else {
                Vec3 $$23;
                double $$24;
                ++this.f_8522_;
                int $$10 = Mth.m_14143_(this.f_8510_.m_146908_() * 256.0f / 360.0f);
                int $$11 = Mth.m_14143_(this.f_8510_.m_146909_() * 256.0f / 360.0f);
                Vec3 $$12 = this.f_8510_.m_213870_();
                boolean $$13 = this.f_214995_.m_238031_($$12).m_82556_() >= 7.62939453125E-6;
                Packet<ClientGamePacketListener> $$14 = null;
                boolean $$15 = $$13 || this.f_8521_ % 60 == 0;
                boolean $$16 = Math.abs($$10 - this.f_8517_) >= 1 || Math.abs($$11 - this.f_8518_) >= 1;
                boolean $$17 = false;
                boolean $$18 = false;
                if (this.f_8521_ > 0 || this.f_8510_ instanceof AbstractArrow) {
                    boolean $$22;
                    long $$19 = this.f_214995_.m_238025_($$12);
                    long $$20 = this.f_214995_.m_238027_($$12);
                    long $$21 = this.f_214995_.m_238029_($$12);
                    boolean bl = $$22 = $$19 < -32768L || $$19 > 32767L || $$20 < -32768L || $$20 > 32767L || $$21 < -32768L || $$21 > 32767L;
                    if ($$22 || this.f_8522_ > 400 || this.f_8524_ || this.f_8525_ != this.f_8510_.m_20096_()) {
                        this.f_8525_ = this.f_8510_.m_20096_();
                        this.f_8522_ = 0;
                        $$14 = new ClientboundTeleportEntityPacket(this.f_8510_);
                        $$17 = true;
                        $$18 = true;
                    } else if ($$15 && $$16 || this.f_8510_ instanceof AbstractArrow) {
                        $$14 = new ClientboundMoveEntityPacket.PosRot(this.f_8510_.m_19879_(), (short)$$19, (short)$$20, (short)$$21, (byte)$$10, (byte)$$11, this.f_8510_.m_20096_());
                        $$17 = true;
                        $$18 = true;
                    } else if ($$15) {
                        $$14 = new ClientboundMoveEntityPacket.Pos(this.f_8510_.m_19879_(), (short)$$19, (short)$$20, (short)$$21, this.f_8510_.m_20096_());
                        $$17 = true;
                    } else if ($$16) {
                        $$14 = new ClientboundMoveEntityPacket.Rot(this.f_8510_.m_19879_(), (byte)$$10, (byte)$$11, this.f_8510_.m_20096_());
                        $$18 = true;
                    }
                }
                if ((this.f_8512_ || this.f_8510_.f_19812_ || this.f_8510_ instanceof LivingEntity && ((LivingEntity)this.f_8510_).m_21255_()) && this.f_8521_ > 0 && (($$24 = ($$23 = this.f_8510_.m_20184_()).m_82557_(this.f_8520_)) > 1.0E-7 || $$24 > 0.0 && $$23.m_82556_() == 0.0)) {
                    this.f_8520_ = $$23;
                    this.f_8513_.accept(new ClientboundSetEntityMotionPacket(this.f_8510_.m_19879_(), this.f_8520_));
                }
                if ($$14 != null) {
                    this.f_8513_.accept($$14);
                }
                this.m_8543_();
                if ($$17) {
                    this.f_214995_.m_238033_($$12);
                }
                if ($$18) {
                    this.f_8517_ = $$10;
                    this.f_8518_ = $$11;
                }
                this.f_8524_ = false;
            }
            int $$25 = Mth.m_14143_(this.f_8510_.m_6080_() * 256.0f / 360.0f);
            if (Math.abs($$25 - this.f_8519_) >= 1) {
                this.f_8513_.accept(new ClientboundRotateHeadPacket(this.f_8510_, (byte)$$25));
                this.f_8519_ = $$25;
            }
            this.f_8510_.f_19812_ = false;
        }
        ++this.f_8521_;
        if (this.f_8510_.f_19864_) {
            this.m_8538_(new ClientboundSetEntityMotionPacket(this.f_8510_));
            this.f_8510_.f_19864_ = false;
        }
    }

    private static Stream<Entity> m_277180_(List<Entity> p_277592_, List<Entity> p_277658_) {
        return p_277658_.stream().filter(p_275361_ -> !p_277592_.contains(p_275361_));
    }

    public void m_8534_(ServerPlayer p_8535_) {
        this.f_8510_.m_6452_(p_8535_);
        p_8535_.f_8906_.m_9829_(new ClientboundRemoveEntitiesPacket(this.f_8510_.m_19879_()));
    }

    public void m_8541_(ServerPlayer p_8542_) {
        ArrayList<Packet<ClientGamePacketListener>> $$1 = new ArrayList<Packet<ClientGamePacketListener>>();
        this.m_289200_(p_8542_, $$1::add);
        p_8542_.f_8906_.m_9829_(new ClientboundBundlePacket((Iterable<Packet<ClientGamePacketListener>>)$$1));
        this.f_8510_.m_6457_(p_8542_);
    }

    public void m_289200_(ServerPlayer p_289562_, Consumer<Packet<ClientGamePacketListener>> p_289563_) {
        Mob $$8;
        if (this.f_8510_.m_213877_()) {
            f_8508_.warn("Fetching packet for removed entity {}", (Object)this.f_8510_);
        }
        Packet<ClientGamePacketListener> $$2 = this.f_8510_.m_5654_();
        this.f_8519_ = Mth.m_14143_(this.f_8510_.m_6080_() * 256.0f / 360.0f);
        p_289563_.accept($$2);
        if (this.f_263120_ != null) {
            p_289563_.accept(new ClientboundSetEntityDataPacket(this.f_8510_.m_19879_(), this.f_263120_));
        }
        boolean $$3 = this.f_8512_;
        if (this.f_8510_ instanceof LivingEntity) {
            Collection<AttributeInstance> $$4 = ((LivingEntity)this.f_8510_).m_21204_().m_22170_();
            if (!$$4.isEmpty()) {
                p_289563_.accept(new ClientboundUpdateAttributesPacket(this.f_8510_.m_19879_(), $$4));
            }
            if (((LivingEntity)this.f_8510_).m_21255_()) {
                $$3 = true;
            }
        }
        this.f_8520_ = this.f_8510_.m_20184_();
        if ($$3 && !(this.f_8510_ instanceof LivingEntity)) {
            p_289563_.accept(new ClientboundSetEntityMotionPacket(this.f_8510_.m_19879_(), this.f_8520_));
        }
        if (this.f_8510_ instanceof LivingEntity) {
            ArrayList $$5 = Lists.newArrayList();
            for (EquipmentSlot $$6 : EquipmentSlot.values()) {
                ItemStack $$7 = ((LivingEntity)this.f_8510_).m_6844_($$6);
                if ($$7.m_41619_()) continue;
                $$5.add(Pair.of((Object)((Object)$$6), (Object)$$7.m_41777_()));
            }
            if (!$$5.isEmpty()) {
                p_289563_.accept(new ClientboundSetEquipmentPacket(this.f_8510_.m_19879_(), $$5));
            }
        }
        if (!this.f_8510_.m_20197_().isEmpty()) {
            p_289563_.accept(new ClientboundSetPassengersPacket(this.f_8510_));
        }
        if (this.f_8510_.m_20159_()) {
            p_289563_.accept(new ClientboundSetPassengersPacket(this.f_8510_.m_20202_()));
        }
        if (this.f_8510_ instanceof Mob && ($$8 = (Mob)this.f_8510_).m_21523_()) {
            p_289563_.accept(new ClientboundSetEntityLinkPacket($$8, $$8.m_21524_()));
        }
    }

    private void m_8543_() {
        SynchedEntityData $$0 = this.f_8510_.m_20088_();
        List<SynchedEntityData.DataValue<?>> $$1 = $$0.m_135378_();
        if ($$1 != null) {
            this.f_263120_ = $$0.m_252804_();
            this.m_8538_(new ClientboundSetEntityDataPacket(this.f_8510_.m_19879_(), $$1));
        }
        if (this.f_8510_ instanceof LivingEntity) {
            Set<AttributeInstance> $$2 = ((LivingEntity)this.f_8510_).m_21204_().m_22145_();
            if (!$$2.isEmpty()) {
                this.m_8538_(new ClientboundUpdateAttributesPacket(this.f_8510_.m_19879_(), $$2));
            }
            $$2.clear();
        }
    }

    private void m_8538_(Packet<?> p_8539_) {
        this.f_8513_.accept(p_8539_);
        if (this.f_8510_ instanceof ServerPlayer) {
            ((ServerPlayer)this.f_8510_).f_8906_.m_9829_(p_8539_);
        }
    }
}

